/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractContainerBox;
import com.amity.googlecode.mp4parser.util.ByteBufferByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MetaBox
extends AbstractContainerBox {
    private int version = 0;
    private int flags = 0;
    public static final String TYPE = "meta";

    public MetaBox() {
        super(TYPE);
    }

    @Override
    public long getContentSize() {
        if (this.isMp4Box()) {
            return 4L + super.getContentSize();
        }
        return super.getContentSize();
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        if (this.isMp4Box()) {
            return 12L;
        }
        return 8L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        int pos = content.position();
        content.get(new byte[4]);
        String isHdlr = IsoTypeReader.read4cc(content);
        if ("hdlr".equals(isHdlr)) {
            content.position(pos);
            this.version = -1;
            this.flags = -1;
        } else {
            content.position(pos);
            this.version = IsoTypeReader.readUInt8(content);
            this.flags = IsoTypeReader.readUInt24(content);
        }
        while (content.remaining() >= 8) {
            try {
                this.boxes.add(this.boxParser.parseBox(new ByteBufferByteChannel(content), this));
            }
            catch (IOException e) {
                throw new RuntimeException("Sebastian needs to fix 7518765283");
            }
        }
        if (content.remaining() > 0) {
            throw new RuntimeException("Sebastian needs to fix it 90732r26537");
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        if (this.isMp4Box()) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.version);
            IsoTypeWriter.writeUInt24(byteBuffer, this.flags);
        }
        this.writeChildBoxes(byteBuffer);
    }

    public boolean isMp4Box() {
        return this.version != -1 && this.flags != -1;
    }

    public void setMp4Box(boolean mp4) {
        if (mp4) {
            this.version = 0;
            this.flags = 0;
        } else {
            this.version = -1;
            this.flags = -1;
        }
    }
}

