/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.authoring.builder;

import com.amity.coremedia.iso.boxes.TimeToSampleBox;
import com.amity.googlecode.mp4parser.authoring.Movie;
import com.amity.googlecode.mp4parser.authoring.Track;
import com.amity.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import java.util.Arrays;
import java.util.List;

public class TwoSecondIntersectionFinder
implements FragmentIntersectionFinder {
    protected long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }

    @Override
    public long[] sampleNumbers(Track track, Movie movie) {
        int i;
        List<TimeToSampleBox.Entry> entries = track.getDecodingTimeEntries();
        double trackLength = 0.0;
        for (Track thisTrack : movie.getTracks()) {
            double thisTracksLength = this.getDuration(thisTrack) / thisTrack.getTrackMetaData().getTimescale();
            if (!(trackLength < thisTracksLength)) continue;
            trackLength = thisTracksLength;
        }
        int fragmentCount = (int)Math.ceil(trackLength / 2.0) - 1;
        if (fragmentCount < 1) {
            fragmentCount = 1;
        }
        long[] fragments = new long[fragmentCount];
        Arrays.fill(fragments, -1L);
        fragments[0] = 1L;
        long time = 0L;
        int samples = 0;
        for (TimeToSampleBox.Entry entry : entries) {
            int currentFragment;
            i = 0;
            while ((long)i < entry.getCount() && (currentFragment = (int)(time / track.getTrackMetaData().getTimescale() / 2L) + 1) < fragments.length) {
                fragments[currentFragment] = samples++ + 1;
                time += entry.getDelta();
                ++i;
            }
        }
        long last = samples + 1;
        for (i = fragments.length - 1; i >= 0; --i) {
            if (fragments[i] == -1L) {
                fragments[i] = last;
            }
            last = fragments[i];
        }
        return fragments;
    }
}

