/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.yasea;

import java.util.Arrays;

public final class SrsAllocator {
    private final int individualAllocationSize;
    private volatile int availableSentinel;
    private Allocation[] availableAllocations;

    public SrsAllocator(int individualAllocationSize) {
        this(individualAllocationSize, 0);
    }

    public SrsAllocator(int individualAllocationSize, int initialAllocationCount) {
        this.individualAllocationSize = individualAllocationSize;
        this.availableSentinel = initialAllocationCount + 10;
        this.availableAllocations = new Allocation[this.availableSentinel];
        for (int i = 0; i < this.availableSentinel; ++i) {
            this.availableAllocations[i] = new Allocation(individualAllocationSize);
        }
    }

    public synchronized Allocation allocate(int size) {
        for (int i = 0; i < this.availableSentinel; ++i) {
            if (this.availableAllocations[i].size() < size) continue;
            Allocation ret = this.availableAllocations[i];
            this.availableAllocations[i] = null;
            return ret;
        }
        return new Allocation(size > this.individualAllocationSize ? size : this.individualAllocationSize);
    }

    public synchronized void release(Allocation allocation) {
        allocation.clear();
        for (int i = 0; i < this.availableSentinel; ++i) {
            if (this.availableAllocations[i].size() != 0) continue;
            this.availableAllocations[i] = allocation;
            return;
        }
        if (this.availableSentinel + 1 > this.availableAllocations.length) {
            this.availableAllocations = Arrays.copyOf(this.availableAllocations, this.availableAllocations.length * 2);
        }
        this.availableAllocations[this.availableSentinel++] = allocation;
    }

    public class Allocation {
        private byte[] data;
        private int size;

        public Allocation(int size) {
            this.data = new byte[size];
            this.size = 0;
        }

        public byte[] array() {
            return this.data;
        }

        public int size() {
            return this.size;
        }

        public void appendOffset(int offset) {
            this.size += offset;
        }

        public void clear() {
            this.size = 0;
        }

        public void put(byte b) {
            this.data[this.size++] = b;
        }

        public void put(byte b, int pos) {
            this.data[pos++] = b;
            this.size = pos > this.size ? pos : this.size;
        }

        public void put(short s) {
            this.put((byte)s);
            this.put((byte)(s >>> 8));
        }

        public void put(int i) {
            this.put((byte)i);
            this.put((byte)(i >>> 8));
            this.put((byte)(i >>> 16));
            this.put((byte)(i >>> 24));
        }

        public void put(byte[] bs) {
            System.arraycopy(bs, 0, this.data, this.size, bs.length);
            this.size += bs.length;
        }
    }
}

