package co.androidian.network.utils;

import java.io.IOException;
import java.lang.annotation.Annotation;

import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

/**
 * <p>Retrofit error utility to parse error occurred during network calls.</p>
 * Created on 8/8/16.
 *
 * @author Omkar Todkar.
 */
public class ErrorParser {

    private Retrofit retrofit;

    public ErrorParser(Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    public Error parseError(Response<?> response) {
        Converter<ResponseBody, Error> converter = retrofit
                .responseBodyConverter(Error.class, new Annotation[0]);

        Error error;

        try {
            error = converter.convert(response.errorBody());
        } catch (Exception e) {
            return new Error();
        }
        return error;
    }

    /**
     * Type of errors during call,
     */
    public enum ErrorKind {
        /* Error raised during server call */
        HTTP,

        /* Error raised due call (No Internet, json deserialize, etc.) */
        NETWORK,

        /* Error raised due to unknown factor */
        UNKNOWN
    }

    /**
     * Error wrapper class with code and message.
     */
    public class Error {
        private int code;
        private String message;

        public int getCode() {
            return code;
        }

        public String getMessage() {
            return message;
        }
    }
}
