/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.android.fileselector;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import co.arcs.android.fileselector.MimeIconLoader;
import co.arcs.android.fileselector.R;
import co.arcs.android.fileselector.SelectionMode;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FileListAdapter
extends BaseAdapter {
    private final List<File> data = new ArrayList<File>();
    private final LayoutInflater inflater;
    private final MimeIconLoader mimeIcons;
    private final SelectionMode selectionMode;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM", Locale.getDefault());

    public FileListAdapter(Context context, SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.inflater = LayoutInflater.from((Context)context);
        this.mimeIcons = new MimeIconLoader(context);
    }

    public void setData(File[] files) {
        this.data.clear();
        for (int i = files.length - 1; i >= 0; --i) {
            this.data.add(files[i]);
        }
        Collections.sort(this.data, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                boolean rhsDir;
                boolean lhsDir = lhs.isDirectory();
                if (lhsDir ^ (rhsDir = rhs.isDirectory())) {
                    return lhsDir ? -1 : 1;
                }
                return lhs.getName().compareToIgnoreCase(rhs.getName());
            }
        });
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.data.size();
    }

    public File getItem(int position) {
        return this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.view_list_item, parent, false);
            holder = new ViewHolder();
            holder.icon = (ImageView)convertView.findViewById(R.id.icon);
            holder.title = (TextView)convertView.findViewById(R.id.title);
            holder.date = (TextView)convertView.findViewById(R.id.date);
            holder.size = (TextView)convertView.findViewById(R.id.size);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        File file = this.getItem(position);
        boolean enabled = this.isEnabled(position);
        holder.title.setText((CharSequence)file.getName());
        holder.date.setText((CharSequence)this.dateFormat.format(new Date(file.lastModified())));
        holder.size.setText(file.isDirectory() ? null : FileListAdapter.humanReadableByteCount(file.length(), true));
        holder.icon.setImageDrawable(this.mimeIcons.loadMimeIcon(file));
        holder.title.setEnabled(enabled);
        holder.date.setEnabled(enabled);
        holder.size.setEnabled(enabled);
        holder.icon.setAlpha(enabled ? 1.0f : 0.5f);
        return convertView;
    }

    public boolean isEnabled(int position) {
        if (this.selectionMode == SelectionMode.DIRECTORY) {
            return this.getItem(position).isDirectory();
        }
        return true;
    }

    private static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.US, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    static class ViewHolder {
        TextView title;
        TextView date;
        TextView size;
        ImageView icon;

        ViewHolder() {
        }
    }
}

