/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.android.fileselector;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.WindowManager;
import android.widget.TextView;
import co.arcs.android.fileselector.FileSelectorFragment;
import co.arcs.android.fileselector.R;
import java.io.File;
import java.io.Serializable;

public class FileSelectorActivity
extends Activity
implements FileSelectorFragment.Listener {
    private static final String FRAGMENT_TAG = "listFragment";
    public static final String EXTRA_STR_INITIAL_DIRECTORY = "initialDirectory";
    public static final String EXTRA_BOOL_ALLOW_UP_NAVIGATION_ABOVE_INITIAL_DIRECTORY = "allowUpNavigationAboveInitial";
    public static final String EXTRA_STR_SELECTION_TYPE = "selectionType";
    public static final String TYPE_DIRECTORY = "dir";
    public static final String TYPE_FILE = "file";
    public static final String EXTRA_BOOL_SHOW_FILES = "showFiles";
    public static final String EXTRA_BOOL_SHOW_HIDDEN = "showHidden";
    public static final String EXTRA_PICKED_FILE = "file";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedArray attr2 = this.getTheme().obtainStyledAttributes(new int[]{R.attr.showAsDialog});
        boolean showAsDialog = attr2.getBoolean(0, false);
        attr2.recycle();
        if (showAsDialog) {
            this.configureAsDialog();
        }
        this.configureActionBarSubtitle();
        if (savedInstanceState == null) {
            FileSelectorFragment fragment = new FileSelectorFragment();
            fragment.setArguments(this.getIntent().getExtras());
            this.getFragmentManager().beginTransaction().add(0x1020002, (Fragment)fragment, FRAGMENT_TAG).commit();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            Fragment fragment = this.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
            if (fragment != null) {
                ((FileSelectorFragment)fragment).onActionBarUpNavigation();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        FileSelectorFragment fragment = (FileSelectorFragment)this.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null || !fragment.onBackPressed()) {
            super.onBackPressed();
        }
    }

    @Override
    public void onFilePicked(File file) {
        Intent intent = new Intent();
        intent.putExtra("file", (Serializable)file);
        this.setResult(-1, intent);
        this.finish();
    }

    private void configureActionBarSubtitle() {
        TextView actionBarTitle = this.findActionBarSubtitle();
        if (actionBarTitle != null) {
            actionBarTitle.setEllipsize(TextUtils.TruncateAt.START);
        }
    }

    public void configureAsDialog() {
        int h;
        int w;
        this.requestWindowFeature(8);
        this.getWindow().setFlags(2, 2);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        boolean isPortrait = dm.widthPixels < dm.heightPixels;
        int[] ifPortrait = new int[]{R.attr.dialogWidthMinor, R.attr.dialogHeightMajor};
        int[] ifLandscape = new int[]{R.attr.dialogWidthMajor, R.attr.dialogHeightMinor};
        TypedArray ta = this.getTheme().obtainStyledAttributes(isPortrait ? ifPortrait : ifLandscape);
        TypedValue width = new TypedValue();
        TypedValue height = new TypedValue();
        ta.getValue(0, width);
        ta.getValue(1, height);
        if (width.type == 6) {
            w = (int)width.getFraction((float)dm.widthPixels, 1.0f);
        } else if (width.type == 5) {
            w = (int)width.getDimension(dm);
        } else {
            throw new RuntimeException();
        }
        if (height.type == 6) {
            h = (int)height.getFraction((float)dm.heightPixels, 1.0f);
        } else if (height.type == 5) {
            h = (int)height.getDimension(dm);
        } else {
            throw new RuntimeException();
        }
        ta.recycle();
        Log.d((String)"test", (String)("portrait=" + isPortrait + ", ww=" + dm.widthPixels + ", wh=" + dm.heightPixels + ", w=" + w + ", h=" + h));
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.width = w;
        params.height = h;
        params.alpha = 1.0f;
        params.dimAmount = 0.5f;
        this.getWindow().setAttributes(params);
    }

    private TextView findActionBarSubtitle() {
        int id2 = this.getResources().getIdentifier("action_bar_subtitle", "id", "android");
        if (id2 != 0) {
            try {
                return (TextView)this.findViewById(id2);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }
}

