/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.android.fileselector;

import android.app.ActionBar;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.Toast;
import co.arcs.android.fileselector.FileListAdapter;
import co.arcs.android.fileselector.FileSelectorListView;
import co.arcs.android.fileselector.FilenamePickerDialogFragment;
import co.arcs.android.fileselector.R;
import co.arcs.android.fileselector.SelectionMode;
import java.io.File;
import java.io.FileFilter;
import java.security.InvalidParameterException;
import java.util.Locale;

public class FileSelectorFragment
extends Fragment {
    public static final String ARG_STR_INITIAL_DIRECTORY = "initialDirectory";
    public static final String ARG_BOOL_ALLOW_UP_NAVIGATION_ABOVE_INITIAL_DIRECTORY = "allowUpNavigationAboveInitial";
    public static final String ARG_SELECTION_TYPE = "selectionType";
    public static final String ARG_SHOW_FILES = "showFiles";
    public static final String ARG_SHOW_HIDDEN = "showHidden";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_DIRECTORY = "dir";
    private File initialDirectory;
    private boolean allowNavigateUpAboveInitial;
    private SelectionMode selectionType;
    private boolean showFiles;
    private boolean showHidden;
    private ViewGroup container;
    private File file;
    private File selectedFile;
    private FileSelectorListView listView;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, int position, long rowId) {
            File file = (File)adapterView.getAdapter().getItem(position);
            if (file.isDirectory()) {
                FileSelectorFragment.this.navigate(file, NavigationAnimation.DOWN);
            }
            FileSelectorFragment.this.selectedFile = FileSelectorFragment.this.getSelectedItem();
            FileSelectorFragment.this.getActivity().invalidateOptionsMenu();
        }
    };

    public static FileSelectorFragment newInstance(String initialDirectory, boolean allowNavAboveInitial, SelectionMode selectionMode, boolean showFiles, boolean showHidden) {
        Bundle args = new Bundle();
        args.putString(ARG_STR_INITIAL_DIRECTORY, initialDirectory);
        args.putBoolean(ARG_BOOL_ALLOW_UP_NAVIGATION_ABOVE_INITIAL_DIRECTORY, allowNavAboveInitial);
        args.putString(ARG_SELECTION_TYPE, selectionMode == SelectionMode.FILE ? TYPE_FILE : TYPE_DIRECTORY);
        args.putBoolean(ARG_SHOW_FILES, showFiles);
        args.putBoolean(ARG_SHOW_HIDDEN, showHidden);
        FileSelectorFragment fragment = new FileSelectorFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        Bundle args = this.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        this.initialDirectory = new File(args.getString(ARG_STR_INITIAL_DIRECTORY, Environment.getExternalStorageDirectory().getPath()));
        if (!this.initialDirectory.isDirectory()) {
            throw new InvalidParameterException(String.format(Locale.US, "'%s' is not a directory", this.initialDirectory));
        }
        this.allowNavigateUpAboveInitial = args.getBoolean(ARG_BOOL_ALLOW_UP_NAVIGATION_ABOVE_INITIAL_DIRECTORY, false);
        this.selectionType = args.getString(ARG_SELECTION_TYPE, TYPE_FILE).equals(TYPE_FILE) ? SelectionMode.FILE : SelectionMode.DIRECTORY;
        this.showFiles = args.getBoolean(ARG_SHOW_FILES, true);
        this.showHidden = args.getBoolean(ARG_SHOW_HIDDEN, false);
        if (this.selectionType == SelectionMode.DIRECTORY) {
            this.selectedFile = this.initialDirectory;
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_listview, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.container = (ViewGroup)view.findViewById(R.id.container);
        this.navigate(this.initialDirectory, NavigationAnimation.NONE);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.file_picker, menu2);
        MenuItem acceptItem = menu2.findItem(R.id.accept);
        acceptItem.setVisible(this.selectedFile != null);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.add_folder) {
            FilenamePickerDialogFragment fragment = new FilenamePickerDialogFragment();
            fragment.setListener(new FilenamePickerDialogFragment.Listener(){

                @Override
                public void onFilenameSet(String filename) {
                    File directory = new File(FileSelectorFragment.this.file, filename);
                    if (directory.exists()) {
                        this.showToast(R.string.new_folder_error_already_exists);
                    } else {
                        directory.mkdir();
                        FileSelectorFragment.this.navigate(FileSelectorFragment.this.file, NavigationAnimation.NONE);
                        this.showToast(R.string.new_folder_success);
                    }
                }

                private void showToast(int res) {
                    Toast.makeText((Context)FileSelectorFragment.this.getActivity(), (CharSequence)FileSelectorFragment.this.getString(res), (int)1).show();
                }
            });
            fragment.show(this.getFragmentManager(), null);
            return true;
        }
        if (id2 == R.id.accept) {
            Activity act = this.getActivity();
            if (act instanceof Listener) {
                ((Listener)act).onFilePicked(this.selectedFile);
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onBackPressed() {
        if (this.canNavigateUp()) {
            this.navigate(this.file.getParentFile(), NavigationAnimation.UP);
            return true;
        }
        return false;
    }

    public void onActionBarUpNavigation() {
        if (this.canNavigateUp()) {
            this.navigate(this.file.getParentFile(), NavigationAnimation.UP);
        }
    }

    private boolean canNavigateUp() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.isDirectory()) {
            return false;
        }
        return !this.file.equals(this.initialDirectory) || this.allowNavigateUpAboveInitial;
    }

    private void navigate(File nextDir, NavigationAnimation direction) {
        this.file = nextDir;
        ActionBar actionBar = this.getActivity().getActionBar();
        actionBar.setSubtitle((CharSequence)nextDir.getPath());
        boolean canNavigateUp = this.canNavigateUp();
        actionBar.setDisplayHomeAsUpEnabled(canNavigateUp);
        actionBar.setHomeButtonEnabled(canNavigateUp);
        final FileSelectorListView oldListView = this.listView;
        if (oldListView != null) {
            oldListView.setOnItemClickListener(null);
        }
        File[] files = this.getFilesToDisplayForPath(nextDir);
        FileListAdapter adapter = new FileListAdapter((Context)this.getActivity(), this.selectionType);
        adapter.setData(files);
        this.listView = new FileSelectorListView((Context)this.getActivity(), null, 16842868);
        this.listView.setAdapter((ListAdapter)adapter);
        this.listView.setOnItemClickListener(this.onItemClickListener);
        if (direction == NavigationAnimation.NONE) {
            this.container.removeView((View)oldListView);
            this.container.addView((View)this.listView);
        } else {
            if (direction == NavigationAnimation.UP) {
                this.container.addView((View)this.listView, this.container.indexOfChild((View)oldListView));
            } else if (direction == NavigationAnimation.DOWN) {
                this.container.addView((View)this.listView);
            }
            float startPosition = direction == NavigationAnimation.UP ? 0.0f : (float)this.container.getWidth();
            float endPosition = direction == NavigationAnimation.UP ? (float)this.container.getWidth() : 0.0f;
            float startAlpha = direction == NavigationAnimation.UP ? 1.0f : 0.0f;
            float endAlpha = direction == NavigationAnimation.UP ? 0.0f : 1.0f;
            FileSelectorListView animatedView = direction == NavigationAnimation.UP ? oldListView : this.listView;
            AnimationSet animationSet = new AnimationSet(true);
            animationSet.addAnimation((Animation)new AlphaAnimation(startAlpha, endAlpha));
            animationSet.addAnimation((Animation)new TranslateAnimation(startPosition, endPosition, 0.0f, 0.0f));
            animationSet.setInterpolator((Interpolator)new DecelerateInterpolator());
            animationSet.setDuration((long)this.getResources().getInteger(0x10E0001));
            animationSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (oldListView != null) {
                        FileSelectorFragment.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                FileSelectorFragment.this.container.removeView((View)oldListView);
                            }
                        });
                    }
                }
            });
            animatedView.startAnimation((Animation)animationSet);
        }
    }

    private File getSelectedItem() {
        if (this.selectionType == SelectionMode.DIRECTORY && this.file.isDirectory()) {
            return this.file;
        }
        int checked = this.listView.getCheckedItemPosition();
        if (checked != -1) {
            File file = ((FileListAdapter)this.listView.getAdapter()).getItem(checked);
            return this.selectionType == SelectionMode.FILE ^ !file.isFile() ? file : null;
        }
        return null;
    }

    private File[] getFilesToDisplayForPath(File nextDir) {
        return nextDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!FileSelectorFragment.this.showFiles && pathname.isFile()) {
                    return false;
                }
                return FileSelectorFragment.this.showHidden || !pathname.getName().startsWith(".");
            }
        });
    }

    private static enum NavigationAnimation {
        UP,
        DOWN,
        NONE;

    }

    static interface Listener {
        public void onFilePicked(File var1);
    }
}

