/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.android.fileselector;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.ListView;
import co.arcs.android.fileselector.R;

class FileSelectorListView
extends ListView {
    public FileSelectorListView(Context context) {
        this(context, null);
    }

    public FileSelectorListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FileSelectorListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOpaqueBackgroundColor(context);
        this.setChoiceMode(1);
    }

    @SuppressLint(value={"NewApi"})
    private void setOpaqueBackgroundColor(Context context) {
        TypedArray attr2 = context.getTheme().obtainStyledAttributes(new int[]{R.attr.showAsDialog});
        boolean inDialog = attr2.getBoolean(0, false);
        attr2.recycle();
        int resId = inDialog ? R.attr.colorDialogBackground : 16842836;
        TypedValue backgroundValue = new TypedValue();
        context.getTheme().resolveAttribute(resId, backgroundValue, true);
        if (backgroundValue.type >= 28 && backgroundValue.type <= 31) {
            this.setBackgroundColor(backgroundValue.data);
        } else {
            Drawable d = context.getResources().getDrawable(backgroundValue.resourceId);
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(d);
            } else {
                this.setBackgroundDrawable(d);
            }
        }
    }
}

