/*
 * Decompiled with CFR 0.152.
 */
package co.arcs.android.fileselector;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import co.arcs.android.fileselector.R;

public class FilenamePickerDialogFragment
extends DialogFragment {
    private AlertDialog dialog;
    private EditText editText;
    private Listener listener;
    private DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            String filename = FilenamePickerDialogFragment.this.getFilenameFromField();
            if (FilenamePickerDialogFragment.this.listener != null) {
                FilenamePickerDialogFragment.this.listener.onFilenameSet(filename);
            }
        }
    };
    private final TextWatcher textWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            FilenamePickerDialogFragment.this.okButton.setEnabled(FilenamePickerDialogFragment.this.getFilenameFromField().length() > 0);
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
        }
    };
    private final InputFilter inputFilter = new InputFilter(){

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (source instanceof SpannableStringBuilder) {
                SpannableStringBuilder sourceAsSpannableBuilder = (SpannableStringBuilder)source;
                for (int i = end - 1; i >= start; --i) {
                    char currentChar = source.charAt(i);
                    if (this.checkChar(currentChar)) continue;
                    sourceAsSpannableBuilder.delete(i, i + 1);
                }
                return source;
            }
            StringBuilder filteredStringBuilder = new StringBuilder();
            for (int i = start; i < end; ++i) {
                char currentChar = source.charAt(i);
                if (!this.checkChar(currentChar)) continue;
                filteredStringBuilder.append(currentChar);
            }
            return filteredStringBuilder.toString();
        }

        private boolean checkChar(char c) {
            return Character.isLetterOrDigit(c) || c == ' ';
        }
    };
    private Button okButton;

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View contentView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.view_new_folder_dialog, null);
        this.editText = (EditText)contentView.findViewById(R.id.folder_name);
        this.editText.setFilters(new InputFilter[]{this.inputFilter});
        this.editText.addTextChangedListener(this.textWatcher);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.new_folder_title));
        builder.setView(contentView);
        builder.setNegativeButton(0x1040000, null);
        builder.setPositiveButton(17039370, this.onClickListener);
        this.dialog = builder.create();
        return this.dialog;
    }

    public void onStart() {
        super.onStart();
        this.okButton = this.dialog.getButton(-1);
        this.okButton.setEnabled(false);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    private String getFilenameFromField() {
        return this.editText.getText().toString().trim();
    }

    static interface Listener {
        public void onFilenameSet(String var1);
    }
}

