/*
 * Copyright © 2018 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package co.cask.cdap.data2.metadata.writer;

import co.cask.cdap.data2.metadata.lineage.field.FieldLineageInfo;
import co.cask.cdap.proto.id.ProgramRunId;

/**
 * Defines an interface to write the field lineage information for a program run.
 */
public interface FieldLineageWriter {

  /**
   * Write the lineage information associated with the given program run.
   * Its caller's responsibility to wrap the call in transaction, if writing to
   * the transactional store.
   *
   * @param programRunId run id of the program
   * @param info a {@link FieldLineageInfo} associated with the program.
   */
  void write(ProgramRunId programRunId, FieldLineageInfo info);
}
