/*
 * Copyright © 2014 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package co.cask.cdap.data2.transaction.queue;

import co.cask.cdap.common.utils.ImmutablePair;

import java.io.IOException;
import java.util.Map;

/**
 * Interface for queue scan operation.
 */
public interface QueueScanner {

  ImmutablePair<byte[], Map<byte[], byte[]>> next() throws IOException;

  void close() throws IOException;

  QueueScanner EMPTY = new QueueScanner() {
    @Override
    public ImmutablePair<byte[], Map<byte[], byte[]>> next() throws IOException {
      return null;
    }

    @Override
    public void close() throws IOException {
      // no-op
    }
  };
}
