/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase11;

import co.cask.tephra.AbstractTransactionAwareTable;
import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TxConstants;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAwareHTable
extends AbstractTransactionAwareTable
implements HTableInterface,
TransactionAware {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionAwareHTable.class);
    private final HTableInterface hTable;

    public TransactionAwareHTable(HTableInterface hTable) {
        this(hTable, false);
    }

    public TransactionAwareHTable(HTableInterface hTable, TxConstants.ConflictDetection conflictLevel) {
        this(hTable, conflictLevel, false);
    }

    public TransactionAwareHTable(HTableInterface hTable, boolean allowNonTransactional) {
        this(hTable, TxConstants.ConflictDetection.COLUMN, allowNonTransactional);
    }

    public TransactionAwareHTable(HTableInterface hTable, TxConstants.ConflictDetection conflictLevel, boolean allowNonTransactional) {
        super(conflictLevel, allowNonTransactional);
        this.hTable = hTable;
    }

    protected byte[] getTableKey() {
        return this.getTableName();
    }

    protected boolean doCommit() throws IOException {
        this.hTable.flushCommits();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRollback() throws Exception {
        try {
            int size = 0;
            for (Set cs : this.changeSets.values()) {
                size += cs.size();
            }
            ArrayList<Delete> rollbackDeletes = new ArrayList<Delete>(size);
            for (Map.Entry entry : this.changeSets.entrySet()) {
                long transactionTimestamp = (Long)entry.getKey();
                for (AbstractTransactionAwareTable.ActionChange change : (Set)entry.getValue()) {
                    byte[] row = change.getRow();
                    byte[] family = change.getFamily();
                    byte[] qualifier = change.getQualifier();
                    Delete rollbackDelete = new Delete(row);
                    rollbackDelete.setAttribute("cask.tx.rollback", new byte[0]);
                    switch (this.conflictLevel) {
                        case ROW: 
                        case NONE: {
                            rollbackDelete.deleteFamilyVersion(change.getFamily(), transactionTimestamp);
                            break;
                        }
                        case COLUMN: {
                            if (family != null && qualifier == null) {
                                rollbackDelete.deleteFamilyVersion(family, transactionTimestamp);
                                break;
                            }
                            if (family == null || qualifier == null) break;
                            rollbackDelete.deleteColumn(family, qualifier, transactionTimestamp);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown conflict detection level: " + this.conflictLevel);
                        }
                    }
                    rollbackDeletes.add(rollbackDelete);
                }
            }
            this.hTable.delete(rollbackDeletes);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                this.hTable.flushCommits();
            }
            catch (Exception e) {
                LOG.error("Could not flush HTable commits", (Throwable)e);
            }
            this.tx = null;
            this.changeSets.clear();
        }
    }

    public byte[] getTableName() {
        return this.hTable.getTableName();
    }

    public TableName getName() {
        return this.hTable.getName();
    }

    public Configuration getConfiguration() {
        return this.hTable.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.hTable.getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.exists(this.transactionalizeAction(get));
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>(gets.size());
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.exists(transactionalizedGets);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.batch(this.transactionalizeActions(actions), results);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.batch(this.transactionalizeActions(actions));
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.batchCallback(this.transactionalizeActions(actions), results, callback);
    }

    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.batchCallback(this.transactionalizeActions(actions), callback);
    }

    public Result get(Get get) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.get(this.transactionalizeAction(get));
    }

    public Result[] get(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>();
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.get(transactionalizedGets);
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.getRowOrBefore(row, family);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public void put(Put put) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Put txPut = this.transactionalizeAction(put);
        this.hTable.put(txPut);
    }

    public void put(List<Put> puts) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Put> transactionalizedPuts = new ArrayList<Put>(puts.size());
        for (Put put : puts) {
            Put txPut = this.transactionalizeAction(put);
            transactionalizedPuts.add(txPut);
        }
        this.hTable.put(transactionalizedPuts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndPut(row, family, qualifier, value, put);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public void delete(Delete delete) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.delete(this.transactionalizeAction(delete));
    }

    public void delete(List<Delete> deletes) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Delete> transactionalizedDeletes = new ArrayList<Delete>(deletes.size());
        for (Delete delete : deletes) {
            Delete txDelete = this.transactionalizeAction(delete);
            transactionalizedDeletes.add(txDelete);
        }
        this.hTable.delete(transactionalizedDeletes);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndDelete(row, family, qualifier, value, delete);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndDelete(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Delete delete) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndDelete(bytes, bytes1, bytes2, compareOp, bytes3, delete);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndPut(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Put put) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndPut(bytes, bytes1, bytes2, compareOp, bytes3, put);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>(gets.size());
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.existsAll(transactionalizedGets);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rowMutations) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndMutate(row, family, qualifier, compareOp, value, rowMutations);
        }
        throw new UnsupportedOperationException("checkAndMutate operation is not supported transactionally");
    }

    public void mutateRow(RowMutations rm) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        RowMutations transactionalMutations = new RowMutations();
        for (Mutation mutation : rm.getMutations()) {
            if (mutation instanceof Put) {
                transactionalMutations.add(this.transactionalizeAction((Put)mutation));
                continue;
            }
            if (!(mutation instanceof Delete)) continue;
            transactionalMutations.add(this.transactionalizeAction((Delete)mutation));
        }
        this.hTable.mutateRow(transactionalMutations);
    }

    public Result append(Append append) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.append(append);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public Result increment(Increment increment) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.increment(increment);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount, durability);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean isAutoFlush() {
        return this.hTable.isAutoFlush();
    }

    public void flushCommits() throws IOException {
        this.hTable.flushCommits();
    }

    public void close() throws IOException {
        this.hTable.close();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.hTable.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.hTable.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.hTable.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return this.hTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.hTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.setAutoFlushTo(autoFlush);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.hTable.setAutoFlush(autoFlush, clearBufferOnFail);
    }

    public void setAutoFlushTo(boolean autoFlush) {
        this.hTable.setAutoFlushTo(autoFlush);
    }

    public long getWriteBufferSize() {
        return this.hTable.getWriteBufferSize();
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.hTable.setWriteBufferSize(writeBufferSize);
    }

    private Get transactionalizeAction(Get get) throws IOException {
        this.addToOperation((OperationWithAttributes)get, this.tx);
        return get;
    }

    private Scan transactionalizeAction(Scan scan) throws IOException {
        this.addToOperation((OperationWithAttributes)scan, this.tx);
        return scan;
    }

    private Put transactionalizeAction(Put put) throws IOException {
        Put txPut = new Put(put.getRow(), this.tx.getWritePointer());
        Set familyMap = put.getFamilyCellMap().entrySet();
        if (!familyMap.isEmpty()) {
            for (Map.Entry family : familyMap) {
                List familyValues = (List)family.getValue();
                if (familyValues.isEmpty()) continue;
                for (Cell value : familyValues) {
                    txPut.add(value.getFamily(), value.getQualifier(), this.tx.getWritePointer(), value.getValue());
                    this.addToChangeSet(txPut.getRow(), value.getFamily(), value.getQualifier());
                }
            }
        }
        for (Map.Entry entry : put.getAttributesMap().entrySet()) {
            txPut.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        txPut.setDurability(put.getDurability());
        this.addToOperation((OperationWithAttributes)txPut, this.tx);
        return txPut;
    }

    private Delete transactionalizeAction(Delete delete) throws IOException {
        long transactionTimestamp = this.tx.getWritePointer();
        byte[] deleteRow = delete.getRow();
        Delete txDelete = new Delete(deleteRow, transactionTimestamp);
        NavigableMap familyToDelete = delete.getFamilyCellMap();
        if (familyToDelete.isEmpty()) {
            if (this.conflictLevel == TxConstants.ConflictDetection.ROW || this.conflictLevel == TxConstants.ConflictDetection.NONE) {
                for (HColumnDescriptor columnDescriptor : this.hTable.getTableDescriptor().getColumnFamilies()) {
                    this.addToChangeSet(deleteRow, columnDescriptor.getName(), null);
                }
            } else {
                Result result = this.get(new Get(delete.getRow()));
                NavigableMap resultMap = result.getNoVersionMap();
                for (Map.Entry familyEntry : resultMap.entrySet()) {
                    NavigableMap familyColumns = result.getFamilyMap((byte[])familyEntry.getKey());
                    for (Map.Entry entry : familyColumns.entrySet()) {
                        txDelete.deleteColumns((byte[])familyEntry.getKey(), (byte[])entry.getKey(), transactionTimestamp);
                        this.addToChangeSet(deleteRow, (byte[])familyEntry.getKey(), (byte[])entry.getKey());
                    }
                }
            }
        } else {
            for (Map.Entry familyEntry : familyToDelete.entrySet()) {
                byte[] family = (byte[])familyEntry.getKey();
                List entries = (List)familyEntry.getValue();
                boolean isFamilyDelete = false;
                if (entries.size() == 1) {
                    Cell cell = (Cell)entries.get(0);
                    isFamilyDelete = CellUtil.isDeleteFamily((Cell)cell);
                }
                if (isFamilyDelete) {
                    if (this.conflictLevel == TxConstants.ConflictDetection.ROW || this.conflictLevel == TxConstants.ConflictDetection.NONE) {
                        txDelete.deleteFamily(family);
                        this.addToChangeSet(deleteRow, family, null);
                        continue;
                    }
                    Result result = this.get(new Get(delete.getRow()).addFamily(family));
                    NavigableMap navigableMap = result.getFamilyMap(family);
                    for (Map.Entry column : navigableMap.entrySet()) {
                        txDelete.deleteColumns(family, (byte[])column.getKey(), transactionTimestamp);
                        this.addToChangeSet(deleteRow, family, (byte[])column.getKey());
                    }
                    continue;
                }
                for (Cell cell : entries) {
                    txDelete.deleteColumns(cell.getFamily(), cell.getQualifier(), transactionTimestamp);
                    this.addToChangeSet(deleteRow, cell.getFamily(), cell.getQualifier());
                }
            }
        }
        for (Map.Entry entry : delete.getAttributesMap().entrySet()) {
            txDelete.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        txDelete.setDurability(delete.getDurability());
        return txDelete;
    }

    private List<? extends Row> transactionalizeActions(List<? extends Row> actions) throws IOException {
        ArrayList<Object> transactionalizedActions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                transactionalizedActions.add(this.transactionalizeAction((Get)row));
                continue;
            }
            if (row instanceof Put) {
                transactionalizedActions.add(this.transactionalizeAction((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                transactionalizedActions.add(this.transactionalizeAction((Delete)row));
                continue;
            }
            transactionalizedActions.add(row);
        }
        return transactionalizedActions;
    }

    public void addToOperation(OperationWithAttributes op, Transaction tx) throws IOException {
        op.setAttribute("cask.tx", this.txCodec.encode(tx));
    }
}

