package cus360.inapp.app;

import java.io.File;
import java.util.HashMap;

import org.json.JSONObject;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebSettings.PluginState;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.LinearLayout.LayoutParams;
import cus360.inapp.app.chat.ActivityChat;
import cus360.inapp.app.chat.FragmentChat;
import cus360.inapp.app.ticket.ticketlisting.ActivityTicketListing;
import cus360.inapp.app.ticket.ticketlisting.FragmentTicketListing;
import cus360.inapp.base.ActivityCustomerBase;
import cus360.inapp.base.HomerLibs.HomerLogger;
import cus360.inapp.base.HomerLibs.HomerSharedPrefrenceHelper;
import cus360.inapp.widget.ActionBarCustomPort;

/**
 * Cus360 is the main wrapper class that the user will interact with it is based
 * on singelton principle where the constructor of the class is hidden by
 * encapsulating it to private, ensuring that only one instance of this class
 * can ever be instantiated.
 * 
 * The user needs to instantiante the Cus360 class in his app by calling
 * 
 * Cus360.install(context, "your_access_token")
 * 
 * in his onCreate.. after which , he can use the showTicets and showChat
 * functions to display those respective modules
 * 
 * @author aman
 * 
 */
public class Cus360 {
	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////////Singelton
	// functionality/////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	/**
	 * singelton instance of cus360
	 */
	private static Cus360 mInstance = new Cus360();

	/**
	 * empty private constructor
	 */
	private Cus360() {

	}

	/**
	 * Returns the singelton Instance of Cus360 class
	 * 
	 * @return
	 */
	public static Cus360 getInstance() {
		if (mInstance == null) {
			mInstance = new Cus360();
		}
		return mInstance;
	}

	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////////Singelton functionality ends
	// /////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////////install functionality
	// /////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	private static ModelAccessToken mMAccessTokenHelpDesk = new ModelAccessToken();

	public ModelAccessToken getmMAccessTokenHelpDesk(Context context) {
		if (getInstance().mMAccessTokenHelpDesk == null) {

			getInstance().mMAccessTokenHelpDesk = new ModelAccessToken(
					HomerSharedPrefrenceHelper.getPref(context).getString(
							mStrKeyAcessTokenHelpDesk, ""));
		}
		return getInstance().mMAccessTokenHelpDesk;
	}

	public void setmMAccessTokenHelpDesk(Context context,ModelAccessToken mMAccessTokenHelpDesk) {
		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putString(mStrKeyAcessTokenHelpDesk, mMAccessTokenHelpDesk.toString()).commit();

		getInstance().mMAccessTokenHelpDesk = null;
		getInstance().getmMAccessTokenHelpDesk(context);

	}

	/**
	 * Your App Api Key. you will find this at your customer 360 dashbaord App
	 * Api Key is a required parameter without which the whole sdk module won't
	 * work . access token is sent in every api qerry , and if it is not valid
	 * none of the librray featurs will work So if you ever encounter Invalid
	 * Access token , Contact Custoer 360 dashboard
	 */
	private String mStrAppApiKey = null;

	/**
	 * App Api Key getter
	 * 
	 * @param context
	 * @return
	 */
	public static String getAppApiKey(Context context) {

		if (getInstance().mStrAppApiKey == null) {
			getInstance().mStrAppApiKey = HomerSharedPrefrenceHelper.getPref(
					context).getString(mStrKeyAppApiKey, "");
		}
		return getInstance().mStrAppApiKey;
	}

	/**
	 * App Api Key Setter
	 * 
	 * @param context
	 * @param mStrAppApiKey
	 */
	private static void setAppApiKey(Context context, String mStrAppApiKey) {

		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putString(mStrKeyAppApiKey, mStrAppApiKey).commit();

		getInstance().mStrAppApiKey = null;
		getInstance().getAppApiKey(context);
	}

	/**
	 * This is a private falg to check if access token supplied to library has
	 * been changed . The Customer 360 sdk uses this flag to determine if access
	 * token needs to be re verified from the server .
	 * 
	 */
	private Boolean mBoolAcessTokenHasBeenChanged = null;

	/**
	 * mBoolAcessTokenHasBeenChanged getter
	 * 
	 * @param context
	 * @return
	 */

	public Boolean getmBoolAcessTokenHasBeenChanged(Context context) {

		if (getInstance().mBoolAcessTokenHasBeenChanged == null) {
			getInstance().mBoolAcessTokenHasBeenChanged = HomerSharedPrefrenceHelper
					.getPref(context).getBoolean(
							mStrKeyAcessTokenHasBeenChanged, true);
		}
		return getInstance().mBoolAcessTokenHasBeenChanged;
	}

	/**
	 * mBoolAcessTokenHasBeenChanged setter
	 * 
	 * @param context
	 * @return
	 */
	public void setmBoolAcessTokenHasBeenChanged(Context context, Boolean bool) {
		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putBoolean(mStrKeyAcessTokenHasBeenChanged, bool).commit();
		getInstance().mBoolAcessTokenHasBeenChanged = null;
		getInstance().getmBoolAcessTokenHasBeenChanged(context);
	}

	/**
	 * Install is the main function that the user of this library uses to
	 * instantiate the customer 360 SDK module..
	 * 
	 * @param context
	 * @param AppApiKey
	 */
	public static void install(Context context, String AppApiKey) {
		install(context, AppApiKey, null);
	}

	/**
	 * * Install is the main function that the user of this library uses to
	 * instantiate the customer 360 SDK module..
	 * 
	 * HashMap keys
	 * 
	 * @param context
	 * @param mStrAppApiKey
	 *            : your acces token , you can find your access token at your
	 *            dashboard by logging in your customer 360 account.
	 * @param mHmConfig
	 *            : usage of mHmConfig is such that all the variables can be
	 *            set.
	 * 
	 *            example : HashMap<String , Object> mHashMap = new
	 *            HashMap<String,Object>();
	 *            mHashMap.put(Cus360.mStrKeyColor,R.color.red);
	 *            mHashMap.put(Cus360.mStrKeyLogo,R.drawable.logo);
	 *            mHashMap.put(Cus360.mStrKeyTittle,"Tittle");
	 *            mHashMap.put(Cus360.mStrKeyEnableNotification,true);
	 * 
	 */
	public static void install(Context context, String mStrAppApiKey,
			HashMap<String, Object> mHmConfig) {

		if (getInstance().getAppApiKey(context).equals(mStrAppApiKey)) {
			getInstance().setmBoolAcessTokenHasBeenChanged(context, false);
		} else {
			getInstance().setmBoolAcessTokenHasBeenChanged(context, true);
		}

		
		getInstance().setEnvironmentType(context, EnvironmentTypes.LIVE);
		getInstance().setAppApiKey(context, mStrAppApiKey);
		if (mHmConfig != null) {
			try {
				if (mHmConfig.containsKey(mStrKeyColor)) {
					getInstance().setThemeColor(
							(Integer) mHmConfig.get(mStrKeyColor));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			try {
				if (mHmConfig.containsKey(mStrKeyLogo)) {
					getInstance().setLogo((Integer) mHmConfig.get(mStrKeyLogo));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			try {
				if (mHmConfig.containsKey(mStrKeyTittle)) {
					getInstance().setTitle(
							(String) mHmConfig.get(mStrKeyTittle));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			try {
				if (mHmConfig.containsKey(mStrKeyEnableNotification)) {

					Boolean bool = (Boolean) mHmConfig
							.get(mStrKeyEnableNotification);
					if (bool != null && bool) {
						getInstance().enableNotifications(context);
					} else {
						getInstance().disableNotifications(context);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			try {
				if (mHmConfig.containsKey(mStrKeyEnvironmentType)) {

					EnvironmentTypes environmentType = (EnvironmentTypes) mHmConfig
							.get(mStrKeyEnvironmentType);
					if (environmentType != null) {

						if (getInstance().getEnvironmentType(context) == environmentType) {
							getInstance().setmBoolAcessTokenHasBeenChanged(
									context, false);

						} else {
							getInstance().setmBoolAcessTokenHasBeenChanged(
									context, true);
						}

						getInstance().setEnvironmentType(context,
								environmentType);
					}
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}

	}

	/**
	 * This function is used by Customer 360 sdk module to ..check if access
	 * token has been verified so that the module doesn't verify access token
	 * everytime from the api
	 * 
	 * @param context
	 * @return
	 */
	public static Boolean hasAccessTokenBeenVerifiedSuccesfully(Context context) {
		Boolean result = false;
		if (checkIfStringIsNitherNullNorEmpty(getInstance()
				.getmMAccessTokenHelpDesk(context).getmStrAccessToken())
				&& checkIfStringIsNitherNullNorEmpty(getInstance()
						.getmStrSenderId(context))
//				&& checkIfStringIsNitherNullNorEmpty(getInstance()
//						.getmStrChatUrl(context))
				&& checkIfStringIsNitherNullNorEmpty(getInstance()
						.getAppApiKey(context))
				&& !getInstance().getmBoolAcessTokenHasBeenChanged(context)) {
			result = true;
		}

		return result;
	}

	/**
	 * Does as the name says .. pretty straight forward
	 * 
	 * @param mStr
	 * @return
	 */
	public static Boolean checkIfStringIsNitherNullNorEmpty(String mStr) {

		try {
			return (mStr != null && !mStr.trim().equals("")) ? true : false;
		} catch (Exception e1) {
			e1.printStackTrace();
			return false;
		}

	}
//
//	/**
//	 * This function is used by Customer 360 sdk module to ..check if Install
//	 * has been balled correctly by the User
//	 * 
//	 * @param context
//	 * @return
//	 */
//	public static Boolean checkIfInstallHasBeenCalled(Context context) {
//		if (getInstance().getAcessToken(context) != null
//				&& !getInstance().getAcessToken(context).trim().equals("")) {
//			return true;
//		} else {
//			return false;
//		}
//	}

	// /////////////////////////////////////////////////////////////////////////
	// ///////////////////////install functionality ends
	// /////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// ///////////////////////Various Other required functionalities
	// /////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	public static enum EnvironmentTypes {
		LIVE, TEST
	}

	private EnvironmentTypes mEnumEnvironmentType = null;

	public EnvironmentTypes getEnvironmentType(Context context) {

		if (getInstance().mEnumEnvironmentType == null) {
			String mStr = HomerSharedPrefrenceHelper.getPref(context)
					.getString(mStrKeyEnvironmentType, "LIVE");
			for (int i = 0; i < EnvironmentTypes.values().length; i++) {

				EnvironmentTypes enviroment = EnvironmentTypes.values()[i];

				if (enviroment.toString().toLowerCase().trim()
						.equals(mStr.toLowerCase().trim())) {
					getInstance().mEnumEnvironmentType = enviroment;
					break;
				}
			}
		}
		return getInstance().mEnumEnvironmentType;
	}

	public void setEnvironmentType(Context context,
			EnvironmentTypes mEnumEnvironmentType) {
		HomerSharedPrefrenceHelper
				.getPref(context)
				.edit()
				.putString(mStrKeyEnvironmentType,
						mEnumEnvironmentType.toString()).commit();
		getInstance().mEnumEnvironmentType = null;
		getInstance().getEnvironmentType(context);
	}

	private Boolean mBoolEnableNotifications = null;

	public Boolean getEnableNotifications(Context context) {

		if (getInstance().mBoolEnableNotifications == null) {
			getInstance().mBoolEnableNotifications = HomerSharedPrefrenceHelper
					.getPref(context).getBoolean(mStrKeyEnableNotification,
							true);
		}
		return getInstance().mBoolEnableNotifications;
	}

	public void enableNotifications(Context context) {
		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putBoolean(mStrKeyEnableNotification, true).commit();
		getInstance().mBoolEnableNotifications = null;
		getInstance().getEnableNotifications(context);
	}

	public void disableNotifications(Context context) {
		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putBoolean(mStrKeyEnableNotification, false).commit();
		getInstance().mBoolEnableNotifications = null;
		getInstance().getEnableNotifications(context);
	}

	private String mStrSenderId = null;

	public String getmStrSenderId(Context context) {

		if (getInstance().mStrSenderId == null) {
			getInstance().mStrSenderId = HomerSharedPrefrenceHelper.getPref(
					context).getString(mStrKeySenderId, "");
		}
		return getInstance().mStrSenderId;
	}

	public void setmStrSenderId(Context context, String mStrSenderId) {
		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putString(mStrKeySenderId, mStrSenderId).commit();
		getInstance().mStrSenderId = null;
		getInstance().getmStrSenderId(context);
	}

	private String mStrGcmRegId = null;

	private static String mStrChatUrl = null;

	public String getmStrGcmRegId(Context context) {
		if (getInstance().mStrGcmRegId == null) {
			getInstance().mStrGcmRegId = HomerSharedPrefrenceHelper.getPref(
					context).getString(mStrKeyRegId, "");
		}
		return getInstance().mStrGcmRegId;
	}

	public void setmStrGcmRegId(Context context, String mStrGcmRegId) {

		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putString(mStrKeyRegId, mStrGcmRegId).commit();
		getInstance().mStrGcmRegId = null;
		getInstance().getmStrGcmRegId(context);

	}

	public static String getmStrChatUrl(Context context) {

		if (getInstance().mStrChatUrl == null) {
			getInstance().mStrChatUrl = HomerSharedPrefrenceHelper.getPref(
					context).getString(mStrKeyChatUrl, "");
		}
		return getInstance().mStrChatUrl;
	}

	public static void setmStrChatUrl(Context context, String mStrChatUrl) {

		HomerSharedPrefrenceHelper.getPref(context).edit()
				.putString(mStrKeyChatUrl, mStrChatUrl).commit();
		getInstance().mStrChatUrl = null;
		getInstance().getmStrChatUrl(context);

	}

	public static WebView myWebView;

	public static Boolean checkIfWebViewIsNull() {
		return myWebView == null ? true : false;
	}

	public static WebView getMyWebView(Context context) {
		if (getInstance().myWebView == null) {
			setUpWebView(context);
		}

		return getInstance().myWebView;
	}

	public static void setMyWebView(WebView myWebView) {
		getInstance().myWebView = myWebView;
	}

	public static void setUpWebView(Context context) {

		myWebView = new WebView(context);

		LinearLayout.LayoutParams mParams = new LayoutParams(
				LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);

		myWebView.setLayoutParams(mParams);

		WebSettings webSettings = myWebView.getSettings();

		// if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
		// WebView.setWebContentsDebuggingEnabled(true);
		// }

		webSettings.setSaveFormData(true);
		webSettings.setLoadsImagesAutomatically(true);
		webSettings.setSupportMultipleWindows(true);
		// webSettings.setLightTouchEnabled(true);
		webSettings.setAllowFileAccess(true);
		webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
		webSettings.setSupportZoom(true);
		// webSettings.setSavePassword(true);
		webSettings.setPluginState(PluginState.ON);
		webSettings.setAppCacheEnabled(true);
		webSettings.setDatabaseEnabled(true);
		myWebView.setWebChromeClient(new WebChromeClient());
		webSettings.setJavaScriptEnabled(true);
		webSettings.setDomStorageEnabled(true);
		webSettings.setBuiltInZoomControls(true);
		webSettings.setUseWideViewPort(true);
		webSettings.setLoadWithOverviewMode(true);

		// WebAppInterface mWebAppInterface = new WebAppInterface(context);

		// myWebView.addJavascriptInterface(mWebAppInterface, "Android");
		// mWebAppInterface.addObserver(this);

		if (Build.VERSION.SDK_INT >= 11) {
			try {
				webSettings.setDisplayZoomControls(false);
				myWebView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		myWebView.loadUrl(getmStrChatUrl(context));
		HomerLogger.d("chaturl ===" + getmStrChatUrl(context));
	}

	public static String getRootCacheFolderPath(Context context) {
		File cacheDir = null;
		try {
			if (android.os.Environment.getExternalStorageState().equals(
					android.os.Environment.MEDIA_MOUNTED))
				cacheDir = new File(
						android.os.Environment.getExternalStorageDirectory()
								+ "/Android/data/" + context.getPackageName()
								+ "/cache");
			else
				cacheDir = context.getCacheDir();
			if (!cacheDir.exists())
				cacheDir.mkdirs();
		} catch (Exception e) {
			e.printStackTrace();
		}
		String path = "";
		try {
			path = cacheDir.getAbsolutePath();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return path;
	}

	public static String getOrCreateAFolderWithName(Context context, String name) {
		File cacheDir = null;
		try {
			if (android.os.Environment.getExternalStorageState().equals(
					android.os.Environment.MEDIA_MOUNTED))
				cacheDir = new File(
						android.os.Environment.getExternalStorageDirectory()
								+ "/Android/data/" + context.getPackageName()
								+ "/cache/" + name);
			else
				cacheDir = context.getCacheDir();
			if (!cacheDir.exists())
				cacheDir.mkdirs();
		} catch (Exception e) {
			e.printStackTrace();
		}
		String path = "";
		try {
			path = cacheDir.getAbsolutePath();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return path;
	}

	// /////////////////////////////////////////////////////////////////////////
	// ///////////////////////Various Other required functionalities end here
	// ...
	// /////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////////customisation
	// functionality/////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	private Integer mIntThemeColor = null;

	public static Integer getThemeColor() {
		return getInstance().mIntThemeColor;
	}

	public static void setThemeColor(Integer mIntThemeColor) {
		getInstance().mIntThemeColor = mIntThemeColor;
	}

	private Integer mIntLogo = null;

	public static Integer getLogo() {
		return getInstance().mIntLogo;
	}

	public static void setLogo(Integer mIntLogo) {
		getInstance().mIntLogo = mIntLogo;
	}

	private String mStrTitle = null;

	public static String getTitle() {
		return getInstance().mStrTitle;
	}

	public static void setTitle(String mStrTitle) {
		getInstance().mStrTitle = mStrTitle;
	}

	public static void loadCustomisation(ActivityCustomerBase mAcivity) {

		ActionBarCustomPort mActionBar = mAcivity.getmActionBar(mAcivity);
		loadCustomisation(mAcivity, mActionBar);
	}

	public static void loadCustomisation(Context context,
			ActionBarCustomPort mActionBar) {
		if (getThemeColor() != null) {
			mActionBar.setmCustomColorResID(context, getThemeColor());
		}
		if (getLogo() != null) {
			mActionBar.setmLogo(getLogo());
		}
		if (getTitle() != null) {
			mActionBar.setmTitle(getTitle());
		}

	}

	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////customisation functionality ends ////////////////////
	// ///////////////////////////////////////////////////////////////////////////

	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////Launching Utilities ////////////////////
	// ///////////////////////////////////////////////////////////////////////////
	/**
	 * Launch the Tickets Module in our activity
	 * 
	 * @param activity
	 */
	public static void launchTickets(Activity activity) {
		activity.startActivity(new Intent(activity, ActivityTicketListing.class));
	}

	/**
	 * Launch the Chat Module in our activity
	 * 
	 * @param activity
	 */
	public static void launchChat(Activity activity) {
		activity.startActivity(new Intent(activity, ActivityChat.class));
	}

	/**
	 * This function returns the Ticket Module as a Fragment , So that you can
	 * use it in whichever way you want , You can use it as another page of your
	 * tab , or you can use it inside a view pager , or any other way you want
	 * 
	 * This is functions is usefull if you want to use customer360 modules in
	 * adnavced modes other than the basic usage as provided by
	 * launchTicketModule.
	 * 
	 * @return
	 */
	public static FragmentTicketListing getTicketsModuleAsFragment() {
		return new FragmentTicketListing();
	}

	/**
	 * This function returns the Chat Module as a Fragment , So that you can use
	 * it in whichever way you want , You can use it as another page of your tab
	 * , or you can use it inside a view pager , or any other way you want
	 * 
	 * 
	 * This is functions is usefull if you want to use customer360 modules in
	 * adnavced modes other than the basic usage as provided by
	 * launchTicketModule.
	 * 
	 * @return
	 */
	public static FragmentChat getChatModuleAsFragment() {
		return new FragmentChat();
	}

	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////Launching Utilities ends ////////////////////
	// //////////////////////////////////////////////////////////////////////////

	public static final String mStrKeyColor = "Color";
	public static final String mStrKeyLogo = "Logo";
	public static final String mStrKeyTittle = "Tittle";
	public static final String mStrKeyAcessTokenHelpDesk = "mStrKeyAcessTokenHelpDesk";
	public static final String mStrKeyEnableNotification = "EnableNotifications";
	public static final String mStrKeyEnvironmentType = "EnvironmentType";
	public static final String mStrKeyAppApiKey = "AppApiKey";

	private static final String mStrKeySenderId = "SenderId";
	private static final String mStrKeyRegId = "RegId";
	private static final String mStrKeyChatUrl = "ChatUrl";
	private static final String mStrKeyAcessTokenHasBeenChanged = "AccessTokenChanged";

	@Override
	public String toString() {
		super.toString();
		JSONObject mJsonOb = new JSONObject();
		try {
			mJsonOb.put(mStrKeyColor, getThemeColor());

			mJsonOb.put(mStrKeyLogo, getLogo());

			mJsonOb.put(mStrKeyTittle, getTitle());

			// mJsonOb.put(mStrKeyAcessToken, getAcessToken());

		} catch (Exception e) {
			e.printStackTrace();
		}

		return mJsonOb.toString();
	}

	public static void fromString(String json) {
		JSONObject mJsonOb = new JSONObject();
		try {
			mJsonOb = new JSONObject(json);

			try {
				if (mJsonOb.has(mStrKeyColor)) {
					getInstance().setThemeColor(mJsonOb.getInt(mStrKeyColor));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			try {
				if (mJsonOb.has(mStrKeyLogo)) {
					getInstance().setLogo(mJsonOb.getInt(mStrKeyLogo));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			try {
				if (mJsonOb.has(mStrKeyTittle)) {
					getInstance().setTitle(mJsonOb.getString(mStrKeyTittle));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			// try {
			// if (mJsonOb.has(mStrKeyAcessToken)) {
			// getInstance().setAcessToken(
			// mJsonOb.getString(mStrKeyAcessToken));
			// }
			// } catch (Exception e) {
			// e.printStackTrace();
			// }
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
