package cus360.inapp.app.ticket.ticketlisting;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModelDetail {

	private String mStrMessage = "";
	private String mStrSender = "";
	private String mStrSenderName = "";
	private ArrayList<ModelAttachment> mArrLisMaAttachments = new ArrayList<ModelAttachment>();
	private Boolean mBoolHasAttachments = false;

	private Integer mIntTempPosForPhotoGallery = 0;

	public String getmStrMessage() {
		return mStrMessage;
	}

	public void setmStrMessage(String mStrMessage) {
		this.mStrMessage = mStrMessage;
	}

	public String getmStrSender() {
		return mStrSender;
	}

	public void setmStrSender(String mStrSender) {
		this.mStrSender = mStrSender;
	}

	public String getmStrSenderName() {
		return mStrSenderName;
	}

	public void setmStrSenderName(String mStrSenderName) {
		this.mStrSenderName = mStrSenderName;
	}

	public ArrayList<ModelAttachment> getmArrLisMaAttachments() {
		return mArrLisMaAttachments;
	}

	public void setmArrLisMaAttachments(
			ArrayList<ModelAttachment> mArrLisMaAttachments) {
		this.mArrLisMaAttachments = mArrLisMaAttachments;
	}

	public Boolean getmBoolHasAttachments() {
		return mBoolHasAttachments;
	}

	public void setmBoolHasAttachments(Boolean mBoolHasAttachments) {
		this.mBoolHasAttachments = mBoolHasAttachments;
	}

	public Integer getmIntTempPosForPhotoGallery() {
		return mIntTempPosForPhotoGallery;
	}

	public void setmIntTempPosForPhotoGallery(Integer mIntTempPosForPhotoGallery) {
		this.mIntTempPosForPhotoGallery = mIntTempPosForPhotoGallery;
	}

	public ModelDetail() {

	}

	public ModelDetail(String mStrjson) {
		fromString(mStrjson);
	}

	public ModelDetail(JSONObject mjsonOB) {
		fromJson(mjsonOB);
	}

	@Override
	public String toString() {
		super.toString();

		JSONObject mJsonOb = new JSONObject();
		try {

			mJsonOb.put("message", getmStrMessage());
			mJsonOb.put("sender_name", getmStrSenderName());
			mJsonOb.put("sender", getmStrSender());

			mJsonOb.put("temp_pos", getmIntTempPosForPhotoGallery());

			mJsonOb.put("has_attachment",
					returnIntValueOfBoolean(getmBoolHasAttachments()));

			// adding array of attachments to jason array to be put into string
			JSONArray mJsonArrAttachments = new JSONArray();
			for (ModelAttachment mModelAttachment : getmArrLisMaAttachments()) {
				mJsonArrAttachments.put(mModelAttachment.toString());
			}

			mJsonOb.put("attachments", mJsonArrAttachments);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return mJsonOb.toString();
	}

	public Integer returnIntValueOfBoolean(Boolean mBool) {

		return mBool == true ? 1 : 0;
	}

	public void fromString(String mStrJson) {

		JSONObject mjsonOb = new JSONObject();
		try {
			mjsonOb = new JSONObject(mStrJson);
		} catch (Exception e) {
			e.printStackTrace();
		}
		fromJson(mjsonOb);
	}

	public void fromJson(JSONObject mJsonOb) {

		try {
			setmStrMessage(mJsonOb.getString("message"));
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			setmStrSenderName(mJsonOb.getString("sender_name"));
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			setmStrSender(mJsonOb.getString("sender"));
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			setmIntTempPosForPhotoGallery(mJsonOb.getInt("temp_pos"));
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			Integer mIntHasAttachment = 0;

			mIntHasAttachment = mJsonOb.getInt("has_attachment");
			if (mIntHasAttachment <= 0) {
				setmBoolHasAttachments(false);
			} else {
				setmBoolHasAttachments(true);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		try {
			if (getmBoolHasAttachments()) {
				// init arrlist
				setmArrLisMaAttachments(new ArrayList<ModelAttachment>());

				JSONArray mJsonArray = new JSONArray();
				mJsonArray = mJsonOb.getJSONArray("attachments");
				int forLoopSize = mJsonArray.length();

				for (int i = 0; i < forLoopSize; i++) {

					ModelAttachment mModelAttachment = new ModelAttachment(
							mJsonArray.getString(i));
					getmArrLisMaAttachments().add(mModelAttachment);
				}

			}
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
}
