package cus360.inapp.app.ticket.ticketlisting.gallery;

import java.util.Locale;

import uk.co.senab.photoview.HackyViewPager;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.view.ViewGroup;
import cus360.inapp.R;
import cus360.inapp.app.ticket.ticketlisting.ModelDetail;
import cus360.inapp.base.ActivityCustomerBase;

public class ActivityPhotoGallery extends ActivityCustomerBase {

	private HackyViewPager mJvpContentHolder;

	private ModelDetail mModelDetail;

	public ModelDetail getmModelDetail() {
		if (mModelDetail == null) {
			try {
				mModelDetail = new ModelDetail(getIntent().getExtras()
						.getString("mModelDetail"));
			} catch (Exception e) {
				mModelDetail = new ModelDetail();
				e.printStackTrace();
			}
		}
		return mModelDetail;
	}

	public void setmModelDetail(ModelDetail mModelDetail) {
		this.mModelDetail = mModelDetail;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		retriveRequiredData(savedInstanceState);

		setContentView(R.layout.cus__apg_layout);

		findViewByIds();
		setOnClickListeners();
		manipulateUi();
	}

	private void manipulateUi() {
		setUpViewPager();
		setUpActionBar();
	}

	private void setOnClickListeners() {

	}

	private void findViewByIds() {
		mJvpContentHolder = (HackyViewPager) findViewById(R.id.apglc_JazzyViewPager);
	}

	private void setUpViewPager() {
		mJvpContentHolder.setAdapter(new SectionsPagerAdapter(
				getSupportFragmentManager()));
		mJvpContentHolder.setCurrentItem(getmModelDetail()
				.getmIntTempPosForPhotoGallery(), true);
	}

	private void retriveRequiredData(Bundle savedInstance) {
		try {
			if (savedInstance != null) {

				setmModelDetail(new ModelDetail(
						savedInstance.getString("mModelDetail")));

			} else {
				setmModelDetail(new ModelDetail(getIntent().getExtras()
						.getString("mModelDetail")));
			}
		} catch (Exception e) {
			setmModelDetail(new ModelDetail());
			e.printStackTrace();
		}
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);

		outState.putString("mModelDetail", getmModelDetail().toString());
	}

	@Override
	protected void onResume() {
		super.onResume();
	}

	/**
	 * A {@link FragmentPagerAdapter} that returns a fragment corresponding to
	 * one of the sections/tabs/pages.
	 */
	public class SectionsPagerAdapter extends FragmentPagerAdapter {

		public SectionsPagerAdapter(FragmentManager fm) {
			super(fm);
		}

		@Override
		public Fragment getItem(int position) {

			return FragmentPhotoView.newInstance(getmModelDetail()
					.getmArrLisMaAttachments().get(position).toString());
		}

		@Override
		public int getCount() {
			return getmModelDetail().getmArrLisMaAttachments().size();
		}

		@Override
		public CharSequence getPageTitle(int position) {
			Locale l = Locale.getDefault();

			return getmModelDetail().getmArrLisMaAttachments().get(position)
					.getmStrNewName().toUpperCase(l);

		}

		@Override
		public void destroyItem(ViewGroup container, int position, Object object) {
			container.removeView(((FragmentPhotoView) object).mPvPhoto);
		}

	}

}
