/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.entity;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.util.Size;
import androidx.annotation.NonNull;
import com.banuba.sdk.entity.PositionProvider;
import com.banuba.sdk.entity.SizeProvider;

public class GravityPositionProviderAdapter
implements PositionProvider {
    private SizeProvider sizeProvider;
    private int gravity;

    public GravityPositionProviderAdapter(SizeProvider sizeProvider, int n) {
        this.sizeProvider = sizeProvider;
        this.gravity = n;
    }

    @Override
    @SuppressLint(value={"RtlHardcoded"})
    public PointF provide(@NonNull Size size) {
        GravityPositionProviderAdapter gravityPositionProviderAdapter = this;
        Size size2 = gravityPositionProviderAdapter.sizeProvider.provide(size);
        float f = -1.0f;
        int n = gravityPositionProviderAdapter.gravity;
        if ((n & 0x30) == 48) {
            f = (float)size.getHeight() - (float)size2.getHeight() / 2.0f;
        } else if ((n & 0x50) == 80) {
            f = (float)size2.getHeight() / 2.0f;
        } else if ((n & 0x10) == 16) {
            f = (float)size.getHeight() / 2.0f;
        }
        float f2 = -1.0f;
        n = this.gravity;
        if ((n & 3) == 3) {
            f2 = (float)size2.getWidth() / 2.0f;
        } else if ((n & 5) == 5) {
            f2 = (float)size.getWidth() - (float)size2.getWidth() / 2.0f;
        } else if ((n & 1) == 1) {
            f2 = (float)size.getWidth() / 2.0f;
        }
        if (f2 == -1.0f && f == -1.0f) {
            throw new RuntimeException("Gravity for X and Y coordinates is not provided.");
        }
        if (f2 != -1.0f) {
            if (f != -1.0f) {
                return new PointF(f2, f);
            }
            throw new RuntimeException("Gravity for Y coordinate is not provided.");
        }
        throw new RuntimeException("Gravity for X coordinate is not provided.");
    }
}

