/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.frame;

import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;
import com.banuba.sdk.types.PixelFormat;

public enum FramePixelBufferFormat {
    BPC8_RGBA(false),
    I420_BT601_FULL(true),
    I420_BT601_VIDEO(true),
    I420_BT709_FULL(true),
    I420_BT709_VIDEO(true);

    private final boolean mIsI420;
    private final PixelFormat mPixelFmt;
    private final ColorStd mStd;
    private final ColorRange mRng;
    private final int mPixelComponents;

    private FramePixelBufferFormat(boolean bl) {
        this.mIsI420 = bl;
        if (bl) {
            this.mPixelFmt = null;
            string = ((Object)((Object)this)).toString().contains("BT601") ? ColorStd.BT601 : ColorStd.BT709;
            this.mStd = string;
            string = ((Object)((Object)this)).toString().contains("VIDEO") ? ColorRange.VIDEO : ColorRange.FULL;
            FramePixelBufferFormat framePixelBufferFormat = this;
            framePixelBufferFormat.mRng = string;
            framePixelBufferFormat.mPixelComponents = 0;
        } else {
            if (((Object)((Object)this)).toString().contains("RGBA")) {
                FramePixelBufferFormat framePixelBufferFormat = this;
                framePixelBufferFormat.mPixelFmt = PixelFormat.RGBA;
                framePixelBufferFormat.mPixelComponents = 4;
            } else {
                FramePixelBufferFormat framePixelBufferFormat = this;
                framePixelBufferFormat.mPixelFmt = null;
                framePixelBufferFormat.mPixelComponents = 0;
            }
            FramePixelBufferFormat framePixelBufferFormat = this;
            framePixelBufferFormat.mStd = null;
            framePixelBufferFormat.mRng = null;
        }
    }

    public boolean isBpc8() {
        return this.mIsI420 ^ true;
    }

    public boolean isI420() {
        return this.mIsI420;
    }

    @Nullable
    public PixelFormat getPixelFormat() {
        return this.mPixelFmt;
    }

    @Nullable
    public ColorStd getColorStandard() {
        return this.mStd;
    }

    @Nullable
    public ColorRange getColorRange() {
        return this.mRng;
    }

    public int getPixelComponents() {
        return this.mPixelComponents;
    }
}

