/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.input;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.util.Size;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.input.CameraDeviceConfigurator;
import com.banuba.sdk.player.VerifyCloseable;
import com.banuba.sdk.types.FullImageData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Executor;

public class CameraDevice
extends VerifyCloseable {
    private static final String TAG = "CameraDevice";
    static final /* synthetic */ boolean $assertionsDisabled;
    private final ArrayList<ICapturedFrameInput> mListeners = new ArrayList();
    private final Context mContext;
    private final LifecycleOwner mLifecycleOwner;
    private ProcessCameraProvider mCameraProvider;
    private ImageCapture mImageCapturer;
    private ImageAnalysis mVideoCapturer;
    private Camera mCamera;
    private final CameraDeviceConfiguratorImpl mConfigurator;
    private CameraDeviceConfiguratorImpl mCurrentConfiguration;
    private final LifecycleEventObserver mLifecycleObserver;
    private boolean mIsStopped = true;

    public CameraDevice(@NonNull Context object, @NonNull LifecycleOwner lifecycleOwner2) {
        super(TAG);
        CameraDeviceConfiguratorImpl cameraDeviceConfiguratorImpl;
        this.mContext = object;
        this.mLifecycleOwner = lifecycleOwner2;
        this.mLifecycleObserver = (lifecycleOwner, event) -> {
            if (event == Lifecycle.Event.ON_RESUME && this.mCamera != null) {
                this.updateZoomAndTorch();
            }
        };
        try {
            this.mCameraProvider = (ProcessCameraProvider)ProcessCameraProvider.getInstance((Context)object).get();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Exception in camera: " + exception));
        }
        object = cameraDeviceConfiguratorImpl;
        super(this);
        this.mConfigurator = object;
        cameraDeviceConfiguratorImpl.commit();
    }

    @SuppressLint(value={"RestrictedApi"})
    private void applyNewConfiguration(@NonNull CameraDeviceConfiguratorImpl cameraDeviceConfiguratorImpl) {
        CameraDeviceConfiguratorImpl cameraDeviceConfiguratorImpl2 = this.mCurrentConfiguration;
        boolean bl = cameraDeviceConfiguratorImpl2 == null;
        boolean bl2 = bl || cameraDeviceConfiguratorImpl2.mLens != cameraDeviceConfiguratorImpl.mLens;
        boolean bl3 = bl || cameraDeviceConfiguratorImpl2.mIsMirroringEnabled != cameraDeviceConfiguratorImpl.mIsMirroringEnabled;
        boolean bl4 = bl || cameraDeviceConfiguratorImpl2.mVideoCaptureSize != cameraDeviceConfiguratorImpl.mVideoCaptureSize;
        boolean bl5 = bl || cameraDeviceConfiguratorImpl2.mImageCaptureSize != cameraDeviceConfiguratorImpl.mImageCaptureSize;
        boolean bl6 = bl || cameraDeviceConfiguratorImpl2.mLinearZoom != cameraDeviceConfiguratorImpl.mLinearZoom || cameraDeviceConfiguratorImpl2.mZoomRatio != cameraDeviceConfiguratorImpl.mZoomRatio;
        boolean bl7 = bl || cameraDeviceConfiguratorImpl2.mTorchEnabled != cameraDeviceConfiguratorImpl.mTorchEnabled;
        boolean bl8 = bl || cameraDeviceConfiguratorImpl2.mFlashMode != cameraDeviceConfiguratorImpl.mFlashMode;
        this.mCurrentConfiguration = cameraDeviceConfiguratorImpl;
        if (bl4 || bl3 || bl2) {
            ImageAnalysis.Builder builder;
            CameraDevice cameraDevice = this;
            cameraDeviceConfiguratorImpl = builder;
            CameraDevice cameraDevice2 = this;
            cameraDeviceConfiguratorImpl();
            cameraDeviceConfiguratorImpl = builder.setTargetResolution(cameraDevice2.getCaptureSizeWithRotation(cameraDevice2.mCurrentConfiguration.mVideoCaptureSize)).setBackpressureStrategy(0).build();
            cameraDevice.mVideoCapturer = cameraDeviceConfiguratorImpl;
            Executor executor = ContextCompat.getMainExecutor((Context)cameraDevice.mContext);
            ImageAnalysis.Analyzer analyzer = cameraDevice.mCurrentConfiguration.mIsMirroringEnabled ? this::pushVideoFrameWithMirroring : this::pushVideoFrameWithoutMirroring;
            cameraDeviceConfiguratorImpl.setAnalyzer(executor, analyzer);
        }
        if (bl5 || bl3 || bl8) {
            ImageCapture.Builder builder;
            cameraDeviceConfiguratorImpl = builder;
            CameraDevice cameraDevice = this;
            cameraDeviceConfiguratorImpl();
            this.mImageCapturer = builder.setTargetResolution(cameraDevice.getCaptureSizeWithRotation(cameraDevice.mCurrentConfiguration.mImageCaptureSize)).setCaptureMode(0).setBufferFormat(35).setFlashMode(this.mCurrentConfiguration.getCameraXFlashMode()).build();
        }
        boolean bl9 = bl2 || bl4 || bl5 || bl3 || bl8;
        if (bl9) {
            this.rebindUseCases();
        }
        if ((bl6 || bl7) && this.mCamera != null && !bl9) {
            this.updateZoomAndTorch();
        }
    }

    private void rebindUseCases() {
        if (!$assertionsDisabled && this.mCameraProvider == null) {
            throw new AssertionError();
        }
        if (this.mIsStopped) {
            CameraDevice cameraDevice = this;
            cameraDevice.mCamera = null;
            cameraDevice.mCameraProvider.unbindAll();
            cameraDevice.mLifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this.mLifecycleObserver);
            return;
        }
        int n = this.mCurrentConfiguration.mLens == CameraDeviceConfigurator.LensSelector.FRONT ? 1 : 0;
        CameraDevice cameraDevice = this;
        UseCase[] useCaseArray = new CameraSelector.Builder().requireLensFacing(n ^= 1).build();
        cameraDevice.mCameraProvider.unbindAll();
        if (cameraDevice.mCamera == null) {
            this.mLifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this.mLifecycleObserver);
        }
        CameraDevice cameraDevice2 = this;
        UseCase[] useCaseArray2 = useCaseArray;
        UseCase[] useCaseArray3 = new UseCase[2];
        useCaseArray = useCaseArray3;
        useCaseArray[0] = this.mImageCapturer;
        useCaseArray3[1] = this.mVideoCapturer;
        cameraDevice2.mCamera = cameraDevice2.mCameraProvider.bindToLifecycle(this.mLifecycleOwner, (CameraSelector)useCaseArray2, useCaseArray);
        cameraDevice2.updateZoomAndTorch();
    }

    private void updateZoomAndTorch() {
        if (this.mCurrentConfiguration.mLinearZoom != 0.0f) {
            this.mCamera.getCameraControl().setLinearZoom(this.mCurrentConfiguration.mLinearZoom);
        } else {
            this.mCamera.getCameraControl().setZoomRatio(this.mCurrentConfiguration.mZoomRatio);
        }
        this.mCamera.getCameraControl().enableTorch(this.mCurrentConfiguration.mTorchEnabled);
    }

    private Size getCaptureSizeWithRotation(Size object) {
        if (!cameraDevice.isLandscape()) {
            Size size;
            CameraDevice cameraDevice = size;
            Size size2 = object;
            int n = size2.getHeight();
            size = new Size(n, size2.getWidth());
            object = cameraDevice;
        }
        return object;
    }

    private boolean isLandscape() {
        int n = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        return n == 1 || n == 3;
    }

    private void pushVideoFrameWithMirroring(@NonNull ImageProxy imageProxy) {
        this.pushVideoFrame(imageProxy, true);
    }

    private void pushVideoFrameWithoutMirroring(@NonNull ImageProxy imageProxy) {
        this.pushVideoFrame(imageProxy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushVideoFrame(@NonNull ImageProxy var1_4, boolean var2_5) {
        block11: {
            if (this.mListeners.isEmpty()) break block11;
            v0 = this;
            v1 = v0;
            v2 = v0;
            var0_1 = v0.getFrameRotationDegrees(var1_4);
            {
                catch (Throwable var0_3) {
                    if (var1_4 == null) throw var0_3;
                    try {
                        var1_4.close();
                        throw var0_3;
                    }
                    catch (Throwable v3) {
                        var0_3.addSuppressed(v3);
                    }
                    throw var0_3;
                }
                var3_7 = v4;
                {
                    v4 = new FrameProvider(var1_4, var0_1, var2_5);
                    var0_2 = v2.mListeners;
                }
                {
                    ** synchronized (var0_2)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_6 = v1.mListeners.iterator();
                        while (var2_6.hasNext()) {
                            var2_6.next().onFrame(var3_7);
                        }
                    }
                    catch (Throwable v5) {}
                    {
                        throw v5;
                    }
                }
            }
        }
        if (var1_4 == null) return;
        var1_4.close();
    }

    private int getFrameRotationDegrees(ImageProxy imageProxy) {
        CameraDeviceConfigurator.IFrameRotationProviderCallback iFrameRotationProviderCallback = ((CameraDevice)((Object)iFrameRotationProviderCallback)).mCurrentConfiguration.mFrameRotationProviderCallback;
        if (iFrameRotationProviderCallback != null) {
            return iFrameRotationProviderCallback.onFrameRotation(imageProxy.getImageInfo().getRotationDegrees());
        }
        return imageProxy.getImageInfo().getRotationDegrees();
    }

    private static FullImageData createFullImageDataFromImageProxy(@NonNull ImageProxy objectArray, int n, boolean bl) {
        FullImageData.Orientation orientation;
        FullImageData.Orientation orientation2 = orientation;
        orientation = new FullImageData.Orientation(CameraDevice.degreesToCameraOrientation(n), bl, 0);
        n = objectArray.getFormat();
        if (n == 35) {
            Size size;
            Size size2;
            Size size3 = size2 = objectArray.getPlanes();
            size2 = size;
            int n2 = objectArray.getWidth();
            size = new Size(n2, objectArray.getHeight());
            ByteBuffer byteBuffer = size3[0].getBuffer();
            ByteBuffer byteBuffer2 = size3[1].getBuffer();
            ByteBuffer byteBuffer3 = size3[2].getBuffer();
            int n3 = size3[0].getRowStride();
            int n4 = size3[1].getRowStride();
            int n5 = size3[2].getRowStride();
            int n6 = size3[0].getPixelStride();
            int n7 = size3[1].getPixelStride();
            int n8 = size3[2].getPixelStride();
            return new FullImageData(size2, (Buffer)byteBuffer, (Buffer)byteBuffer2, (Buffer)byteBuffer3, n3, n4, n5, n6, n7, n8, orientation2);
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n;
        throw new RuntimeException("CameraDevice: Unknown image format = " + String.format("0x%X", objectArray));
    }

    private static CameraOrientation degreesToCameraOrientation(int n) {
        if (n != 0) {
            if (n != 90) {
                if (n != 180) {
                    if (n == 270) {
                        return CameraOrientation.DEG_270;
                    }
                    throw new RuntimeException("CameraDevice: Unknown degrees value " + n);
                }
                return CameraOrientation.DEG_180;
            }
            return CameraOrientation.DEG_90;
        }
        return CameraOrientation.DEG_0;
    }

    static {
        $assertionsDisabled = CameraDevice.class.desiredAssertionStatus() ^ true;
    }

    public boolean hasFlashUnit() {
        CameraDevice cameraDevice = cameraDevice.mCamera;
        if (cameraDevice != null) {
            return cameraDevice.getCameraInfo().hasFlashUnit();
        }
        return false;
    }

    public float getMinZoomRatio() {
        CameraDevice cameraDevice = cameraDevice.mCamera;
        if (cameraDevice != null && (cameraDevice = (ZoomState)cameraDevice.getCameraInfo().getZoomState().getValue()) != null) {
            return cameraDevice.getMinZoomRatio();
        }
        return 1.0f;
    }

    public float getMaxZoomRatio() {
        CameraDevice cameraDevice = cameraDevice.mCamera;
        if (cameraDevice != null && (cameraDevice = (ZoomState)cameraDevice.getCameraInfo().getZoomState().getValue()) != null) {
            return cameraDevice.getMaxZoomRatio();
        }
        return 1.0f;
    }

    public CameraDeviceConfigurator getConfigurator() {
        return this.mConfigurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoCaptureListener(@NonNull ICapturedFrameInput iCapturedFrameInput) {
        CameraDevice cameraDevice = this;
        ArrayList<ICapturedFrameInput> arrayList = cameraDevice.mListeners;
        synchronized (arrayList) {
            block5: {
                if (cameraDevice.mListeners.contains(iCapturedFrameInput)) break block5;
                this.mListeners.add(iCapturedFrameInput);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVideoCaptureListener(@NonNull ICapturedFrameInput iCapturedFrameInput) {
        ArrayList<ICapturedFrameInput> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(iCapturedFrameInput);
            return;
        }
    }

    public void takePhoto(final @NonNull ICapturedFrameInput iCapturedFrameInput, final @Nullable IErrorOccurred iErrorOccurred) {
        this.mImageCapturer.takePicture(ContextCompat.getMainExecutor((Context)this.mContext), new ImageCapture.OnImageCapturedCallback(){

            public void onCaptureSuccess(@NonNull ImageProxy imageProxy) {
                FrameProvider frameProvider;
                ImageProxy imageProxy2 = imageProxy;
                1 v1 = this;
                1 v2 = v1;
                1 v3 = v1;
                boolean bl = ((CameraDevice)v1.CameraDevice.this).mCurrentConfiguration.mIsMirroringEnabled;
                int n = v3.CameraDevice.this.getFrameRotationDegrees(imageProxy);
                FrameProvider frameProvider2 = frameProvider;
                try {
                    frameProvider = new FrameProvider(imageProxy, n, bl);
                    v2.iCapturedFrameInput.onFrame(frameProvider2);
                    super.onCaptureSuccess(imageProxy);
                    return;
                }
                finally {
                    if (imageProxy2 != null) {
                        imageProxy.close();
                    }
                }
            }

            public void onError(@NonNull ImageCaptureException imageCaptureException) {
                IErrorOccurred iErrorOccurred2 = iErrorOccurred2.iErrorOccurred;
                if (iErrorOccurred2 != null) {
                    iErrorOccurred2.onError((Exception)imageCaptureException);
                }
            }
        });
    }

    public void start() {
        if (this.mIsStopped) {
            this.mIsStopped = false;
            this.rebindUseCases();
        }
    }

    public void stop() {
        if (!this.mIsStopped) {
            this.mIsStopped = true;
            this.rebindUseCases();
        }
    }

    @Override
    public void close() {
        CameraDevice cameraDevice = this;
        cameraDevice.stop();
        super.close();
    }

    private static class CameraDeviceConfiguratorImpl
    extends CameraDeviceConfigurator
    implements Cloneable {
        private final CameraDevice mCameraDevice;

        public CameraDeviceConfiguratorImpl(CameraDevice cameraDevice) {
            this.mCameraDevice = cameraDevice;
        }

        @Override
        public void commit() {
            try {
                this.mCameraDevice.applyNewConfiguration((CameraDeviceConfiguratorImpl)this.clone());
                return;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public int getCameraXFlashMode() {
            int n = 2.$SwitchMap$com$banuba$sdk$input$CameraDeviceConfigurator$FlashMode[this.mFlashMode.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    return 2;
                }
                return 0;
            }
            return 1;
        }

        @NonNull
        public Object clone() {
            return super.clone();
        }
    }

    public static interface ICapturedFrameInput {
        public void onFrame(FrameProvider var1);
    }

    public static interface IErrorOccurred {
        public void onError(@NonNull Exception var1);
    }

    public static class FrameProvider {
        private final ImageProxy mImageProxy;
        private FullImageData mFullImageData = null;
        private final boolean mRequireMirroring;
        private final int mFrameRotationDegrees;

        protected FrameProvider(ImageProxy imageProxy, int n, boolean bl) {
            this.mImageProxy = imageProxy;
            this.mRequireMirroring = bl;
            this.mFrameRotationDegrees = n;
        }

        public FullImageData getFullImageData() {
            if (this.mFullImageData == null) {
                FrameProvider frameProvider = this;
                int n = frameProvider.mFrameRotationDegrees;
                this.mFullImageData = CameraDevice.createFullImageDataFromImageProxy(this.mImageProxy, n, frameProvider.mRequireMirroring);
            }
            return this.mFullImageData;
        }

        public ImageProxy getImageProxy() {
            return this.mImageProxy;
        }

        public int getFrameRotationDegrees() {
            return this.mFrameRotationDegrees;
        }
    }
}

