/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.input;

import android.util.Size;

public abstract class CameraDeviceConfigurator {
    public static final Size SD_CAPTURE_SIZE;
    public static final Size HD_CAPTURE_SIZE;
    public static final Size FHD_CAPTURE_SIZE;
    public static final Size QHD_CAPTURE_SIZE;
    public static final Size DEFAULT_VIDEO_CAPTURE_SIZE;
    public static final Size DEFAULT_IMAGE_CAPTURE_SIZE;
    public static final LensSelector DEFAULT_LENS;
    public static final FlashMode DEFAULT_FLASH_MODE;
    public static final float DEFAULT_LINEAR_ZOOM = 0.0f;
    public static final float DEFAULT_ZOOM_RATIO = 1.0f;
    public static final boolean DEAULT_TORCH_ENABLED = false;
    protected Size mVideoCaptureSize = DEFAULT_VIDEO_CAPTURE_SIZE;
    protected Size mImageCaptureSize = DEFAULT_IMAGE_CAPTURE_SIZE;
    protected LensSelector mLens;
    protected IFrameRotationProviderCallback mFrameRotationProviderCallback;
    protected boolean mIsMirroringEnabled;
    protected boolean mTorchEnabled;
    protected float mLinearZoom;
    protected float mZoomRatio;
    protected FlashMode mFlashMode;

    public CameraDeviceConfigurator() {
        LensSelector lensSelector = DEFAULT_LENS;
        CameraDeviceConfigurator cameraDeviceConfigurator = this;
        cameraDeviceConfigurator.mLens = lensSelector;
        cameraDeviceConfigurator.mFrameRotationProviderCallback = null;
        boolean bl = lensSelector == LensSelector.FRONT;
        CameraDeviceConfigurator cameraDeviceConfigurator2 = this;
        cameraDeviceConfigurator2.mIsMirroringEnabled = bl;
        cameraDeviceConfigurator2.mTorchEnabled = false;
        cameraDeviceConfigurator2.mLinearZoom = 0.0f;
        cameraDeviceConfigurator2.mZoomRatio = 1.0f;
        cameraDeviceConfigurator2.mFlashMode = DEFAULT_FLASH_MODE;
    }

    static {
        Size size;
        SD_CAPTURE_SIZE = new Size(640, 480);
        Size size2 = size;
        HD_CAPTURE_SIZE = new Size(1280, 720);
        FHD_CAPTURE_SIZE = new Size(1920, 1080);
        QHD_CAPTURE_SIZE = new Size(2560, 1440);
        DEFAULT_VIDEO_CAPTURE_SIZE = size2;
        DEFAULT_IMAGE_CAPTURE_SIZE = QHD_CAPTURE_SIZE;
        DEFAULT_LENS = LensSelector.FRONT;
        DEFAULT_FLASH_MODE = FlashMode.OFF;
    }

    public CameraDeviceConfigurator setVideoCaptureSize(Size size) {
        this.mVideoCaptureSize = size;
        return this;
    }

    public CameraDeviceConfigurator setImageCaptureSize(Size size) {
        this.mImageCaptureSize = size;
        return this;
    }

    public CameraDeviceConfigurator setLens(LensSelector lensSelector) {
        boolean bl = lensSelector == LensSelector.FRONT;
        return this.setLens(lensSelector, bl);
    }

    public CameraDeviceConfigurator setLens(LensSelector lensSelector, boolean bl) {
        if (this.mLens != lensSelector) {
            CameraDeviceConfigurator cameraDeviceConfigurator = this;
            cameraDeviceConfigurator.mLinearZoom = 0.0f;
            cameraDeviceConfigurator.mTorchEnabled = false;
            cameraDeviceConfigurator.mZoomRatio = 1.0f;
        }
        this.mLens = lensSelector;
        this.mIsMirroringEnabled = bl;
        return this;
    }

    public CameraDeviceConfigurator setTorchEnabled(boolean bl) {
        this.mTorchEnabled = bl;
        return this;
    }

    public CameraDeviceConfigurator setFlashMode(FlashMode flashMode) {
        this.mFlashMode = flashMode;
        return this;
    }

    public CameraDeviceConfigurator setLinearZoom(float f) {
        this.mLinearZoom = f;
        this.mZoomRatio = 1.0f;
        return this;
    }

    public CameraDeviceConfigurator setZoomRatio(float f) {
        this.mLinearZoom = 0.0f;
        this.mZoomRatio = f;
        return this;
    }

    public CameraDeviceConfigurator setFrameRotationProviderCallback(IFrameRotationProviderCallback iFrameRotationProviderCallback) {
        this.mFrameRotationProviderCallback = iFrameRotationProviderCallback;
        return this;
    }

    public abstract void commit();

    public static enum LensSelector {
        FRONT,
        BACK;

    }

    public static interface IFrameRotationProviderCallback {
        public int onFrameRotation(int var1);
    }

    public static enum FlashMode {
        OFF,
        ON,
        AUTO;

    }
}

