/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.input;

import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.FrameProcessor;
import com.banuba.sdk.effect_player.ProcessorConfiguration;
import com.banuba.sdk.effect_player.RealtimeProcessorMode;
import com.banuba.sdk.input.CameraDevice;
import com.banuba.sdk.input.IInput;
import com.banuba.sdk.types.FrameData;
import java.util.Objects;

public class CameraInput
implements IInput {
    private final CameraDevice.ICapturedFrameInput mCapturedFrameCallback;
    private final CameraDevice mCameraDevice;
    private final FrameProcessor mFrameProcessor;
    private long mTimestamp;

    public CameraInput(@NonNull CameraDevice cameraDevice) {
        CameraInput cameraInput = this;
        CameraInput cameraInput2 = this;
        cameraInput2.mCapturedFrameCallback = cameraInput2::push;
        cameraInput2.mTimestamp = 0L;
        cameraInput.mCameraDevice = cameraDevice;
        cameraInput.mFrameProcessor = Objects.requireNonNull(FrameProcessor.createRealtimeProcessor((RealtimeProcessorMode)RealtimeProcessorMode.ASYNC, (ProcessorConfiguration)ProcessorConfiguration.create()));
    }

    private void push(@NonNull CameraDevice.FrameProvider frameProvider) {
        FrameData frameData = Objects.requireNonNull(FrameData.create());
        this.mTimestamp = System.nanoTime();
        frameData.addFullImg(frameProvider.getFullImageData());
        frameData.addFrameNumber(this.mTimestamp);
        this.mFrameProcessor.push(frameData);
    }

    @Override
    @NonNull
    public FrameProcessor frameProcessor() {
        return this.mFrameProcessor;
    }

    @Override
    public long getFrameTimeNanos() {
        return this.mTimestamp;
    }

    @Override
    public void attach() {
        this.mCameraDevice.addVideoCaptureListener(this.mCapturedFrameCallback);
    }

    @Override
    public void detach() {
        this.mCameraDevice.removeVideoCaptureListener(this.mCapturedFrameCallback);
    }
}

