/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.input;

import android.graphics.Bitmap;
import android.media.Image;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;
import com.banuba.sdk.effect_player.FrameProcessor;
import com.banuba.sdk.effect_player.ProcessorConfiguration;
import com.banuba.sdk.frame.FramePixelBuffer;
import com.banuba.sdk.frame.FramePixelBufferFormat;
import com.banuba.sdk.input.CameraDevice;
import com.banuba.sdk.input.IInput;
import com.banuba.sdk.internal.utils.CameraUtils;
import com.banuba.sdk.player.Orientation;
import com.banuba.sdk.types.FrameData;
import com.banuba.sdk.types.FullImageData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;

public class PhotoInput
implements IInput {
    private final FrameProcessor mFrameProcessor;

    public PhotoInput() {
        ProcessorConfiguration processorConfiguration = Objects.requireNonNull(ProcessorConfiguration.create());
        processorConfiguration.setUseFutureFilter(false);
        processorConfiguration.setUseOfflineMode(true);
        this.mFrameProcessor = Objects.requireNonNull(FrameProcessor.createPhotoProcessor((ProcessorConfiguration)processorConfiguration));
    }

    private void push(@NonNull FullImageData fullImageData) {
        PhotoInput photoInput = photoInput2;
        PhotoInput photoInput2 = Objects.requireNonNull(FrameData.create());
        photoInput2.addFullImg(fullImageData);
        photoInput2.addFrameNumber(System.nanoTime());
        photoInput.mFrameProcessor.push((FrameData)photoInput2);
    }

    public void take(@NonNull CameraDevice cameraDevice, @Nullable CameraDevice.IErrorOccurred iErrorOccurred) {
        cameraDevice.takePhoto(frameProvider -> this.push(frameProvider.getFullImageData()), iErrorOccurred);
    }

    public void take(Bitmap bitmap) {
        this.take(bitmap, Orientation.UP, false);
    }

    public void take(Bitmap bitmap, Orientation orientation, boolean bl) {
        FullImageData fullImageData;
        PhotoInput photoInput = photoInput2;
        PhotoInput photoInput2 = CameraUtils.makeFullImageDataOrientation(orientation, bl);
        orientation = fullImageData;
        fullImageData = new FullImageData(bitmap, (FullImageData.Orientation)photoInput2);
        photoInput.push((FullImageData)orientation);
    }

    public void take(Image image) {
        this.take(image, Orientation.UP, false);
    }

    public void take(FramePixelBuffer framePixelBuffer, Orientation enum_, boolean bl) {
        block4: {
            block3: {
                Size size;
                FullImageData fullImageData;
                FullImageData.Orientation orientation;
                block2: {
                    Size size2;
                    FullImageData fullImageData2;
                    Orientation orientation2 = enum_;
                    enum_ = framePixelBuffer.getFormat();
                    orientation = CameraUtils.makeFullImageDataOrientation(orientation2, bl);
                    if (!((FramePixelBufferFormat)enum_).isBpc8()) break block2;
                    enum_ = fullImageData2;
                    FramePixelBuffer framePixelBuffer2 = framePixelBuffer;
                    ByteBuffer byteBuffer = framePixelBuffer2.getBuffer();
                    Size size3 = size2;
                    FramePixelBuffer framePixelBuffer3 = framePixelBuffer;
                    int n = framePixelBuffer3.getWidth();
                    size2 = new Size(n, framePixelBuffer3.getHeight());
                    n = framePixelBuffer2.getBytesPerRow();
                    fullImageData2 = new FullImageData((Buffer)byteBuffer, size3, n, orientation);
                    break block3;
                }
                if (!((FramePixelBufferFormat)enum_).isI420()) break block4;
                FullImageData fullImageData3 = fullImageData;
                Enum enum_2 = enum_;
                FramePixelBuffer framePixelBuffer4 = framePixelBuffer;
                enum_ = size;
                FramePixelBuffer framePixelBuffer5 = framePixelBuffer;
                int n = framePixelBuffer5.getWidth();
                size = new Size(n, framePixelBuffer5.getHeight());
                ByteBuffer byteBuffer = framePixelBuffer4.getPlane(0);
                ByteBuffer byteBuffer2 = framePixelBuffer4.getPlane(1);
                ByteBuffer byteBuffer3 = framePixelBuffer4.getPlane(2);
                int n2 = framePixelBuffer4.getBytesPerRowOfPlane(0);
                int n3 = framePixelBuffer4.getBytesPerRowOfPlane(1);
                int n4 = framePixelBuffer4.getBytesPerRowOfPlane(2);
                int n5 = framePixelBuffer4.getBytesPerPixelOfPlane(0);
                int n6 = framePixelBuffer4.getBytesPerPixelOfPlane(1);
                int n7 = framePixelBuffer4.getBytesPerPixelOfPlane(2);
                ColorRange colorRange = ((FramePixelBufferFormat)enum_2).getColorRange();
                ColorStd colorStd = ((FramePixelBufferFormat)enum_2).getColorStandard();
                fullImageData = new FullImageData((Size)enum_, (Buffer)byteBuffer, (Buffer)byteBuffer2, (Buffer)byteBuffer3, n2, n3, n4, n5, n6, n7, orientation, null, colorRange, colorStd);
                enum_ = fullImageData3;
            }
            this.push((FullImageData)enum_);
            return;
        }
        throw new RuntimeException("Unknown format: " + enum_);
    }

    public void take(FramePixelBuffer framePixelBuffer) {
        this.take(framePixelBuffer, Orientation.UP, false);
    }

    public void take(Image image, Orientation orientation, boolean bl) {
        FullImageData fullImageData;
        PhotoInput photoInput = photoInput2;
        PhotoInput photoInput2 = CameraUtils.makeFullImageDataOrientation(orientation, bl);
        orientation = fullImageData;
        fullImageData = new FullImageData(image, (FullImageData.Orientation)photoInput2);
        photoInput.push((FullImageData)orientation);
    }

    @Override
    @NonNull
    public FrameProcessor frameProcessor() {
        return this.mFrameProcessor;
    }

    @Override
    public long getFrameTimeNanos() {
        return 0L;
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }
}

