/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.input;

import android.util.Size;
import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;
import com.banuba.sdk.effect_player.FrameProcessor;
import com.banuba.sdk.effect_player.ProcessorConfiguration;
import com.banuba.sdk.frame.FramePixelBuffer;
import com.banuba.sdk.frame.FramePixelBufferFormat;
import com.banuba.sdk.input.IInput;
import com.banuba.sdk.internal.utils.CameraUtils;
import com.banuba.sdk.player.Orientation;
import com.banuba.sdk.types.FrameData;
import com.banuba.sdk.types.FullImageData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;

public class StreamInput
implements IInput {
    private final FrameProcessor mFrameProcessor;
    private long mTimestamp = 0L;

    public StreamInput() {
        ProcessorConfiguration processorConfiguration = Objects.requireNonNull(ProcessorConfiguration.create());
        processorConfiguration.setUseOfflineMode(false);
        processorConfiguration.setUseFutureFilter(false);
        processorConfiguration.setUseFutureInterpolate(false);
        this.mFrameProcessor = Objects.requireNonNull(FrameProcessor.createVideoProcessor((ProcessorConfiguration)processorConfiguration));
    }

    public void push(@NonNull FrameData frameData, long l) {
        this.mFrameProcessor.push(frameData);
        this.mTimestamp = l;
    }

    public void push(FramePixelBuffer framePixelBuffer, Orientation enum_, boolean bl, long l) {
        block4: {
            block3: {
                Size size;
                FullImageData fullImageData;
                FullImageData.Orientation orientation;
                block2: {
                    Size size2;
                    FullImageData fullImageData2;
                    Orientation orientation2 = enum_;
                    enum_ = framePixelBuffer.getFormat();
                    orientation = CameraUtils.makeFullImageDataOrientation(orientation2, bl);
                    if (!((FramePixelBufferFormat)enum_).isBpc8()) break block2;
                    enum_ = fullImageData2;
                    FramePixelBuffer framePixelBuffer2 = framePixelBuffer;
                    ByteBuffer byteBuffer = framePixelBuffer2.getBuffer();
                    Size size3 = size2;
                    FramePixelBuffer framePixelBuffer3 = framePixelBuffer;
                    int n = framePixelBuffer3.getWidth();
                    size2 = new Size(n, framePixelBuffer3.getHeight());
                    n = framePixelBuffer2.getBytesPerRow();
                    fullImageData2 = new FullImageData((Buffer)byteBuffer, size3, n, orientation);
                    break block3;
                }
                if (!((FramePixelBufferFormat)enum_).isI420()) break block4;
                FullImageData fullImageData3 = fullImageData;
                Enum enum_2 = enum_;
                FramePixelBuffer framePixelBuffer4 = framePixelBuffer;
                enum_ = size;
                FramePixelBuffer framePixelBuffer5 = framePixelBuffer;
                int n = framePixelBuffer5.getWidth();
                size = new Size(n, framePixelBuffer5.getHeight());
                ByteBuffer byteBuffer = framePixelBuffer4.getPlane(0);
                ByteBuffer byteBuffer2 = framePixelBuffer4.getPlane(1);
                ByteBuffer byteBuffer3 = framePixelBuffer4.getPlane(2);
                int n2 = framePixelBuffer4.getBytesPerRowOfPlane(0);
                int n3 = framePixelBuffer4.getBytesPerRowOfPlane(1);
                int n4 = framePixelBuffer4.getBytesPerRowOfPlane(2);
                int n5 = framePixelBuffer4.getBytesPerPixelOfPlane(0);
                int n6 = framePixelBuffer4.getBytesPerPixelOfPlane(1);
                int n7 = framePixelBuffer4.getBytesPerPixelOfPlane(2);
                ColorRange colorRange = ((FramePixelBufferFormat)enum_2).getColorRange();
                ColorStd colorStd = ((FramePixelBufferFormat)enum_2).getColorStandard();
                fullImageData = new FullImageData((Size)enum_, (Buffer)byteBuffer, (Buffer)byteBuffer2, (Buffer)byteBuffer3, n2, n3, n4, n5, n6, n7, orientation, null, colorRange, colorStd);
                enum_ = fullImageData3;
            }
            FrameData frameData = Objects.requireNonNull(FrameData.create());
            frameData.addFullImg((FullImageData)enum_);
            frameData.addFrameNumber(System.nanoTime());
            this.push(frameData, l);
            return;
        }
        throw new RuntimeException("Unknown format: " + enum_);
    }

    public void push(FramePixelBuffer framePixelBuffer, long l) {
        this.push(framePixelBuffer, Orientation.UP, false, l);
    }

    @Override
    @NonNull
    public FrameProcessor frameProcessor() {
        return this.mFrameProcessor;
    }

    @Override
    public long getFrameTimeNanos() {
        return this.mTimestamp;
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }
}

