/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.input;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.FrameProcessor;
import com.banuba.sdk.effect_player.ProcessorConfiguration;
import com.banuba.sdk.input.IInput;
import com.banuba.sdk.internal.threads.SimpleThread;
import com.banuba.sdk.internal.threads.SimpleThreadHandler;
import com.banuba.sdk.video.IAudioDataProvider;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;

public class VideoInput
implements IInput,
IAudioDataProvider {
    private final FrameProcessor mFrameProcessor;
    private SimpleThread mThread;
    private long mTimestamp = 0L;
    private MediaFormat mAudioFormat = null;
    private LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>> mAudioData = null;
    private volatile boolean mStopRequired;

    public VideoInput() {
        ProcessorConfiguration processorConfiguration = Objects.requireNonNull(ProcessorConfiguration.create());
        processorConfiguration.setUseOfflineMode(false);
        processorConfiguration.setUseFutureFilter(false);
        processorConfiguration.setUseFutureInterpolate(false);
        this.mFrameProcessor = Objects.requireNonNull(FrameProcessor.createVideoProcessor((ProcessorConfiguration)processorConfiguration));
    }

    static /* synthetic */ long access$002(VideoInput videoInput, long l) {
        videoInput.mTimestamp = l;
        return l;
    }

    @Override
    @Nullable
    public MediaFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    @Override
    @Nullable
    public LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>> getAudioData() {
        return this.mAudioData;
    }

    public synchronized void processVideoFile(@NonNull File file, @NonNull IVideoFrameStatus iVideoFrameStatus) {
        VideoInput videoInput = this;
        videoInput.stopProcessing();
        this.mThread = new SimpleThread("VideoInputExtractorThread");
        this.mThread.startAndGetHandler();
        videoInput.mThread.runAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public synchronized void stopProcessing() {
        this.mStopRequired = true;
        this.mAudioFormat = null;
        this.mAudioData = null;
        SimpleThread simpleThread = this.mThread;
        if (simpleThread != null) {
            SimpleThread simpleThread2 = simpleThread;
            simpleThread2.runAndWaitForFinish(() -> {});
            ((SimpleThreadHandler)((Object)simpleThread2.getHandler())).sendShutdown();
            this.mThread = null;
        }
    }

    @Override
    @NonNull
    public FrameProcessor frameProcessor() {
        return this.mFrameProcessor;
    }

    @Override
    public long getFrameTimeNanos() {
        return this.mTimestamp;
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    public static interface IVideoFrameStatus {
        public void onStart();

        public void onFrame();

        public void onError(@NonNull Throwable var1);

        public void onFinish();
    }
}

