/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.internal.utils.Logger;

public abstract class BaseWorkThread<H extends Handler>
extends Thread {
    private final Object mStartLock;
    private H mHandler;
    private volatile boolean mReady;

    public BaseWorkThread(String string) {
        super(string);
        Object object;
        Object object2 = object;
        object = new Object();
        v1.mStartLock = object2;
        v1.mReady = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilReady() {
        Object object = this.mStartLock;
        synchronized (object) {
            while (true) {
                if (this.mReady) {
                    return;
                }
                try {
                    this.mStartLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logger.e(interruptedException.getMessage(), new Object[0]);
                }
            }
        }
    }

    @NonNull
    protected abstract H constructHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BaseWorkThread baseWorkThread = this;
        Looper.prepare();
        baseWorkThread.mHandler = baseWorkThread.constructHandler();
        baseWorkThread.preRunInit();
        Object object = baseWorkThread.mStartLock;
        synchronized (object) {
            this.mReady = true;
            this.mStartLock.notify();
        }
        Looper.loop();
        baseWorkThread.postRunClear();
        Object object2 = baseWorkThread.mStartLock;
        synchronized (object2) {
            this.mReady = false;
            return;
        }
    }

    protected void preRunInit() {
    }

    protected void postRunClear() {
    }

    @NonNull
    public H startAndGetHandler() {
        if (!this.mReady) {
            BaseWorkThread baseWorkThread = this;
            super.start();
            baseWorkThread.waitUntilReady();
        }
        return this.mHandler;
    }

    @Nullable
    public H getHandler() {
        return this.mHandler;
    }

    protected void releaseHandler() {
        this.mHandler = null;
    }

    @CallSuper
    public void shutdown() {
        BaseWorkThread baseWorkThread = Looper.myLooper();
        if (baseWorkThread != null) {
            baseWorkThread.quit();
        }
    }
}

