/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal;

import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;

public final class YuvConversionMatrices {
    public static final float[] MAT_CVT_FROM_BT601_VIDEO_RANGE_TO_RGB = new float[]{1.1643835f, 0.0f, 1.5960268f, -0.8742022f, 1.1643835f, -0.3917623f, -0.81296766f, 0.5316678f, 1.1643835f, 2.0172322f, 0.0f, -1.0856308f};
    public static final float[] MAT_CVT_FROM_BT601_FULL_RANGE_TO_RGB = new float[]{1.0f, 0.0f, 1.402f, -0.703749f, 1.0f, -0.3441363f, -0.7141363f, 0.5312113f, 1.0f, 1.772f, 0.0f, -0.8894745f};
    public static final float[] MAT_CVT_FROM_BT709_VIDEO_RANGE_TO_RGB = new float[]{1.1643835f, 0.0f, 1.7927411f, -0.9729451f, 1.1643835f, -0.21324861f, -0.53290933f, 0.30148268f, 1.1643835f, 2.1124017f, 0.0f, -1.1334022f};
    public static final float[] MAT_CVT_FROM_BT709_FULL_RANGE_TO_RGB = new float[]{1.0f, 0.0f, 1.5748f, -0.7904878f, 1.0f, -0.18732427f, -0.46812427f, 0.32900947f, 1.0f, 1.8556f, 0.0f, -0.93143845f};
    public static final float[] MAT_CVT_FROM_RGB_TO_BT601_VIDEO_RANGE = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f, -0.148223f, -0.290993f, 0.439216f, 0.501961f, 0.439216f, -0.367788f, -0.0714274f, 0.501961f};
    public static final float[] MAT_CVT_FROM_RGB_TO_BT601_FULL_RANGE = new float[]{0.299f, 0.587f, 0.114f, 0.0f, -0.16873589f, -0.3312641f, 0.5f, 0.5f, 0.5f, -0.41868758f, -0.08131241f, 0.5f};
    public static final float[] MAT_CVT_FROM_RGB_TO_BT709_VIDEO_RANGE = new float[]{0.18258588f, 0.6142306f, 0.06200706f, 0.0627451f, -0.10064373f, -0.33857197f, 0.4392157f, 0.5019608f, 0.4392157f, -0.39894217f, -0.040273525f, 0.5019608f};
    public static final float[] MAT_CVT_FROM_RGB_TO_BT709_FULL_RANGE = new float[]{0.2126f, 0.7152f, 0.0722f, 0.0f, -0.11457211f, -0.3854279f, 0.5f, 0.5019608f, 0.5f, -0.4541529f, -0.04584709f, 0.5019608f};
    public static final int OFFSET_TO_Y_COEFFS = 0;
    public static final int OFFSET_TO_U_COEFFS = 4;
    public static final int OFFSET_TO_V_COEFFS = 8;
    public static final int OFFSET_TO_R_COEFFS = 0;
    public static final int OFFSET_TO_G_COEFFS = 4;
    public static final int OFFSET_TO_B_COEFFS = 8;

    public static float[] getConvMatrixFromRgbToYuv(ColorStd colorStd, ColorRange colorRange) {
        if (colorStd == ColorStd.BT601) {
            if (colorRange == ColorRange.FULL) {
                return MAT_CVT_FROM_RGB_TO_BT601_FULL_RANGE;
            }
            return MAT_CVT_FROM_RGB_TO_BT601_VIDEO_RANGE;
        }
        if (colorRange == ColorRange.FULL) {
            return MAT_CVT_FROM_RGB_TO_BT709_FULL_RANGE;
        }
        return MAT_CVT_FROM_RGB_TO_BT709_VIDEO_RANGE;
    }

    public static float[] getConvMatrixFromYuvToRgb(ColorStd colorStd, ColorRange colorRange) {
        if (colorStd == ColorStd.BT601) {
            if (colorRange == ColorRange.FULL) {
                return MAT_CVT_FROM_BT601_FULL_RANGE_TO_RGB;
            }
            return MAT_CVT_FROM_BT601_VIDEO_RANGE_TO_RGB;
        }
        if (colorRange == ColorRange.FULL) {
            return MAT_CVT_FROM_BT709_FULL_RANGE_TO_RGB;
        }
        return MAT_CVT_FROM_BT709_VIDEO_RANGE_TO_RGB;
    }

    private YuvConversionMatrices() {
    }
}

