/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.media.MediaFormat;
import android.opengl.GLES30;
import android.os.Handler;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.camera.CameraFpsMode;
import com.banuba.sdk.camera.Facing;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.entity.DebugVideoCallbackInfo;
import com.banuba.sdk.entity.DebugVideoCallbackListener;
import com.banuba.sdk.entity.RecordedVideoInfo;
import com.banuba.sdk.internal.camera.CameraFormatHelper;
import com.banuba.sdk.internal.camera.CameraListenerSender;
import com.banuba.sdk.internal.camera.ICamera2;
import com.banuba.sdk.internal.encoding.MediaMuxerWrapper;
import com.banuba.sdk.internal.encoding.OnCompleteRecordingListener;
import com.banuba.sdk.internal.encoding.RecordingListener;
import com.banuba.sdk.internal.encoding.RecordingListenerHandler;
import com.banuba.sdk.internal.encoding.RecordingParams;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.ImageRenderer;
import com.banuba.sdk.internal.gl.OffscreenSurface;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.internal.renderer.RenderHandler;
import com.banuba.sdk.internal.utils.CameraUtils;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.manager.IFpsController;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.utils.ATrace;
import com.banuba.sdk.utils.ContextProvider;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public class Camera2
implements ICamera2 {
    private static final int FIXED_FRAME_RATE = 30;
    private static final int DEFAULT_SENSOR_ORIENTATION = 270;
    public static TreeMap<Long, Long> sPushedFrames = new TreeMap();
    private final Context mContext;
    private final RecordingListenerHandler mRecordingListenerHandler;
    private boolean mIsCameraOpened = false;
    private final Handler mHandler;
    private final CameraManager mCameraManager;
    private final CameraListenerSender mCameraListenerSender;
    private final EffectPlayer mEffectPlayer;
    private CameraDevice mCameraDevice;
    private ImageReader mImageReader;
    private ImageReader mHighResImageReader;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private CameraCaptureSession mCaptureSession;
    @NonNull
    private final Size mPreferredPreviewSize;
    private Size mPreviewSize;
    private FullImageData.Orientation mOrientation;
    private Facing cameraFacing;
    private Rect rectInit;
    private Float maxZoom;
    private Float currentZoom;
    @NonNull
    private CameraFpsMode mFpsMode;
    private long mCurrentFrameNumber;
    private CameraCharacteristics mCameraCharacteristics;
    private int mPreviewFormat;
    private volatile boolean pushOn;
    private final Object mSyncObj;
    private int screenOrientation;
    @Nullable
    private final IFpsController mFpsController;
    private boolean requireMirroring;
    private int sensorOrientation;
    private EglCore mEglCore;
    private OffscreenSurface mOffscreenSurface;
    private WindowSurface mInputWindowSurface;
    private MediaMuxerWrapper mMuxer;
    private WeakReference<DebugVideoCallbackListener> mWRListener;
    private long mLastFrameTime;
    private boolean mRecordingInProgress;
    private ImageRenderer mImageRenderer;
    private boolean mFlashEnabled;
    private final OnCompleteRecordingListener mVideoCompleteListener;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener;
    private final CameraDevice.StateCallback mStateCallback;
    private final CameraCaptureSession.CaptureCallback mCaptureCallback;
    private final CameraCaptureSession.CaptureCallback mHiResCompleteListener;

    public Camera2(EffectPlayer effectPlayer, CameraListenerSender object, @NonNull CameraManager cameraManager, @NonNull Size size, @Nullable IFpsController iFpsController) {
        RecordingListenerHandler recordingListenerHandler;
        Context context;
        Handler handler;
        Size size2;
        CameraCaptureSession.CaptureCallback captureCallback;
        Switch2YUVCaptureCallback switch2YUVCaptureCallback;
        CameraDevice.StateCallback stateCallback;
        ImageReader.OnImageAvailableListener onImageAvailableListener;
        OnCompleteRecordingListener onCompleteRecordingListener;
        Object object2;
        FullImageData.Orientation orientation;
        Object object3 = orientation;
        orientation = new FullImageData.Orientation();
        this.mOrientation = object3;
        this.cameraFacing = Facing.NONE;
        this.rectInit = null;
        this.maxZoom = null;
        this.currentZoom = null;
        this.mFpsMode = CameraFpsMode.DEFAULT;
        this.pushOn = true;
        object3 = object2;
        object2 = new Object();
        this.mSyncObj = object3;
        this.screenOrientation = 0;
        this.requireMirroring = false;
        this.sensorOrientation = 3;
        object3 = onCompleteRecordingListener;
        onCompleteRecordingListener = new OnCompleteRecordingListener(){

            @Override
            public void onRecordingCompleted(@NonNull RecordedVideoInfo recordedVideoInfo) {
                1 v0 = this;
                Camera2.access$002(v0.Camera2.this, false);
                Object object = v0.Camera2.this.mInputWindowSurface;
                if (object != null) {
                    ((WindowSurface)object).release();
                    Camera2.access$102(Camera2.this, null);
                }
                1 v1 = this;
                Camera2.access$202(v1.Camera2.this, null);
                object = v1.Camera2.this.mWRListener != null ? (DebugVideoCallbackListener)Camera2.this.mWRListener.get() : null;
                if (object != null) {
                    object.onDebugVideoDone(new DebugVideoCallbackInfo(3, "Debug Video recorded to " + recordedVideoInfo.getFilePath() + "\nduration = " + recordedVideoInfo.getRecordedLength() + " ms"));
                }
                Camera2.access$302(Camera2.this, null);
            }
        };
        this.mVideoCompleteListener = object3;
        Object object4 = onImageAvailableListener;
        onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader imageReader) {
                ATrace aTrace;
                aTrace2("CameraThreadIteration_" + Camera2.this.mCurrentFrameNumber);
                try (ATrace aTrace2 = aTrace;){
                    Camera2.this.pushFrame(imageReader);
                }
            }
        };
        this.mOnImageAvailableListener = object4;
        object4 = stateCallback;
        stateCallback = new CameraDevice.StateCallback(){

            public void onOpened(@NonNull CameraDevice cameraDevice) {
                3 v0 = this;
                Camera2.access$602(v0.Camera2.this, cameraDevice);
                v0.Camera2.this.createCameraPreviewSession();
                v0.Camera2.this.mCameraListenerSender.sendCameraStatus(true);
            }

            public void onDisconnected(@NonNull CameraDevice cameraDevice) {
                Camera2.this.onCameraClosedState(cameraDevice);
            }

            public void onError(@NonNull CameraDevice cameraDevice, int n) {
                3 v0 = this;
                v0.Camera2.this.onCameraClosedState(cameraDevice);
                v0.Camera2.this.mCameraListenerSender.sendCameraOpenError(new Exception("Camera error: " + n).fillInStackTrace());
            }

            public void onClosed(@NonNull CameraDevice cameraDevice) {
                Camera2.this.onCameraClosedState(cameraDevice);
            }
        };
        this.mStateCallback = object4;
        object4 = switch2YUVCaptureCallback;
        switch2YUVCaptureCallback = new Switch2YUVCaptureCallback();
        this.mCaptureCallback = object4;
        object4 = captureCallback;
        captureCallback = new CameraCaptureSession.CaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
                5 v0 = this;
                super.onCaptureCompleted(cameraCaptureSession, captureRequest, totalCaptureResult);
                v0.Camera2.this.createCameraPreviewSession();
            }
        };
        this.mHiResCompleteListener = object4;
        this.mCameraManager = cameraManager;
        this.mCameraListenerSender = object;
        this.mEffectPlayer = effectPlayer;
        effectPlayer = size2;
        Size size3 = size;
        int n = size3.getHeight();
        size2 = new Size(n, size3.getWidth());
        this.mPreferredPreviewSize = effectPlayer;
        effectPlayer = handler;
        handler = new Handler();
        this.mHandler = effectPlayer;
        this.mContext = context = ContextProvider.getContext();
        object.sendCameraStatus(false);
        object = recordingListenerHandler;
        recordingListenerHandler = new RecordingListenerHandler((RecordingListener)object3, effectPlayer.getLooper());
        this.mRecordingListenerHandler = object;
        this.mCurrentFrameNumber = 0L;
        this.mFpsController = iFpsController;
        this.mPreviewFormat = CameraFormatHelper.getPreferablePreviewFormat(context);
        Logger.d("Camera.Format = " + CameraFormatHelper.decodePreviewFormat(this.mPreviewFormat), new Object[0]);
    }

    /*
     * Exception decompiling
     */
    private void pushFrame(ImageReader var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    @SuppressLint(value={"MissingPermission"})
    private void openCamera(Facing facing) {
        if (facing == Facing.NONE) {
            Logger.e("cannot open unknown camera facing!", new Object[0]);
            return;
        }
        if (!this.mIsCameraOpened) {
            String string;
            Exception exception;
            block17: {
                exception = null;
                string = null;
                String[] stringArray = this.mCameraManager;
                if (this.mCameraManager == null) break block17;
                stringArray = stringArray.getCameraIdList();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    block18: {
                        Camera2 camera2 = this;
                        String string2 = stringArray[i];
                        CameraCharacteristics cameraCharacteristics = camera2.mCameraManager.getCameraCharacteristics(string2);
                        this.mCameraCharacteristics = cameraCharacteristics;
                        Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                        if (n2 == null) continue;
                        if (n2.intValue() != facing.getValue()) continue;
                        try {
                            Camera2 camera22 = this;
                            camera22.setupCameraCharacteristics(camera22.mCameraCharacteristics);
                            string = string2;
                            break;
                        }
                        catch (Exception exception2) {
                            string = string2;
                            exception = exception2;
                            break block18;
                        }
                        catch (Exception exception3) {
                            exception = exception3;
                        }
                    }
                    Logger.wtf(exception);
                    break;
                }
            }
            if (string != null) {
                try {
                    this.mIsCameraOpened = true;
                    this.mCameraManager.openCamera(string, this.mStateCallback, null);
                }
                catch (Exception exception4) {
                    exception = exception4;
                    this.mIsCameraOpened = false;
                    Logger.wtf(exception);
                }
            }
            if (exception != null) {
                this.mCameraListenerSender.sendCameraOpenError(exception);
            }
        }
    }

    private CameraOrientation convertFromScreenOrientation(int n, int n2) {
        block6: {
            int n3;
            block5: {
                block4: {
                    Object object = object.cameraFacing;
                    if (object != Facing.FRONT) break block4;
                    n3 = (n + n2) % CameraOrientation.values().length;
                    break block5;
                }
                if (object != Facing.BACK) break block6;
                n3 = (n - n2) % CameraOrientation.values().length;
                if (n3 < 0) {
                    n3 += CameraOrientation.values().length;
                }
            }
            return CameraOrientation.values()[n3];
        }
        return CameraOrientation.DEG_0;
    }

    private void setupCameraCharacteristics(@NonNull CameraCharacteristics cameraCharacteristics) {
        this.maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        this.rectInit = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if ((StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP) != null) {
            int n;
            Camera2 camera2 = this;
            camera2.sensorOrientation = n = CameraUtils.getSensorOrientation(cameraCharacteristics) / 90;
            Object[] objectArray = camera2.convertFromScreenOrientation(n, camera2.screenOrientation);
            camera2.mOrientation = new FullImageData.Orientation((CameraOrientation)objectArray, this.requireMirroring, 0);
            objectArray = CameraUtils.getPreviewSize(cameraCharacteristics, camera2.mPreferredPreviewSize);
            this.mPreviewSize = objectArray;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = objectArray;
            Logger.i("Preview size: %s", objectArray3);
            if (!this.mPreviewSize.equals((Object)this.mPreferredPreviewSize)) {
                Object[] objectArray4 = new Object[2];
                objectArray = objectArray4;
                objectArray[0] = this.mPreviewSize;
                objectArray4[1] = this.mPreferredPreviewSize;
                Logger.w("It was requested %s resolution, but it is not supported by the device camera, it was selected the nearest one - %s ", objectArray);
            }
        }
    }

    private void onCameraClosedState(@NonNull CameraDevice cameraDevice) {
        cameraDevice.close();
        if (this.mCameraDevice == cameraDevice) {
            this.mCameraListenerSender.sendCameraStatus(false);
            this.mCameraDevice = null;
            this.mIsCameraOpened = false;
        }
    }

    private void createCameraPreviewSession() {
        try {
            Camera2 camera2 = this;
            camera2.createPreviewRequest();
            camera2.mCameraDevice.createCaptureSession(Collections.singletonList(this.mImageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                /*
                 * WARNING - void declaration
                 */
                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    block7: {
                        void var1_4;
                        if (Camera2.this.mCameraDevice == null) {
                            return;
                        }
                        4 v0 = this;
                        Camera2.access$1302(v0.Camera2.this, cameraCaptureSession);
                        CameraCaptureSession cameraCaptureSession2 = v0.Camera2.this.mCaptureSession;
                        CaptureRequest captureRequest = Camera2.this.mPreviewRequestBuilder.build();
                        4 v3 = this;
                        4 v4 = v3;
                        cameraCaptureSession = v3.Camera2.this.mCaptureCallback;
                        cameraCaptureSession2.setRepeatingRequest(captureRequest, (CameraCaptureSession.CaptureCallback)cameraCaptureSession, v4.Camera2.this.mHandler);
                        if (v0.Camera2.this.currentZoom == null) break block7;
                        try {
                            Camera2 camera2 = Camera2.this;
                            camera2.applyZoom(camera2.currentZoom.floatValue());
                            break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (CameraAccessException cameraAccessException) {
                            // empty catch block
                        }
                        Logger.wtf((Throwable)var1_4);
                        Camera2.this.mCameraListenerSender.sendCameraOpenError(new RuntimeException("CameraCaptureSession.StateCallback.onConfigured", (Throwable)var1_4).fillInStackTrace());
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    if (Camera2.this.mPreviewFormat == 1) {
                        Camera2.this.switchToYUV("1.CaptureSession.onConfigureFailed", true);
                    } else {
                        Camera2.this.mCameraListenerSender.sendCameraOpenError(new RuntimeException("CameraCaptureSession.StateCallback.onConfigureFailed").fillInStackTrace());
                    }
                }
            }, null);
        }
        catch (CameraAccessException cameraAccessException) {
            Logger.wtf(cameraAccessException);
        }
    }

    private void switchToYUV(@NonNull String string, boolean bl) {
        this.mPreviewFormat = 35;
        CameraFormatHelper.savePreferablePreviewFormat(this.mContext, 35);
        if (bl) {
            this.createCameraPreviewSession();
        }
        Logger.e("Camera!. Fallback to YUV from RGB on " + string, new Object[0]);
    }

    private void createPreviewRequest() {
        this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
        ImageReader imageReader = this.mImageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        try {
            this.mImageReader = ImageReader.newInstance((int)this.mPreviewSize.getWidth(), (int)this.mPreviewSize.getHeight(), (int)this.mPreviewFormat, (int)3);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.mPreviewFormat = 35;
            CameraFormatHelper.savePreferablePreviewFormat(this.mContext, 35);
            this.switchToYUV("0.ImageReader.newInstance.UnsupportedOperationException", false);
            this.mImageReader = ImageReader.newInstance((int)this.mPreviewSize.getWidth(), (int)this.mPreviewSize.getHeight(), (int)this.mPreviewFormat, (int)3);
        }
        this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, null);
        if (this.mFlashEnabled) {
            this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
        }
        this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        imageReader = this.mCameraCharacteristics;
        if (imageReader != null) {
            CameraFpsMode cameraFpsMode = this.mFpsMode;
            this.setAETargetFpsRange((CameraCharacteristics)imageReader, cameraFpsMode);
        }
    }

    private void closeHiResImageReader() {
        Camera2 camera2 = camera2.mHighResImageReader;
        if (camera2 != null) {
            try {
                camera2.close();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                Logger.e("Error while closing HI RES image readed", objectArray2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeCamera() {
        Camera2 camera2 = this;
        camera2.mIsCameraOpened = false;
        camera2.mHandler.removeCallbacksAndMessages(null);
        CameraCaptureSession cameraCaptureSession = camera2.mCaptureSession;
        if (cameraCaptureSession != null) {
            Throwable throwable2;
            try {
                try {
                    cameraCaptureSession.stopRepeating();
                }
                catch (IllegalStateException throwable2) {
                }
            }
            catch (CameraAccessException throwable2) {
                // empty catch block
            }
            Logger.i(throwable2.getMessage(), new Object[0]);
            cameraCaptureSession.close();
            this.mCaptureSession = null;
        }
        if ((cameraCaptureSession = this.mCameraDevice) != null) {
            cameraCaptureSession.close();
            this.mCameraDevice = null;
        }
        if ((cameraCaptureSession = this.mImageReader) != null) {
            CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
            cameraCaptureSession2.setOnImageAvailableListener(null, null);
            cameraCaptureSession2.close();
            this.mImageReader = null;
        }
        this.closeHiResImageReader();
    }

    /*
     * Unable to fully structure code
     */
    private int getFaceOrientation(int var1_2, int var2_3, boolean var3_4) {
        block5: {
            block8: {
                block7: {
                    block4: {
                        block6: {
                            var0_1 = 0;
                            if (var1_2 == 90 || var1_2 == 270) break block4;
                            if (var1_2 != 0 && var1_2 != 180) break block5;
                            if (var2_3 == 0 || var2_3 == 180) break block6;
                            if ((var2_3 != 270 || var1_2 != 0) && (var2_3 != 90 || var1_2 != 180)) break block5;
                            break block7;
                        }
                        var0_1 = var3_4 != false ? -1 : 1;
                        var1_2 = var1_2 == 0 ? 1 : -1;
                        var0_1 *= var1_2;
                        if (var2_3 != 0) ** GOTO lbl-1000
                        ** GOTO lbl-1000
                    }
                    if (var2_3 == 90 || var2_3 == 270) break block8;
                    if ((var2_3 != 180 || var1_2 != 270) && (var2_3 != 0 || var1_2 != 90)) break block5;
                }
                var0_1 = 180;
                break block5;
            }
            var0_1 = var3_4 != false ? 1 : -1;
            var1_2 = var1_2 == 270 ? 1 : -1;
            var0_1 *= var1_2;
            if (var2_3 == 90) lbl-1000:
            // 2 sources

            {
                var1_2 = 90;
            } else lbl-1000:
            // 2 sources

            {
                var1_2 = -90;
            }
            var0_1 *= var1_2;
        }
        return var0_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Range<Integer> getAETargetFpsRange(@NonNull CameraCharacteristics range3, @NonNull CameraFpsMode object2) {
        block8: {
            Object object3;
            List<Range<Integer>> list;
            Object object4;
            block11: {
                block9: {
                    block10: {
                        range3 = (Range)range3.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
                        object4 = (range, range2) -> {
                            if (((Integer)range.getUpper()).equals(range2.getUpper())) {
                                return ((Integer)range.getLower()).compareTo((Integer)range2.getLower());
                            }
                            return ((Integer)range.getUpper()).compareTo((Integer)range2.getUpper());
                        };
                        list = Arrays.asList(range3);
                        Collections.sort(list, object4);
                        if (range3 == null || list.isEmpty()) break block9;
                        object4 = object -> {
                            block2: {
                                List list2 = list;
                                list = (Range)list2.get(0);
                                for (Range range : list2) {
                                    if (!object.equals((Object)range)) {
                                        if (((Integer)object.getUpper()).compareTo((Integer)range.getUpper()) < 0 || ((Integer)list.getUpper()).equals(range.getUpper()) && (!((Integer)list.getUpper()).equals(range.getUpper()) || ((Integer)object.getLower()).compareTo((Integer)range.getLower()) < 0)) continue;
                                        list = range;
                                        continue;
                                    }
                                    break block2;
                                }
                                object = list;
                            }
                            return object;
                        };
                        int n = 7.$SwitchMap$com$banuba$sdk$camera$CameraFpsMode[((Enum)object2).ordinal()];
                        if (n == 1) break block10;
                        if (n != 2) {
                            throw new IllegalArgumentException("Not supported mode: " + object2);
                        }
                        object3 = ((Camera2)object3).mFpsController;
                        if (object3 == null) {
                            object3 = Range.create((Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(30));
                            break block8;
                        } else {
                            Range<Integer> range4 = object3.getFps(list, null);
                            object3 = (Range)object4.apply(range4);
                            if (!range4.equals(object3)) {
                                Logger.w("Selected range does not exists in available Fps range list, closest range was found: " + object3, new Object[0]);
                            }
                            object3 = Range.create((Comparable)((Integer)object3.getUpper()), (Comparable)((Integer)object3.getUpper()));
                        }
                        break block8;
                    }
                    range3 = range3[0];
                    ArrayList<Range> arrayList = new ArrayList<Range>(list);
                    Collections.reverse(arrayList);
                    object2 = arrayList.iterator();
                    break block11;
                }
                throw new IllegalArgumentException("No one Fps range available");
            }
            while (object2.hasNext()) {
                Range range5 = (Range)object2.next();
                if (((Integer)range3.getUpper()).compareTo((Integer)range5.getUpper()) >= 0 && (!((Integer)range3.getUpper()).equals(range5.getUpper()) || ((Integer)range3.getLower()).compareTo((Integer)range5.getLower()) <= 0)) continue;
                range3 = range5;
            }
            object3 = ((Camera2)object3).mFpsController;
            if (object3 == null) {
                object3 = range3;
            } else {
                Range<Integer> range6 = object3.getFps(list, (Range<Integer>)range3);
                object3 = (Range)object4.apply(range6);
                if (!range6.equals(object3)) {
                    Logger.w("Selected range does not exists in available Fps range list, closest range was found: " + object3, new Object[0]);
                }
            }
        }
        Logger.i("Selected fpsRange: " + object3, new Object[0]);
        return object3;
    }

    private boolean cropRegion(@Nullable CaptureRequest.Builder builder, float f) {
        Float f2 = this.maxZoom;
        if (f2 != null && this.rectInit != null) {
            if (f < 1.0f) {
                f = 1.0f;
            }
            if (f > f2.floatValue()) {
                f = this.maxZoom.floatValue();
            }
            if (builder != null) {
                builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)CameraUtils.getCroppedRect(this.rectInit, f));
                return true;
            }
        }
        return false;
    }

    private void setAETargetFpsRange(@NonNull CameraCharacteristics cameraCharacteristics, @NonNull CameraFpsMode cameraFpsMode) {
        Range<Integer> range = range2;
        Range<Integer> range2 = range.getAETargetFpsRange(cameraCharacteristics, cameraFpsMode);
        range.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, range2);
    }

    static /* synthetic */ boolean access$002(Camera2 camera2, boolean bl) {
        camera2.mRecordingInProgress = bl;
        return bl;
    }

    static /* synthetic */ WindowSurface access$102(Camera2 camera2, WindowSurface windowSurface) {
        camera2.mInputWindowSurface = windowSurface;
        return windowSurface;
    }

    static /* synthetic */ MediaMuxerWrapper access$202(Camera2 camera2, MediaMuxerWrapper mediaMuxerWrapper) {
        camera2.mMuxer = mediaMuxerWrapper;
        return mediaMuxerWrapper;
    }

    static /* synthetic */ WeakReference access$302(Camera2 camera2, WeakReference weakReference) {
        camera2.mWRListener = weakReference;
        return weakReference;
    }

    static /* synthetic */ CameraDevice access$602(Camera2 camera2, CameraDevice cameraDevice) {
        camera2.mCameraDevice = cameraDevice;
        return cameraDevice;
    }

    static /* synthetic */ CameraCaptureSession access$1302(Camera2 camera2, CameraCaptureSession cameraCaptureSession) {
        camera2.mCaptureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPushOn(boolean bl) {
        Object object = this.mSyncObj;
        synchronized (object) {
            this.pushOn = bl;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void requestHighResPhoto() {
        CameraCaptureSession.StateCallback stateCallback;
        List<Surface> list;
        Camera2 camera2;
        CameraDevice cameraDevice;
        Size size;
        Camera2 camera22;
        Camera2 camera23;
        Camera2 camera24;
        try {
            Camera2 camera25 = camera27;
            camera24 = camera25;
            camera23 = camera25;
            camera22 = camera25;
            camera25.mCaptureSession.stopRepeating();
            camera25.closeHiResImageReader();
            size = CameraUtils.getHighResPhotoSize(camera25.mCameraCharacteristics);
        }
        catch (Exception exception) {
            Size size2 = new Object[1];
            size = size2;
            size2[0] = exception;
            Logger.e("Error while requesting HI RES photo", (Object[])size);
            return;
        }
        {
            size = ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)256, (int)2);
        }
        {
            camera27.mHighResImageReader = size;
            size.setOnImageAvailableListener(imageReader -> {
                FullImageData fullImageData;
                ATrace aTrace;
                imageReader = imageReader.acquireLatestImage();
                ATrace aTrace2 = aTrace;
                Camera2 camera2 = this;
                ImageReader imageReader2 = imageReader;
                aTrace2("CameraThreadIteration");
                ByteBuffer byteBuffer = imageReader2.getPlanes()[0].getBuffer();
                int n = byteBuffer.remaining();
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                byteBuffer = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)n);
                FullImageData fullImageData2 = fullImageData;
                fullImageData = new FullImageData((Bitmap)byteBuffer, this.mOrientation);
                camera2.mCameraListenerSender.sendHighResPhoto(fullImageData2);
                aTrace.close();
                imageReader.close();
                catch (Throwable throwable) {
                    try {
                        aTrace2.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            if (imageReader == null) throw throwable3;
                            try {
                                imageReader.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                                catch (Exception exception) {
                                    ATrace aTrace3 = new Object[1];
                                    aTrace2 = aTrace3;
                                    aTrace3[0] = exception;
                                    Logger.e("Error while processing the latest image!", (Object[])aTrace2);
                                }
                            }
                        }
                    }
                }
                this.closeHiResImageReader();
            }, null);
            size = camera22.mCameraDevice.createCaptureRequest(2);
        }
        {
            camera24.cropRegion((CaptureRequest.Builder)size, camera27.currentZoom.floatValue());
        }
        {
            if (camera23.mFlashEnabled) {
                size.set(CaptureRequest.FLASH_MODE, (Object)2);
            }
            size.addTarget(camera27.mHighResImageReader.getSurface());
            cameraDevice = camera27.mCameraDevice;
            Camera2 camera26 = camera27;
            camera2 = camera26;
            list = Collections.singletonList(camera26.mHighResImageReader.getSurface());
        }
        CameraCaptureSession.StateCallback stateCallback2 = stateCallback;
        {
            stateCallback = new CameraCaptureSession.StateCallback((CaptureRequest.Builder)size){
                final /* synthetic */ CaptureRequest.Builder val$requestBuilder;
                {
                    this.val$requestBuilder = builder;
                }

                public void onConfigured(@NonNull CameraCaptureSession objectArray) {
                    if (this_.Camera2.this.mCameraDevice == null) {
                        return;
                    }
                    Object[] objectArray2 = objectArray;
                    CaptureRequest captureRequest = this_.val$requestBuilder.build();
                    6 v2 = this_;
                    6 v3 = v2;
                    6 this_ = v2.Camera2.this.mHiResCompleteListener;
                    try {
                        objectArray2.capture(captureRequest, (CameraCaptureSession.CaptureCallback)this_, v3.Camera2.this.mHandler);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = cameraAccessException;
                        Logger.e("Cannot access to camera while capturing!", objectArray);
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Logger.e("Failed to configure camera to take photo with cameraCaptureSession = " + cameraCaptureSession, new Object[0]);
                    Camera2.this.mCameraListenerSender.sendCameraOpenError(new RuntimeException("CameraCaptureSession.StateCallback.onConfigureFailed").fillInStackTrace());
                }
            };
            Camera2 camera27 = camera2.mHandler;
            cameraDevice.createCaptureSession(list, stateCallback2, (Handler)camera27);
            return;
        }
    }

    @Override
    public void stopPreviewAndCloseCamera() {
        this.closeCamera();
        this.cameraFacing = Facing.NONE;
    }

    @Override
    public void openCameraAndStartPreview(@NonNull Facing facing, float f, int n, boolean bl, boolean bl2) {
        this.currentZoom = Float.valueOf(f);
        this.cameraFacing = facing;
        this.screenOrientation = n;
        this.requireMirroring = bl;
        this.mFlashEnabled = bl2;
        this.openCamera(facing);
    }

    @Override
    public void setFlashEnabled(boolean bl) {
        block4: {
            block5: {
                CaptureRequest.Builder builder;
                camera22.mFlashEnabled = bl;
                if (camera22.cameraFacing != Facing.BACK) break block4;
                CameraCaptureSession cameraCaptureSession = camera22.mCaptureSession;
                if (cameraCaptureSession == null || (builder = camera22.mPreviewRequestBuilder) == null) break block5;
                CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
                Camera2 camera2 = camera22;
                Camera2 camera22 = builder.build();
                cameraCaptureSession = null;
                builder = camera2.mHandler;
                try {
                    cameraCaptureSession2.setRepeatingRequest((CaptureRequest)camera22, (CameraCaptureSession.CaptureCallback)cameraCaptureSession, (Handler)builder);
                }
                catch (CameraAccessException cameraAccessException) {
                    Logger.wtf(cameraAccessException);
                }
                break block4;
                break block4;
            }
            Camera2 camera2 = camera22;
            camera2.closeCamera();
            camera2.openCamera(camera2.cameraFacing);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyZoom(float f) {
        Camera2 camera2 = camera24;
        camera2.currentZoom = Float.valueOf(f);
        if (!camera2.cropRegion(camera2.mPreviewRequestBuilder, f)) return;
        CameraCaptureSession cameraCaptureSession = camera24.mCaptureSession;
        if (cameraCaptureSession == null) return;
        CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
        Camera2 camera22 = camera24;
        Camera2 camera23 = camera22;
        Camera2 camera24 = camera22.mPreviewRequestBuilder.build();
        cameraCaptureSession = null;
        Handler handler = camera23.mHandler;
        try {
            cameraCaptureSession2.setRepeatingRequest((CaptureRequest)camera24, (CameraCaptureSession.CaptureCallback)cameraCaptureSession, handler);
        }
        catch (CameraAccessException cameraAccessException) {
            Logger.wtf(cameraAccessException);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFaceOrient(int n) {
        Object object = this.mSyncObj;
        Camera2 camera2 = this;
        synchronized (object) {
            int n2 = camera2.screenOrientation;
            int n3 = this.sensorOrientation;
            int n4 = (n2 * 90 + n3 * 90) % 360;
            boolean bl = camera2.requireMirroring;
            n = camera2.getFaceOrientation(n4, n, bl);
            camera2.mOrientation = new FullImageData.Orientation(this.mOrientation.getCameraOrientation(), this.mOrientation.isRequireMirroring(), n);
            return;
        }
    }

    @Override
    public void setRequireMirroring(boolean bl) {
        Camera2 camera2 = this;
        camera2.requireMirroring = bl;
        camera2.mOrientation = new FullImageData.Orientation(this.mOrientation.getCameraOrientation(), bl, this.mOrientation.getFaceOrientation());
    }

    @Override
    public void setRecordDebugVideo(@Nullable DebugVideoCallbackListener object) {
        block23: {
            if (object == null && ((Camera2)object2).mWRListener != null) {
                object = ((Camera2)object2).mMuxer;
                if (object != null) {
                    ((MediaMuxerWrapper)object).stopRecording();
                    ((Camera2)object2).mRecordingInProgress = false;
                }
            } else {
                DebugVideoCallbackInfo debugVideoCallbackInfo;
                Object object2;
                if (((Camera2)object2).mWRListener == null) {
                    DebugVideoCallbackInfo debugVideoCallbackInfo2;
                    WindowSurface windowSurface;
                    long l;
                    IEncoderSync iEncoderSync;
                    int n;
                    String string;
                    RecordingListenerHandler recordingListenerHandler;
                    RenderHandler renderHandler;
                    Object object3;
                    Object object4;
                    block22: {
                        File file;
                        SimpleDateFormat simpleDateFormat;
                        Object object5;
                        ((Camera2)object2).mWRListener = new WeakReference<Object>(object);
                        if (((Camera2)object2).mEglCore == null) {
                            ImageRenderer imageRenderer;
                            OffscreenSurface offscreenSurface;
                            EglCore eglCore;
                            Object object6 = object2;
                            object4 = eglCore;
                            eglCore = new EglCore(null, 3);
                            ((Camera2)object6).mEglCore = object4;
                            object3 = offscreenSurface;
                            ((OffscreenSurface)object3)((EglCore)object4, 1, 1);
                            ((Camera2)object2).mOffscreenSurface = object3;
                            offscreenSurface.makeCurrent();
                            object4 = imageRenderer;
                            imageRenderer = new ImageRenderer();
                            ((Camera2)object6).mImageRenderer = object4;
                            GLES30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        try {
                            object5 = object2;
                        }
                        catch (Exception exception) {
                            if (object != null) {
                                DebugVideoCallbackInfo debugVideoCallbackInfo3;
                                object2 = debugVideoCallbackInfo3;
                                debugVideoCallbackInfo3 = new DebugVideoCallbackInfo(1, "Debug Video record in progress");
                                object.onDebugVideoDone((DebugVideoCallbackInfo)object2);
                            }
                            break block23;
                        }
                        object4 = simpleDateFormat;
                        simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss", Locale.ENGLISH);
                        object3 = file;
                        Object object7 = object2;
                        Object object8 = object7;
                        Object object9 = object7;
                        Object object10 = object3;
                        File file2 = ((Camera2)object2).mContext.getExternalFilesDir(null);
                        ((File)object10)(file2, ((DateFormat)object4).format(new Date()) + ".mp4");
                        object4 = RecordingParams.getVideoFormat(((Camera2)object8).mPreviewSize.getWidth(), ((Camera2)object2).mPreviewSize.getHeight());
                        renderHandler = null;
                        recordingListenerHandler = ((Camera2)object9).mRecordingListenerHandler;
                        string = file.getPath();
                        n = 0;
                        iEncoderSync = null;
                        l = ((Camera2)object5).mLastFrameTime;
                        if (l != 0L) break block22;
                        l = System.nanoTime();
                    }
                    Object object11 = object2;
                    Object object12 = object3;
                    Object object13 = object2;
                    Object object14 = object3;
                    Object object15 = object2;
                    float f = 1.0f;
                    int n2 = ((Camera2)object15).mPreviewSize.getWidth();
                    int n3 = ((Camera2)object15).mPreviewSize.getHeight();
                    ((MediaMuxerWrapper)object14)(renderHandler, recordingListenerHandler, string, n, iEncoderSync, l, f, n2, n3, (MediaFormat)object4, null);
                    ((MediaMuxerWrapper)object14).prepare();
                    WindowSurface windowSurface2 = windowSurface;
                    WindowSurface windowSurface3 = windowSurface;
                    Object object16 = object3;
                    object2 = ((Camera2)object2).mEglCore;
                    windowSurface2((EglCore)object2, ((MediaMuxerWrapper)object16).getInputSurface(), true);
                    ((Camera2)object13).mInputWindowSurface = windowSurface3;
                    ((MediaMuxerWrapper)object12).startRecording();
                    ((Camera2)object11).mMuxer = object12;
                    ((Camera2)object11).mRecordingInProgress = true;
                    if (object == null) break block23;
                    Object object17 = object;
                    object2 = debugVideoCallbackInfo2;
                    debugVideoCallbackInfo2 = new DebugVideoCallbackInfo(0, "Debug Video record started");
                    object17.onDebugVideoDone((DebugVideoCallbackInfo)object2);
                }
                object2 = debugVideoCallbackInfo;
                debugVideoCallbackInfo = new DebugVideoCallbackInfo(2, "Debug Video record already in progress");
                object.onDebugVideoDone((DebugVideoCallbackInfo)object2);
            }
        }
    }

    @Override
    public void release() {
        Object object = this.mMuxer;
        if (object != null) {
            ((MediaMuxerWrapper)object).stopRecording();
            this.mRecordingInProgress = false;
        }
        if ((object = this.mEglCore) != null) {
            ((EglCore)object).makeNothingCurrent();
            object = this.mOffscreenSurface;
            if (object != null) {
                ((OffscreenSurface)object).release();
            }
            Camera2 camera2 = this;
            camera2.mEglCore = null;
            camera2.mOffscreenSurface = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFpsMode(@NonNull CameraFpsMode cameraFpsMode) {
        camera24.mFpsMode = cameraFpsMode;
        if (camera24.mCaptureSession == null) return;
        CameraCharacteristics cameraCharacteristics = camera24.mCameraCharacteristics;
        if (cameraCharacteristics == null) return;
        Camera2 camera2 = camera24;
        camera2.setAETargetFpsRange(cameraCharacteristics, cameraFpsMode);
        CameraCaptureSession cameraCaptureSession = camera2.mCaptureSession;
        Camera2 camera22 = camera24;
        Camera2 camera23 = camera22;
        Camera2 camera24 = camera22.mPreviewRequestBuilder.build();
        cameraFpsMode = null;
        cameraCharacteristics = camera23.mHandler;
        try {
            cameraCaptureSession.setRepeatingRequest((CaptureRequest)camera24, (CameraCaptureSession.CaptureCallback)cameraFpsMode, (Handler)cameraCharacteristics);
        }
        catch (CameraAccessException cameraAccessException) {
            Logger.wtf(cameraAccessException);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenOrientation(int n) {
        Object object = this.mSyncObj;
        Camera2 camera2 = this;
        synchronized (object) {
            FullImageData.Orientation orientation;
            camera2.screenOrientation = n;
            FullImageData.Orientation orientation2 = orientation;
            FullImageData.Orientation orientation3 = orientation;
            Camera2 camera22 = this;
            Camera2 camera23 = camera22;
            Camera2 camera24 = camera22;
            n = camera22.sensorOrientation;
            orientation2(camera23.convertFromScreenOrientation(n, camera24.screenOrientation), this.mOrientation.isRequireMirroring(), 0);
            camera2.mOrientation = orientation3;
            return;
        }
    }

    private class Switch2YUVCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private Switch2YUVCaptureCallback() {
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureFailure captureFailure) {
            Switch2YUVCaptureCallback switch2YUVCaptureCallback = this;
            super.onCaptureFailed(cameraCaptureSession, captureRequest, captureFailure);
            if (switch2YUVCaptureCallback.Camera2.this.mPreviewFormat == 1) {
                Camera2.this.switchToYUV("2.CaptureSession.onCaptureFailed", true);
            }
        }
    }
}

