/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import java.util.Locale;

public class CameraFormatHelper {
    public static int getPreferablePreviewFormat(@NonNull Context context) {
        if (CameraFormatHelper.isBrand("samsung")) {
            return 35;
        }
        int n = PreferenceManager.getDefaultSharedPreferences((Context)context).getInt(CameraFormatHelper.getPreviewFormatKey(context), 1);
        if (n != 1 && n != 35) {
            n = 1;
        }
        return n;
    }

    public static void savePreferablePreviewFormat(@NonNull Context object, int n) {
        Context context = object;
        object = CameraFormatHelper.getPreviewFormatKey(context);
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        editor.putInt((String)object, n);
        editor.apply();
    }

    private static boolean isBrand(@NonNull String string) {
        String string2 = Build.MANUFACTURER;
        String string3 = Build.BRAND;
        boolean bl = string2 != null && string2.toLowerCase(Locale.ENGLISH).contains(string);
        boolean bl2 = string3 != null && string3.toLowerCase(Locale.ENGLISH).contains(string);
        return bl || bl2;
    }

    @NonNull
    private static String getPreviewFormatKey(@NonNull Context context) {
        return "CAMERA.FORMAT." + Long.toHexString(CameraFormatHelper.getVersionCode(context)) + "." + Long.toHexString(Build.VERSION.SDK_INT);
    }

    private static long getVersionCode(@NonNull Context context) {
        long l;
        block6: {
            block5: {
                l = 0L;
                try {
                    context = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {}
                if (Build.VERSION.SDK_INT < 28) break block5;
                l = context.getLongVersionCode();
                break block6;
            }
            l = context.versionCode;
        }
        return l;
    }

    @NonNull
    public static String decodePreviewFormat(int n) {
        if (n != 1) {
            if (n != 35) {
                return "UnknownFormat[" + n + "]";
            }
            return "ImageFormat.YUV_420_888";
        }
        return "PixelFormatType.RGBA_8888";
    }
}

