/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.camera;

import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.camera.CameraFpsMode;
import com.banuba.sdk.camera.Facing;
import com.banuba.sdk.entity.DebugVideoCallbackListener;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.camera.CameraThread;
import com.banuba.sdk.internal.utils.Logger;

public class CameraHandler
extends WeakHandler<CameraThread> {
    private static final int MSG_SHUTDOWN = 0;
    private static final int MSG_OPEN_CAMERA = 1;
    private static final int MSG_CLOSE_CAMERA = 2;
    private static final int MSG_INIT_SIZE = 3;
    private static final int MSG_SET_FACE_ORIENT = 4;
    private static final int MSG_CHANGE_ZOOM = 6;
    private static final int MSG_REQUEST_HIGH_RES_PHOTO = 7;
    private static final int MSG_SET_FPS_MODE = 8;
    private static final int MSG_SET_SCREEN_ORIENTATION = 9;
    private static final int MSG_SET_REQUIRE_MIRRORING = 10;
    private static final int MSG_RECORD_DEBUG_VIDEO = 11;

    public CameraHandler(CameraThread cameraThread) {
        super(cameraThread);
    }

    public void sendCloseCamera() {
        CameraHandler cameraHandler = this;
        ((CameraThread)cameraHandler.getThread()).setPushOn(false);
        cameraHandler.sendMessage(cameraHandler.obtainMessage(2));
    }

    public void sendInitCameraMatrix(int n, int n2) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessage(cameraHandler.obtainMessage(3, n, n2));
    }

    public void sendShutdown() {
        CameraHandler cameraHandler = this;
        ((CameraThread)cameraHandler.getThread()).setPushOn(false);
        cameraHandler.sendMessage(cameraHandler.obtainMessage(0));
    }

    public void sendChangeZoom(float f) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessage(cameraHandler.obtainMessage(6, Float.valueOf(f)));
    }

    public void sendOpenCamera(@NonNull Facing facing, float f, int n, boolean bl, boolean bl2) {
        CameraOpenArg cameraOpenArg;
        CameraThread cameraThread = (CameraThread)object.getThread();
        if (cameraThread != null) {
            cameraThread.setPushOn(true);
        }
        CameraHandler cameraHandler = object;
        Object object = cameraOpenArg;
        cameraOpenArg = new CameraOpenArg(facing, f, n, bl, bl2);
        cameraHandler.sendMessage(cameraHandler.obtainMessage(1, object));
    }

    public void sendRequestHighResPhoto() {
        CameraHandler cameraHandler = this;
        ((CameraThread)cameraHandler.getThread()).setPushOn(false);
        cameraHandler.sendMessage(cameraHandler.obtainMessage(7));
    }

    public void sendFaceOrient(int n) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessageAtFrontOfQueue(cameraHandler.obtainMessage(4, n, 0));
    }

    public void sendScreenOrientation(int n) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessageAtFrontOfQueue(cameraHandler.obtainMessage(9, n, 0));
    }

    public void sendFpsMode(@NonNull CameraFpsMode cameraFpsMode) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessage(cameraHandler.obtainMessage(8, (Object)cameraFpsMode));
    }

    public void sendRequireMirroring(boolean bl) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessage(cameraHandler.obtainMessage(10, bl ? 1 : 0, 0));
    }

    public void sendRecordDebugVideo(@Nullable DebugVideoCallbackListener debugVideoCallbackListener) {
        CameraHandler cameraHandler = this;
        cameraHandler.sendMessage(cameraHandler.obtainMessage(11, debugVideoCallbackListener));
    }

    public void handleMessage(Message object) {
        if ((object2 = (CameraThread)object2.getThread()) != null) {
            switch (object.what) {
                default: {
                    throw new RuntimeException("unknown message " + object.what);
                }
                case 11: {
                    ((CameraThread)object2).handleRecordDebugVideo((DebugVideoCallbackListener)object.obj);
                    break;
                }
                case 10: {
                    boolean bl = object.arg1 != 0;
                    ((CameraThread)object2).setRequireMirroring(bl);
                    break;
                }
                case 9: {
                    ((CameraThread)object2).setScreenOrientation(object.arg1);
                    break;
                }
                case 8: {
                    ((CameraThread)object2).setFpsMode((CameraFpsMode)((Object)object.obj));
                    break;
                }
                case 7: {
                    CameraHandler cameraHandler = object2;
                    ((CameraThread)((Object)cameraHandler)).setPushOn(true);
                    ((CameraThread)((Object)cameraHandler)).handleRequestHighResPhoto();
                    break;
                }
                case 6: {
                    ((CameraThread)object2).handleChangeZoom(((Float)object.obj).floatValue());
                    break;
                }
                case 4: {
                    ((CameraThread)object2).setFaceOrient(object.arg1);
                    break;
                }
                case 3: {
                    Message message = object;
                    int n = message.arg1;
                    ((CameraThread)object2).handleInitCameraMatrix(n, message.arg2);
                    break;
                }
                case 2: {
                    ((CameraThread)object2).handleReleaseCamera();
                    break;
                }
                case 1: {
                    CameraHandler cameraHandler = object2;
                    CameraOpenArg cameraOpenArg = (CameraOpenArg)object.obj;
                    Object object2 = cameraOpenArg.facing;
                    object = Float.valueOf(cameraOpenArg.zoomFactor);
                    int n = cameraOpenArg.screenOrientation;
                    boolean bl = cameraOpenArg.requireMirroring;
                    boolean bl2 = cameraOpenArg.enableFlashlight;
                    ((CameraThread)((Object)cameraHandler)).handleOpenCamera((Facing)((Object)object2), (Float)object, n, bl, bl2);
                    break;
                }
                case 0: {
                    ((BaseWorkThread)object2).shutdown();
                    break;
                }
            }
        } else {
            Logger.w("Empty camera thread", new Object[0]);
        }
    }

    private static class CameraOpenArg {
        @NonNull
        Facing facing;
        float zoomFactor;
        int screenOrientation;
        boolean requireMirroring;
        boolean enableFlashlight;

        CameraOpenArg(@NonNull Facing facing, float f, int n, boolean bl, boolean bl2) {
            this.facing = facing;
            this.zoomFactor = f;
            this.screenOrientation = n;
            this.requireMirroring = bl;
            this.enableFlashlight = bl2;
        }
    }
}

