/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.camera;

import android.content.Context;
import android.hardware.camera2.CameraManager;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.camera.CameraFpsMode;
import com.banuba.sdk.camera.Facing;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.entity.DebugVideoCallbackListener;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.camera.Camera2;
import com.banuba.sdk.internal.camera.CameraHandler;
import com.banuba.sdk.internal.camera.CameraListener;
import com.banuba.sdk.internal.camera.CameraListenerHandler;
import com.banuba.sdk.internal.camera.ICamera2;
import com.banuba.sdk.manager.IFpsController;

public class CameraThread
extends BaseWorkThread<CameraHandler> {
    private final Context mContext;
    private final EffectPlayer mEffectPlayer;
    private final CameraListener mCameraListener;
    @NonNull
    private final Size mPreferredPreviewSize;
    @Nullable
    private final IFpsController mFpsController;
    private ICamera2 mCameraAPI;

    public CameraThread(@NonNull Context context, @NonNull EffectPlayer effectPlayer, @NonNull CameraListener cameraListener, @NonNull Size size, @Nullable IFpsController iFpsController) {
        super("CameraThread");
        this.mContext = context;
        this.mEffectPlayer = effectPlayer;
        this.mCameraListener = cameraListener;
        this.mPreferredPreviewSize = size;
        this.mFpsController = iFpsController;
    }

    @Override
    @NonNull
    protected CameraHandler constructHandler() {
        return new CameraHandler(this);
    }

    @Override
    protected void preRunInit() {
        CameraListenerHandler cameraListenerHandler;
        CameraThread cameraThread = cameraThread3;
        CameraThread cameraThread2 = cameraThread3;
        EffectPlayer effectPlayer = cameraThread2.mEffectPlayer;
        CameraListenerHandler cameraListenerHandler2 = cameraListenerHandler;
        cameraListenerHandler = new CameraListenerHandler(cameraThread3.mCameraListener);
        CameraThread cameraThread3 = (CameraManager)cameraThread2.mContext.getSystemService("camera");
        Size size = cameraThread2.mPreferredPreviewSize;
        IFpsController iFpsController = cameraThread2.mFpsController;
        cameraThread.mCameraAPI = new Camera2(effectPlayer, cameraListenerHandler2, (CameraManager)cameraThread3, size, iFpsController);
    }

    @Override
    protected void postRunClear() {
        this.mCameraAPI.release();
    }

    public void handleReleaseCamera() {
        this.mCameraAPI.stopPreviewAndCloseCamera();
    }

    public void handleInitCameraMatrix(int n, int n2) {
    }

    public void handleRequestHighResPhoto() {
        this.mCameraAPI.requestHighResPhoto();
    }

    public void handleOpenCamera(Facing facing, Float f, int n, boolean bl, boolean bl2) {
        this.mCameraAPI.openCameraAndStartPreview(facing, f.floatValue(), n, bl, bl2);
    }

    public void handleChangeZoom(float f) {
        this.mCameraAPI.applyZoom(f);
    }

    public void setFaceOrient(int n) {
        this.mCameraAPI.setFaceOrient(n);
    }

    public void setScreenOrientation(int n) {
        this.mCameraAPI.setScreenOrientation(n);
    }

    public void setPushOn(boolean bl) {
        this.mCameraAPI.setPushOn(bl);
    }

    public void setFpsMode(@NonNull CameraFpsMode cameraFpsMode) {
        this.mCameraAPI.setFpsMode(cameraFpsMode);
    }

    public void setRequireMirroring(boolean bl) {
        this.mCameraAPI.setRequireMirroring(bl);
    }

    public void handleRecordDebugVideo(@Nullable DebugVideoCallbackListener debugVideoCallbackListener) {
        this.mCameraAPI.setRecordDebugVideo(debugVideoCallbackListener);
    }
}

