/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.internal.encoding.RecordingParams;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;

public final class AudioProcessor {
    static void processRecordsAudio(int n, @NonNull SparseArray<float[]> sparseArray, @NonNull SparseArray<ByteBuffer> sparseArray2) {
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = (ByteBuffer)sparseArray2.get(i);
            byteBuffer.rewind();
            Object object = byteBuffer.asCharBuffer();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.capacity() * 2).order(ByteOrder.nativeOrder());
            CharBuffer charBuffer = object;
            CharBuffer charBuffer2 = byteBuffer2.asCharBuffer();
            CharBuffer charBuffer3 = object;
            sparseArray2.put(i, (Object)byteBuffer2);
            object = (float[])sparseArray.get(i);
            charBuffer3.rewind();
            charBuffer2.rewind();
            AudioProcessor.processBuffer(charBuffer, charBuffer2, (float[])object);
            byteBuffer2.rewind();
        }
    }

    @Nullable
    static ByteBuffer processCommonAudio(@NonNull float[] fArray, @Nullable ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        ByteBuffer byteBuffer = buffer;
        byteBuffer.rewind();
        buffer = byteBuffer.asCharBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.capacity() * 2).order(ByteOrder.nativeOrder());
        CharBuffer charBuffer = byteBuffer2.asCharBuffer();
        ((CharBuffer)buffer).rewind();
        charBuffer.rewind();
        AudioProcessor.processBuffer((CharBuffer)buffer, charBuffer, fArray);
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    private static void processBuffer(@NonNull CharBuffer charBuffer, @NonNull CharBuffer charBuffer2, float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            char c;
            int n;
            int n2;
            float f;
            int n3 = i;
            int n4 = RecordingParams.getAudio1msBlockLength(n3);
            float f2 = fArray[n3];
            if (f < 0.9f) {
                n2 = Math.round(1.0f / f2);
                for (n = 0; n < n4; ++n) {
                    c = charBuffer.get();
                    for (int j = 0; j < n2; ++j) {
                        charBuffer2.put(c);
                    }
                }
                continue;
            }
            if (f2 > 1.1f) {
                n2 = Math.round(f2);
                for (n = 0; n < n4; ++n) {
                    c = charBuffer.get();
                    if (n % n2 != 0) continue;
                    charBuffer2.put(c);
                }
                continue;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                charBuffer2.put(charBuffer.get());
            }
        }
    }

    @NonNull
    public static byte[] processArrays(@NonNull byte[] object, float f) {
        if (f >= 0.95f && f <= 1.05f) {
            return object;
        }
        int n = ((byte[])object).length / RecordingParams.getAudioFormatBytes();
        double d = f;
        d = 1.0 / d;
        int n2 = (int)((double)((byte[])object).length * d);
        byte[] byArray = new byte[n2 - n2 % 2];
        object = ByteBuffer.wrap((byte[])object).order(ByteOrder.nativeOrder()).asShortBuffer();
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.nativeOrder()).asShortBuffer();
        if (f < 0.9f) {
            int n3 = Math.round(1.0f / f);
            for (int i = 0; i < n; ++i) {
                short s = ((ShortBuffer)object).get();
                for (int j = 0; j < n3; ++j) {
                    shortBuffer.put(s);
                }
            }
        } else if (f > 1.1f) {
            int n4 = Math.round(f);
            for (int i = 0; i < n; ++i) {
                short s = ((ShortBuffer)object).get();
                if (i % n4 != 0) continue;
                shortBuffer.put(s);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                shortBuffer.put(((ShortBuffer)object).get());
            }
        }
        return byArray;
    }

    @NonNull
    static ByteBuffer convertStereoToMono(@NonNull ByteBuffer byteBuffer, @NonNull ByteBuffer byteBuffer2) {
        CharBuffer charBuffer = byteBuffer.order(ByteOrder.nativeOrder()).asCharBuffer();
        CharBuffer charBuffer2 = byteBuffer2.order(ByteOrder.nativeOrder()).asCharBuffer();
        int n = charBuffer.remaining() / 2;
        for (int i = 0; i < n; ++i) {
            charBuffer2.put(charBuffer.get());
            charBuffer.get();
        }
        ByteBuffer byteBuffer3 = byteBuffer2;
        byteBuffer.rewind();
        byteBuffer3.rewind();
        return byteBuffer3;
    }
}

