/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.media.AudioRecord;
import android.os.Message;
import androidx.annotation.NonNull;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.encoding.AudioProcessor;
import com.banuba.sdk.internal.encoding.EncoderHandlerThreadAudio;
import com.banuba.sdk.internal.encoding.RecordingParams;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.internal.utils.TimeUtils;

public class AudioPullerHandlerThread
extends WeakHandler<AudioPullerThread> {
    private static final int MSG_AUDIO_OPEN = 1;
    private static final int MSG_AUDIO_CLOSE = 2;
    private static final int MSG_AUDIO_PAUSE = 3;
    private static final int MSG_AUDIO_UNPAUSE = 4;

    static AudioPullerHandlerThread startThread(@NonNull EncoderHandlerThreadAudio encoderHandlerThreadAudio, @NonNull AudioListener audioListener, long l, float f) {
        return (AudioPullerHandlerThread)((Object)new AudioPullerThread(encoderHandlerThreadAudio, audioListener, l, f).startAndGetHandler());
    }

    private AudioPullerHandlerThread(@NonNull AudioPullerThread audioPullerThread) {
        super(audioPullerThread);
    }

    void sendOpenAudio() {
        AudioPullerHandlerThread audioPullerHandlerThread = this;
        audioPullerHandlerThread.sendMessage(audioPullerHandlerThread.obtainMessage(1));
    }

    void sendPauseAudio() {
        AudioPullerHandlerThread audioPullerHandlerThread = this;
        audioPullerHandlerThread.sendMessage(audioPullerHandlerThread.obtainMessage(3));
    }

    void sendUnpauseAudio() {
        AudioPullerHandlerThread audioPullerHandlerThread = this;
        audioPullerHandlerThread.sendMessage(audioPullerHandlerThread.obtainMessage(4));
    }

    void sendCloseAudio() {
        AudioPullerHandlerThread audioPullerHandlerThread = this;
        audioPullerHandlerThread.sendMessage(audioPullerHandlerThread.obtainMessage(2));
    }

    public void handleMessage(Message message) {
        if ((this = (AudioPullerThread)((WeakHandler)((Object)this)).getThread()) != null) {
            switch (message.what) {
                default: {
                    throw new RuntimeException("Unknown message " + message.what);
                }
                case 4: {
                    ((AudioPullerThread)this).pauseAudio(false);
                    break;
                }
                case 3: {
                    ((AudioPullerThread)this).pauseAudio(true);
                    break;
                }
                case 2: {
                    Object object = this;
                    ((AudioPullerThread)object).closeAudio();
                    ((BaseWorkThread)object).shutdown();
                    break;
                }
                case 1: {
                    ((AudioPullerThread)this).openAudio();
                }
            }
        }
    }

    static class AudioPullerThread
    extends BaseWorkThread<AudioPullerHandlerThread> {
        private static final int TIMER_INTERVAL_MS = 120;
        private static final int SAMPLE_RATE = RecordingParams.getAudioSampleRate();
        private static final int CHANNEL_CONFIG = RecordingParams.getChannelConfig();
        private static final int CHANNELS_COUNT = RecordingParams.getChannelCount();
        private static final int AUDIO_FORMAT = RecordingParams.getAudioFormatEncoding();
        private static final int SAMPLES_SIZE = RecordingParams.getAudioFormatBytes();
        private static final int AUDIO_SOURCE = 1;
        private final EncoderHandlerThreadAudio mAudioEncoderHandler;
        private final AudioListener mAudioListener;
        private long mTime;
        private final float mSpeed;
        private final double mRecordSpeedK;
        private AudioRecord mAudioRecorder;

        AudioPullerThread(@NonNull EncoderHandlerThreadAudio encoderHandlerThreadAudio, @NonNull AudioListener audioListener, long l, float f) {
            super("AudioPullerThread");
            this.mAudioEncoderHandler = encoderHandlerThreadAudio;
            this.mTime = l;
            this.mSpeed = f;
            double d = f;
            this.mRecordSpeedK = 1.0 / d;
            this.mAudioListener = audioListener;
        }

        static /* synthetic */ long access$214(AudioPullerThread audioPullerThread, long l) {
            audioPullerThread.mTime = l = audioPullerThread.mTime + l;
            return l;
        }

        @Override
        @NonNull
        protected AudioPullerHandlerThread constructHandler() {
            return new AudioPullerHandlerThread(this);
        }

        void openAudio() {
            AudioRecord audioRecord;
            int n = SAMPLE_RATE;
            int n2 = n * 120 / 1000;
            int n3 = SAMPLES_SIZE;
            int n4 = CHANNELS_COUNT;
            int n5 = n2 * 2 * n3 * n4;
            int n6 = CHANNEL_CONFIG;
            int n7 = AUDIO_FORMAT;
            int n8 = AudioRecord.getMinBufferSize((int)n, (int)n6, (int)n7);
            if (n5 < n8) {
                n2 = n8 / (n3 * 2 * n4);
                n5 = n8;
            }
            AudioRecord audioRecord2 = audioRecord;
            ((AudioPullerThread)object).mAudioRecorder = new AudioRecord(1, n, n6, n7, n5);
            if (audioRecord2.getState() == 1) {
                AudioPullerThread audioPullerThread = object;
                n = n2 * n3 * n4;
                AudioPullerThread audioPullerThread2 = object;
                audioPullerThread2.mAudioRecorder.setRecordPositionUpdateListener(new AudioRecord.OnRecordPositionUpdateListener(){
                    private boolean mFirstFrame = true;
                    final /* synthetic */ int val$bufSize;
                    final /* synthetic */ AudioPullerThread this$0;
                    {
                        this.this$0 = audioPullerThread;
                        this.val$bufSize = n;
                    }

                    public void onMarkerReached(AudioRecord audioRecord) {
                    }

                    public void onPeriodicNotification(AudioRecord audioRecord) {
                        1 v0 = this;
                        int n = v0.val$bufSize;
                        byte[] byArray = new byte[n];
                        n = v0.this$0.mAudioRecorder.read(byArray, 0, n);
                        if (v0.mFirstFrame) {
                            1 v1 = this;
                            v1.mFirstFrame = false;
                            long l = System.nanoTime() - this.this$0.mTime;
                            AudioPullerThread audioPullerThread = v1.this$0;
                            AudioPullerThread.access$214(audioPullerThread, Math.round((double)l * audioPullerThread.mRecordSpeedK));
                            v1.this$0.mAudioListener.onAudioStarted(this.this$0.mTime);
                        }
                        if (n < this.val$bufSize) {
                            byte[] byArray2 = byArray;
                            byArray = new byte[n];
                            System.arraycopy(byArray2, 0, byArray, 0, n);
                        }
                        byte[] byArray3 = AudioProcessor.processArrays(byArray, this.this$0.mSpeed);
                        this.this$0.mAudioEncoderHandler.sendAudioData(byArray3, this.this$0.mTime);
                        long l = Math.round((double)TimeUtils.audioBufferPosition2TimeNanoSec(n) * this.this$0.mRecordSpeedK);
                        AudioPullerThread.access$214(this.this$0, l);
                    }
                });
                audioPullerThread2.mAudioRecorder.setPositionNotificationPeriod(n2);
                audioPullerThread2.mAudioRecorder.startRecording();
                Object object = new byte[n];
                audioPullerThread.mAudioRecorder.read((byte[])object, 0, n);
                return;
            }
            throw new RuntimeException("AudioRecord Initialization failed: " + ((AudioPullerThread)object).mAudioRecorder.getState());
        }

        void pauseAudio(boolean bl) {
            if (bl) {
                this.mAudioRecorder.stop();
                return;
            }
            this.mAudioRecorder.startRecording();
        }

        void closeAudio() {
            Logger.w("closeAudio", new Object[0]);
            AudioRecord audioRecord = this.mAudioRecorder;
            if (audioRecord != null) {
                AudioRecord audioRecord2 = audioRecord;
                audioRecord2.setRecordPositionUpdateListener(null);
                audioRecord2.stop();
                audioRecord2.release();
            }
            this.mAudioListener.onAudioStopped();
        }
    }

    static interface AudioListener {
        public void onAudioStopped();

        public void onAudioStarted(long var1);
    }
}

