/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.os.Message;
import androidx.annotation.NonNull;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.encoding.IAudioDataSender;
import com.banuba.sdk.internal.encoding.MediaEncoderAudio;
import com.banuba.sdk.internal.utils.TypeUtils;

public class EncoderHandlerThreadAudio
extends WeakHandler<EncoderThreadAudio>
implements IAudioDataSender {
    private static final int MSG_SEND_AUDIO = 1;
    private static final int MSG_SEND_STOP = 2;

    static EncoderHandlerThreadAudio startThread(MediaEncoderAudio mediaEncoderAudio, EncoderListener encoderListener) {
        return (EncoderHandlerThreadAudio)new EncoderThreadAudio(mediaEncoderAudio, encoderListener).startAndGetHandler();
    }

    private EncoderHandlerThreadAudio(EncoderThreadAudio encoderThreadAudio) {
        super(encoderThreadAudio);
    }

    @Override
    public void sendAudioData(@NonNull byte[] byArray, long l) {
        EncoderHandlerThreadAudio encoderHandlerThreadAudio = this;
        long l2 = l;
        int n = TypeUtils.getLongHighBits(l2);
        int n2 = TypeUtils.getLongLowBits(l2);
        encoderHandlerThreadAudio.sendMessage(encoderHandlerThreadAudio.obtainMessage(1, n, n2, byArray));
    }

    void sendStopRecording() {
        EncoderHandlerThreadAudio encoderHandlerThreadAudio = this;
        encoderHandlerThreadAudio.sendMessage(encoderHandlerThreadAudio.obtainMessage(2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Message message) {
        if ((this = (EncoderThreadAudio)((WeakHandler)((Object)this)).getThread()) == null) return;
        int n = message.what;
        if (n != 1) {
            if (n != 2) throw new RuntimeException("Unhandled msg what=" + message.what);
            ((EncoderThreadAudio)this).handleStop();
            return;
        } else {
            ((EncoderThreadAudio)this).handleProcessAudio((byte[])message.obj, TypeUtils.getLongFromInts(message.arg1, message.arg2));
        }
    }

    static class EncoderThreadAudio
    extends BaseWorkThread<EncoderHandlerThreadAudio> {
        private final MediaEncoderAudio mAudioEncoder;
        private final EncoderListener mListener;

        EncoderThreadAudio(MediaEncoderAudio mediaEncoderAudio, EncoderListener encoderListener) {
            super("EncoderThreadAudio");
            this.mAudioEncoder = mediaEncoderAudio;
            this.mListener = encoderListener;
        }

        @Override
        @NonNull
        protected EncoderHandlerThreadAudio constructHandler() {
            return new EncoderHandlerThreadAudio(this);
        }

        void handleProcessAudio(byte[] byArray, long l) {
            this.mAudioEncoder.processBuffer(byArray, l);
        }

        void handleStop() {
            EncoderThreadAudio encoderThreadAudio = this;
            encoderThreadAudio.mAudioEncoder.stopEncoding();
            EncoderListener encoderListener = encoderThreadAudio.mListener;
            if (encoderListener != null) {
                encoderListener.onAudioEncodingFinished();
            }
            this.shutdown();
        }
    }

    static interface EncoderListener {
        public void onAudioEncodingFinished();
    }
}

