/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.os.Message;
import androidx.annotation.NonNull;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.encoding.MediaEncoderVideo;

class EncoderHandlerThreadVideo
extends WeakHandler<EncoderThreadVideo> {
    private static final int MSG_FRAME_AVAILABLE = 1;
    private static final int MSG_STOP_RECORDING = 2;

    static EncoderHandlerThreadVideo startThread(MediaEncoderVideo mediaEncoderVideo, EncoderListener encoderListener) {
        return (EncoderHandlerThreadVideo)((Object)new EncoderThreadVideo(mediaEncoderVideo, encoderListener).startAndGetHandler());
    }

    private EncoderHandlerThreadVideo(EncoderThreadVideo encoderThreadVideo) {
        super(encoderThreadVideo);
    }

    void stopRecording() {
        EncoderHandlerThreadVideo encoderHandlerThreadVideo = this;
        encoderHandlerThreadVideo.sendMessage(encoderHandlerThreadVideo.obtainMessage(2));
    }

    void frameAvailableSoon() {
        EncoderHandlerThreadVideo encoderHandlerThreadVideo = this;
        encoderHandlerThreadVideo.sendMessage(encoderHandlerThreadVideo.obtainMessage(1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Message message) {
        if ((this = (EncoderThreadVideo)((WeakHandler)((Object)this)).getThread()) == null) return;
        int n = message.what;
        if (n != 1) {
            if (n != 2) throw new RuntimeException("Unhandled msg what=" + message.what);
            Object object = this;
            ((EncoderThreadVideo)object).handleStopRecording();
            ((BaseWorkThread)object).shutdown();
            return;
        } else {
            ((EncoderThreadVideo)this).handleFrameAvailable();
        }
    }

    static class EncoderThreadVideo
    extends BaseWorkThread<EncoderHandlerThreadVideo> {
        private final MediaEncoderVideo mVideoEncoder;
        private final EncoderListener mListener;

        EncoderThreadVideo(MediaEncoderVideo mediaEncoderVideo, EncoderListener encoderListener) {
            super("EncoderThreadVideo");
            this.mVideoEncoder = mediaEncoderVideo;
            this.mListener = encoderListener;
        }

        @Override
        @NonNull
        protected EncoderHandlerThreadVideo constructHandler() {
            return new EncoderHandlerThreadVideo(this);
        }

        void handleStopRecording() {
            EncoderThreadVideo encoderThreadVideo = encoderListener;
            encoderThreadVideo.mVideoEncoder.drainEncoder(true);
            encoderThreadVideo.mVideoEncoder.close();
            long l = encoderThreadVideo.mVideoEncoder.getDuration();
            EncoderListener encoderListener = encoderThreadVideo.mListener;
            if (encoderListener != null) {
                encoderListener.onVideoEncodingFinished(l);
            }
        }

        void handleFrameAvailable() {
            this.mVideoEncoder.drainEncoder(false);
        }
    }

    public static interface EncoderListener {
        public void onVideoEncodingFinished(long var1);
    }
}

