/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.internal.Constants;
import com.banuba.sdk.internal.encoding.MediaEncoderBase;
import com.banuba.sdk.internal.encoding.MediaMuxerWrapper;
import com.banuba.sdk.internal.encoding.RecordingParams;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.internal.utils.TimeUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

class MediaEncoderAudio
extends MediaEncoderBase {
    private boolean mEosReceived;
    private boolean mEosSentToAudioEncoder;
    private long mCalculatedNextTime;

    MediaEncoderAudio(@NonNull MediaMuxerWrapper mediaMuxerWrapper, @Nullable MediaFormat mediaFormat, @Nullable IEncoderSync iEncoderSync, int n, int n2) {
        super(mediaMuxerWrapper, mediaFormat, iEncoderSync, n, n2);
    }

    private void closeEncoder() {
        MediaEncoderAudio mediaEncoderAudio = this;
        mediaEncoderAudio.drainEncoder(true);
        mediaEncoderAudio.close();
    }

    @Override
    protected boolean isVideoEncoder() {
        return false;
    }

    @Override
    protected boolean isAudioEncoder() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processBuffer(@NonNull byte[] byArray, long l) {
        block9: {
            byte[] byArray2;
            byte[] byArray3;
            ByteBuffer byteBuffer;
            IEncoderSync iEncoderSync;
            ByteBuffer byteBuffer2;
            int n;
            long l2;
            if (((MediaEncoderAudio)((Object)iEncoderSync)).mEosSentToAudioEncoder) {
                return;
            }
            ((MediaEncoderBase)((Object)iEncoderSync)).drainEncoder(false);
            try {
                l2 = l / Constants.NANO_TO_MICRO_L_DIVIDER;
                n = ((MediaEncoderBase)((Object)iEncoderSync)).mEncoder.dequeueInputBuffer(10000L);
                if (n < 0) break block9;
            }
            catch (Throwable throwable) {
                Logger.wtf(throwable.getMessage(), new Object[0]);
                break block9;
            }
            {
                byteBuffer2 = ((MediaEncoderBase)((Object)iEncoderSync)).mEncoder.getInputBuffer(n);
                if (byteBuffer2 == null) break block9;
            }
            {
                iEncoderSync = iEncoderSync;
                byteBuffer = byteBuffer2;
                byArray3 = byArray;
                byArray2 = byArray;
                byteBuffer2.clear();
            }
            int n2 = 0;
            {
                byteBuffer.put(byArray2, n2, Math.min(byArray3.length, byteBuffer2.capacity()));
            }
            {
                if (((MediaEncoderAudio)((Object)iEncoderSync)).mEosReceived) {
                    Object object = iEncoderSync;
                    int n3 = n;
                    n = 0;
                    ((MediaEncoderBase)object).mEncoder.queueInputBuffer(n3, n, byArray.length, l2, 4);
                    ((MediaEncoderAudio)object).mEosSentToAudioEncoder = true;
                    super.closeEncoder();
                    break block9;
                }
                int n4 = n;
                n = 0;
                ((MediaEncoderBase)((Object)iEncoderSync)).mEncoder.queueInputBuffer(n4, n, byArray.length, l2, 0);
            }
        }
        ((MediaEncoderAudio)((Object)iEncoderSync)).mCalculatedNextTime = l + TimeUtils.audioBufferPosition2TimeNanoSec(byArray.length);
        IEncoderSync iEncoderSync = ((MediaEncoderBase)((Object)iEncoderSync)).mEncoderSync;
        if (iEncoderSync != null) {
            iEncoderSync.setAudioEncoded();
        }
    }

    @Override
    public void prepare() {
        try {
            this.mEncoder = MediaCodec.createEncoderByType((String)RecordingParams.getAudioMIME());
        }
        catch (IOException iOException) {
            Logger.wtf(iOException.getMessage(), new Object[0]);
        }
        MediaFormat mediaFormat = this.mMediaFormat;
        if (mediaFormat == null) {
            mediaFormat = RecordingParams.getAudioFormat();
        }
        MediaEncoderAudio mediaEncoderAudio = this;
        mediaEncoderAudio.mEncoder.configure(mediaFormat, null, null, 1);
        mediaEncoderAudio.mEncoder.start();
    }

    void stopEncoding() {
        MediaEncoderAudio mediaEncoderAudio = object;
        mediaEncoderAudio.mEosReceived = true;
        Object object = new byte[RecordingParams.getAudioFormatBytes()];
        long l = mediaEncoderAudio.mCalculatedNextTime;
        mediaEncoderAudio.processBuffer((byte[])object, l);
    }
}

