/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.internal.encoding.MediaMuxerWrapper;
import com.banuba.sdk.internal.utils.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

abstract class MediaEncoderBase
implements AutoCloseable {
    private static final String TAG = "MediaEncoderBase";
    protected final MediaFormat mMediaFormat;
    private final MediaMuxerWrapper mMuxerWrapper;
    private final MediaCodec.BufferInfo mBufferInfo;
    protected final IEncoderSync mEncoderSync;
    protected int width;
    protected int height;
    private int mTrackIndex = -1;
    private boolean mMuxerStarted;
    protected MediaCodec mEncoder;
    private long mStartTime;
    private long mEndTime;
    private boolean mFirstFrame = true;

    MediaEncoderBase(@NonNull MediaMuxerWrapper mediaMuxerWrapper, @Nullable MediaFormat mediaFormat, @Nullable IEncoderSync iEncoderSync, int n, int n2) {
        MediaCodec.BufferInfo bufferInfo;
        mediaEncoderBase.mMuxerWrapper = mediaMuxerWrapper;
        mediaEncoderBase.mMediaFormat = mediaFormat;
        mediaEncoderBase.mEncoderSync = iEncoderSync;
        mediaEncoderBase.width = n;
        mediaEncoderBase.height = n2;
        MediaEncoderBase mediaEncoderBase = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        v1.mBufferInfo = mediaEncoderBase;
    }

    @NonNull
    private String decodeStatus(int n) {
        switch (n) {
            default: {
                return "MediaCodec.UNKNOWN_CODE[" + n + "]";
            }
            case -1: {
                return "MediaCodec.INFO_TRY_AGAIN_LATER";
            }
            case -2: {
                return "MediaCodec.INFO_OUTPUT_FORMAT_CHANGED";
            }
            case -3: 
        }
        return "MediaCodec.INFO_OUTPUT_BUFFERS_CHANGED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CallSuper
    void drainEncoder(boolean bl) {
        if (bl && this.isVideoEncoder()) {
            try {
                this.mEncoder.signalEndOfInputStream();
            }
            catch (IllegalStateException illegalStateException) {
                Log.w((String)TAG, (Throwable)illegalStateException);
                return;
            }
        }
        while (true) {
            long l;
            long l2;
            int n = -1;
            try {
                n = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)TAG, (String)"Failed to dequeueOutputBuffer", (Throwable)illegalStateException);
            }
            if (n == -1) {
                if (bl) continue;
                return;
            }
            if (n == -2) {
                IEncoderSync iEncoderSync;
                if (this.mMuxerStarted) throw new RuntimeException("format changed twice");
                this.mTrackIndex = this.mMuxerWrapper.addTrack(this.mEncoder.getOutputFormat(), this.isAudioEncoder());
                if (!this.mMuxerWrapper.start()) {
                    MediaMuxerWrapper mediaMuxerWrapper = this.mMuxerWrapper;
                    synchronized (mediaMuxerWrapper) {
                        while (!this.mMuxerWrapper.isStarted()) {
                            try {
                                this.mMuxerWrapper.wait(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                Logger.wtf(interruptedException.getMessage(), new Object[0]);
                            }
                        }
                    }
                }
                if ((iEncoderSync = this.mEncoderSync) != null) {
                    iEncoderSync.setEncoderReady();
                }
                this.mMuxerStarted = true;
                continue;
            }
            if (n < 0) continue;
            if (this.mFirstFrame && (l2 = this.mBufferInfo.presentationTimeUs) > 0L) {
                this.mFirstFrame = false;
                this.mStartTime = l2;
            }
            this.mEndTime = l = Math.max(this.mEndTime, this.mBufferInfo.presentationTimeUs);
            ByteBuffer byteBuffer = this.mEncoder.getOutputBuffer(n);
            if (byteBuffer == null) throw new RuntimeException("encoderOutputBuffer " + n + " was null");
            MediaCodec.BufferInfo bufferInfo = this.mBufferInfo;
            if ((bufferInfo.flags & 2) != 0) {
                bufferInfo.size = 0;
            }
            if (bufferInfo.size != 0) {
                if (!this.mMuxerStarted) throw new RuntimeException("muxer hasn't started");
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(bufferInfo.offset);
                bufferInfo = this.mBufferInfo;
                byteBuffer2.limit(bufferInfo.offset + bufferInfo.size);
                this.mMuxerWrapper.writeSampleData(this.mTrackIndex, byteBuffer, this.mBufferInfo);
            }
            this.mEncoder.releaseOutputBuffer(n, false);
            if ((this.mBufferInfo.flags & 4) != 0) break;
        }
    }

    @Override
    public void close() {
        MediaCodec mediaCodec = this.mEncoder;
        if (mediaCodec != null) {
            MediaCodec mediaCodec2 = mediaCodec;
            mediaCodec2.stop();
            mediaCodec2.release();
            this.mEncoder = null;
        }
        if (this.mMuxerStarted) {
            try {
                this.mMuxerWrapper.stop();
            }
            catch (Exception exception) {
                Logger.wtf(exception);
            }
        }
    }

    public abstract void prepare();

    protected abstract boolean isVideoEncoder();

    protected abstract boolean isAudioEncoder();

    long getDuration() {
        return Math.round((double)(this.mEndTime - this.mStartTime + TimeUnit.SECONDS.toMicros(1L) / 30L) / 1000.0);
    }
}

