/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.internal.encoding.MediaEncoderBase;
import com.banuba.sdk.internal.encoding.MediaMuxerWrapper;
import com.banuba.sdk.internal.encoding.RecordingParams;
import com.banuba.sdk.internal.utils.Logger;
import java.io.IOException;

class MediaEncoderVideo
extends MediaEncoderBase {
    private Surface mInputSurface;

    MediaEncoderVideo(@NonNull MediaMuxerWrapper mediaMuxerWrapper, @Nullable MediaFormat mediaFormat, @Nullable IEncoderSync iEncoderSync, int n, int n2) {
        super(mediaMuxerWrapper, mediaFormat, iEncoderSync, n, n2);
    }

    @Override
    protected boolean isVideoEncoder() {
        return true;
    }

    @Override
    protected boolean isAudioEncoder() {
        return false;
    }

    @Override
    public void prepare() {
        try {
            this.mEncoder = MediaCodec.createEncoderByType((String)RecordingParams.getVideoMIME());
        }
        catch (IOException iOException) {
            Logger.e(iOException.getMessage(), new Object[0]);
        }
        MediaFormat mediaFormat = this.mMediaFormat;
        if (mediaFormat == null) {
            mediaFormat = RecordingParams.getVideoFormat(this.width, this.height);
        }
        MediaEncoderVideo mediaEncoderVideo = this;
        mediaEncoderVideo.mEncoder.configure(mediaFormat, null, null, 1);
        mediaEncoderVideo.mInputSurface = mediaEncoderVideo.mEncoder.createInputSurface();
        mediaEncoderVideo.mEncoder.start();
    }

    @Override
    void drainEncoder(boolean bl) {
        MediaEncoderVideo mediaEncoderVideo = iEncoderSync;
        super.drainEncoder(bl);
        IEncoderSync iEncoderSync = mediaEncoderVideo.mEncoderSync;
        if (iEncoderSync != null) {
            iEncoderSync.setVideoEncoded();
        }
    }

    Surface getInputSurface() {
        return this.mInputSurface;
    }

    @Override
    public void close() {
        Surface surface = this.mInputSurface;
        if (surface != null) {
            surface.release();
        }
        super.close();
    }
}

