/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.entity.RecordedVideoInfo;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.encoding.AudioPullerHandlerThread;
import com.banuba.sdk.internal.encoding.EncoderHandlerThreadAudio;
import com.banuba.sdk.internal.encoding.EncoderHandlerThreadVideo;
import com.banuba.sdk.internal.encoding.IAudioDataSender;
import com.banuba.sdk.internal.encoding.MediaEncoderAudio;
import com.banuba.sdk.internal.encoding.MediaEncoderBase;
import com.banuba.sdk.internal.encoding.MediaEncoderVideo;
import com.banuba.sdk.internal.encoding.RecordingListenerHandler;
import com.banuba.sdk.internal.renderer.RenderHandler;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.internal.utils.MovieDataExtractor;
import java.io.File;
import java.nio.ByteBuffer;

public class MediaMuxerWrapper
implements EncoderHandlerThreadAudio.EncoderListener,
EncoderHandlerThreadVideo.EncoderListener,
AudioPullerHandlerThread.AudioListener {
    public static final int RECORD_NO_AUDIO = 0;
    public static final int RECORD_MIC_AUDIO = 1;
    public static final int RECORD_BUFFER_AUDIO = 2;
    public static final int RECORD_EXTERNAL_AUDIO_CODEC = 3;
    protected final MediaMuxer mMediaMuxer;
    private final RenderHandler mRenderThreadHandler;
    private final RecordingListenerHandler mRecordingListenerHandler;
    private final File mOutputFile;
    private final boolean mRecordAudio;
    private final int mRecordAudioType;
    private final long mTimeBase;
    private final float mSpeed;
    private final MediaFormat mFormatAudio;
    private final MediaEncoderVideo mVideoEncoder;
    private final MediaEncoderAudio mAudioEncoder;
    private final int mEncoderCount;
    protected int mStartedCount;
    protected int mExternalAudioTrackIndex = -1;
    private int mAudioTrackIndex = -1;
    protected long mAudioPresentationTimeUsLast;
    private boolean mMuxerStarted;
    private boolean mPaused = false;
    private EncoderHandlerThreadVideo mVideoEncoderHandler;
    private EncoderHandlerThreadAudio mAudioEncoderHandler;
    private AudioPullerHandlerThread mAudioPullerHandler;
    private boolean mVideoFinished;
    private boolean mAudioFinished;
    private boolean mAudioPullerFinished;
    int width;
    int height;
    private volatile long mVideoDuration;
    private long audioStartTimeNano = -1L;

    public MediaMuxerWrapper(@Nullable RenderHandler renderHandler, @Nullable RecordingListenerHandler recordingListenerHandler, @NonNull String string, int n, @Nullable IEncoderSync iEncoderSync, long l, float f, int n2, int n3) {
        this(renderHandler, recordingListenerHandler, string, n, iEncoderSync, l, f, n2, n3, null, null);
    }

    public MediaMuxerWrapper(@Nullable RenderHandler object, @Nullable RecordingListenerHandler recordingListenerHandler, @NonNull String string, int n, @Nullable IEncoderSync iEncoderSync, long l, float f, int n2, int n3, @Nullable MediaFormat mediaFormat, @Nullable MediaFormat mediaFormat2) {
        MediaEncoderVideo mediaEncoderVideo;
        MediaMuxer mediaMuxer;
        File file;
        this.mRecordAudioType = n;
        n = n != 1 && n != 2 ? 0 : 1;
        this.mRecordAudio = n;
        this.mRenderThreadHandler = object;
        this.mRecordingListenerHandler = recordingListenerHandler;
        this.mTimeBase = l;
        this.mSpeed = f;
        this.width = n2;
        this.height = n3;
        object = file;
        try {
            file = new File(string);
            this.mOutputFile = object;
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("This app has no permission of writing external storage");
        }
        recordingListenerHandler = mediaMuxer;
        mediaMuxer = new MediaMuxer(((File)object).getAbsolutePath(), 0);
        this.mMediaMuxer = recordingListenerHandler;
        this.mFormatAudio = mediaFormat2;
        object = mediaEncoderVideo;
        int n4 = this.width;
        int n5 = this.height;
        mediaEncoderVideo = new MediaEncoderVideo(this, mediaFormat, iEncoderSync, n4, n5);
        this.mVideoEncoder = object;
        if (n != 0) {
            MediaEncoderAudio mediaEncoderAudio;
            object = mediaEncoderAudio;
            n4 = this.width;
            n5 = this.height;
            mediaEncoderAudio = new MediaEncoderAudio(this, mediaFormat2, iEncoderSync, n4, n5);
        } else {
            object = null;
        }
        this.mAudioEncoder = object;
        int n6 = n != 0 ? 2 : 1;
        this.mEncoderCount = n6;
    }

    private String getOutputFileName() {
        return this.mOutputFile.getName();
    }

    private synchronized void checkAllFinished() {
        boolean bl = ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mRecordAudio ? ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mVideoFinished && ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mAudioFinished && ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mAudioPullerFinished : ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mVideoFinished;
        if (bl) {
            MediaMuxerWrapper mediaMuxerWrapper = recordingListenerHandler;
            long l = MovieDataExtractor.extractDuration(mediaMuxerWrapper.mOutputFile.getAbsolutePath(), ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mVideoDuration);
            Object object = mediaMuxerWrapper.mRenderThreadHandler;
            if (object != null) {
                ((RenderHandler)object).sendRecordingCompleted(((MediaMuxerWrapper)((Object)recordingListenerHandler)).mOutputFile);
            }
            if (l > 0L) {
                RecordedVideoInfo recordedVideoInfo;
                object = recordedVideoInfo;
                recordedVideoInfo = new RecordedVideoInfo(l, ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mOutputFile.getAbsolutePath());
            } else {
                RecordedVideoInfo recordedVideoInfo;
                object = recordedVideoInfo;
                String string = ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mOutputFile.getAbsolutePath();
                recordedVideoInfo = new RecordedVideoInfo(0L, string);
            }
            Logger.i(((RecordedVideoInfo)object).toString(), new Object[0]);
            RecordingListenerHandler recordingListenerHandler = ((MediaMuxerWrapper)((Object)recordingListenerHandler)).mRecordingListenerHandler;
            if (recordingListenerHandler != null) {
                recordingListenerHandler.sendRecordingCompleted((RecordedVideoInfo)object);
            }
        }
    }

    @Nullable
    public IAudioDataSender getAudioSender() {
        return this.mAudioEncoderHandler;
    }

    public synchronized void setPause(boolean bl) {
        this.mPaused = bl;
        if (this.mRecordAudioType == 1) {
            if (bl) {
                this.mAudioPullerHandler.sendPauseAudio();
                return;
            }
            this.mAudioPullerHandler.sendUnpauseAudio();
        }
    }

    public synchronized void prepare() {
        MediaEncoderBase mediaEncoderBase = this.mVideoEncoder;
        if (mediaEncoderBase != null) {
            ((MediaEncoderVideo)mediaEncoderBase).prepare();
        }
        if ((mediaEncoderBase = this.mAudioEncoder) != null) {
            ((MediaEncoderAudio)mediaEncoderBase).prepare();
        }
        this.mPaused = false;
    }

    public synchronized void startRecording() {
        MediaMuxerWrapper mediaMuxerWrapper = this;
        mediaMuxerWrapper.mVideoEncoderHandler = EncoderHandlerThreadVideo.startThread(mediaMuxerWrapper.mVideoEncoder, this);
        if (mediaMuxerWrapper.mRecordAudio) {
            EncoderHandlerThreadAudio encoderHandlerThreadAudio;
            MediaMuxerWrapper mediaMuxerWrapper2 = this;
            mediaMuxerWrapper2.mAudioEncoderHandler = encoderHandlerThreadAudio = EncoderHandlerThreadAudio.startThread(mediaMuxerWrapper2.mAudioEncoder, this);
            if (mediaMuxerWrapper2.mRecordAudioType == 1) {
                MediaMuxerWrapper mediaMuxerWrapper3 = this;
                long l = mediaMuxerWrapper3.mTimeBase;
                float f = mediaMuxerWrapper3.mSpeed;
                this.mAudioPullerHandler = AudioPullerHandlerThread.startThread(encoderHandlerThreadAudio, this, l, f);
                this.mAudioPullerHandler.sendOpenAudio();
            }
        }
    }

    public synchronized void stopRecording() {
        Logger.d("stopRecording", new Object[0]);
        WeakHandler weakHandler = ((MediaMuxerWrapper)((Object)encoderHandlerThreadAudio)).mVideoEncoderHandler;
        if (weakHandler != null) {
            ((EncoderHandlerThreadVideo)weakHandler).stopRecording();
        }
        if (((MediaMuxerWrapper)((Object)encoderHandlerThreadAudio)).mRecordAudio) {
            weakHandler = ((MediaMuxerWrapper)((Object)encoderHandlerThreadAudio)).mAudioPullerHandler;
            if (weakHandler != null) {
                ((AudioPullerHandlerThread)weakHandler).sendCloseAudio();
            } else {
                ((MediaMuxerWrapper)((Object)encoderHandlerThreadAudio)).mAudioPullerFinished = true;
            }
            EncoderHandlerThreadAudio encoderHandlerThreadAudio = ((MediaMuxerWrapper)((Object)encoderHandlerThreadAudio)).mAudioEncoderHandler;
            if (encoderHandlerThreadAudio != null) {
                encoderHandlerThreadAudio.sendStopRecording();
            }
        }
    }

    synchronized boolean isStarted() {
        return this.mMuxerStarted;
    }

    synchronized boolean isPaused() {
        return this.mPaused;
    }

    synchronized boolean start() {
        int n;
        MediaMuxerWrapper mediaMuxerWrapper = this;
        mediaMuxerWrapper.mStartedCount = n = mediaMuxerWrapper.mStartedCount + 1;
        int n2 = mediaMuxerWrapper.mEncoderCount;
        if (n2 > 0 && n == n2) {
            MediaMuxerWrapper mediaMuxerWrapper2 = this;
            mediaMuxerWrapper2.mMediaMuxer.start();
            mediaMuxerWrapper2.mMuxerStarted = true;
            mediaMuxerWrapper2.notifyAll();
        }
        return this.mMuxerStarted;
    }

    synchronized void stop() {
        int n;
        MediaMuxerWrapper mediaMuxerWrapper = this;
        mediaMuxerWrapper.mStartedCount = n = mediaMuxerWrapper.mStartedCount - 1;
        if (mediaMuxerWrapper.mEncoderCount > 0 && n <= 0) {
            MediaMuxerWrapper mediaMuxerWrapper2 = this;
            mediaMuxerWrapper2.mMediaMuxer.stop();
            mediaMuxerWrapper2.mMediaMuxer.release();
            mediaMuxerWrapper2.mMuxerStarted = false;
        }
    }

    synchronized int addTrack(MediaFormat mediaFormat, boolean bl) {
        if (!this.mMuxerStarted) {
            int n = this.mMediaMuxer.addTrack(mediaFormat);
            if (bl) {
                this.mAudioTrackIndex = n;
            }
            if (this.mRecordAudioType == 3) {
                this.mExternalAudioTrackIndex = this.mMediaMuxer.addTrack(this.mFormatAudio);
            }
            return n;
        }
        throw new IllegalStateException("Muxer already started");
    }

    synchronized void writeSampleData(int n, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        if (this.mPaused) {
            return;
        }
        if (this.mStartedCount > 0) {
            long l;
            int n2 = this.mAudioTrackIndex;
            if (n == n2) {
                long l2 = this.mAudioPresentationTimeUsLast;
                if (l2 != 0L && l2 >= bufferInfo.presentationTimeUs) {
                    Log.e((String)"MUXER", (String)("Skip AUDIO FRAME Time Prev = " + this.mAudioPresentationTimeUsLast + " > current " + bufferInfo.presentationTimeUs + " delta = " + (this.mAudioPresentationTimeUsLast - bufferInfo.presentationTimeUs)));
                } else {
                    this.mMediaMuxer.writeSampleData(n, byteBuffer, bufferInfo);
                    this.mAudioPresentationTimeUsLast = bufferInfo.presentationTimeUs;
                }
            } else if (n2 == -1 || (l = this.audioStartTimeNano) != -1L && l / 1000L <= bufferInfo.presentationTimeUs) {
                this.mMediaMuxer.writeSampleData(n, byteBuffer, bufferInfo);
            }
        }
    }

    public synchronized Surface getInputSurface() {
        return this.mVideoEncoder.getInputSurface();
    }

    public void frameAvailableSoon() {
        Object object = object.mVideoEncoderHandler;
        if (object != null) {
            ((EncoderHandlerThreadVideo)((Object)object)).frameAvailableSoon();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void waitForFinish() {
        if (!this.mRecordAudio) ** GOTO lbl9
        if (!this.mVideoFinished || !this.mAudioFinished || !this.mAudioPullerFinished) ** GOTO lbl6
        block2: while (true) {
            var1_1 = true;
            ** GOTO lbl11
lbl6:
            // 1 sources

            do {
                var1_1 = false;
                ** GOTO lbl11
lbl9:
                // 1 sources

                do {
                    var1_1 = this.mVideoFinished;
lbl11:
                    // 3 sources

                    if (var1_1) break block2;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException v0) {
                        v0.printStackTrace();
                    }
                } while (!this.mRecordAudio);
            } while (!this.mVideoFinished || !this.mAudioFinished || !this.mAudioPullerFinished);
        }
    }

    @Override
    public synchronized void onVideoEncodingFinished(long l) {
        this.mVideoFinished = true;
        this.mVideoDuration = l;
        this.checkAllFinished();
    }

    @Override
    public synchronized void onAudioEncodingFinished() {
        this.mAudioFinished = true;
        this.checkAllFinished();
    }

    @Override
    public void onAudioStopped() {
        this.mAudioPullerFinished = true;
        this.checkAllFinished();
    }

    @Override
    public void onAudioStarted(long l) {
        this.audioStartTimeNano = l;
    }
}

