/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.banuba.sdk.entity.RecordedVideoInfo;
import com.banuba.sdk.internal.encoding.RecordingListener;
import com.banuba.sdk.types.Data;
import java.lang.ref.WeakReference;

public final class RecordingListenerHandler
extends Handler {
    private static final int MSG_RECORDING_STATUS_CHANGE = 1;
    private static final int MSG_RECORDING_COMPLETED = 2;
    private static final int MSG_PHOTO_READY = 3;
    private static final int MSG_PROTO_PROCESSED = 5;
    private static final int MSG_IMAGE_PROCESSED = 6;
    private static final int MSG_EDITED_IMAGE_READY = 7;
    private static final int MSG_EDITING_MODE_FACE_FOUND = 8;
    private static final int MSG_ON_FRAME = 9;
    private final WeakReference weakListener;

    public RecordingListenerHandler(@NonNull RecordingListener recordingListener) {
        WeakReference<RecordingListener> weakReference;
        Object object = weakReference;
        weakReference = new WeakReference<RecordingListener>(recordingListener);
        v1.weakListener = object;
    }

    public RecordingListenerHandler(@NonNull RecordingListener recordingListener, @NonNull Looper looper) {
        super(looper);
        WeakReference<RecordingListener> weakReference;
        Object object = weakReference;
        weakReference = new WeakReference<RecordingListener>(recordingListener);
        v1.weakListener = object;
    }

    public final boolean sendRecordingStatusChange(boolean bl) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(1, bl));
    }

    public final boolean sendRecordingCompleted(@NonNull RecordedVideoInfo recordedVideoInfo) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessageAtFrontOfQueue(recordingListenerHandler.obtainMessage(2, recordedVideoInfo));
    }

    public final boolean sendPhotoReady(@NonNull Bitmap bitmap) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(3, bitmap));
    }

    public final boolean sendPhotoProcessed(@NonNull Bitmap bitmap) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(5, bitmap));
    }

    public final boolean sendImageProcessed(@NonNull Bitmap bitmap) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(6, bitmap));
    }

    public final boolean sendEditedImageReady(@NonNull Bitmap bitmap) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(7, bitmap));
    }

    public final boolean sendEditingModeFaceFound(boolean bl) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(8, bl));
    }

    public final boolean sendOnFrame(Data data, int n, int n2) {
        RecordingListenerHandler recordingListenerHandler = this;
        return recordingListenerHandler.sendMessage(recordingListenerHandler.obtainMessage(9, n, n2, data));
    }

    public void sendOnTextureFrame(int n, int n2, int n3, long l, float[] fArray) {
        RecordingListener recordingListener = (RecordingListener)((RecordingListenerHandler)((Object)recordingListener)).weakListener.get();
        if (recordingListener != null) {
            recordingListener.onTextureFrame(n, n2, n3, l, fArray);
        }
    }

    public void handleMessage(@NonNull Message message) {
        Object object = (RecordingListener)((RecordingListenerHandler)((Object)object)).weakListener.get();
        if (object != null) {
            switch (message.what) {
                default: {
                    throw new IllegalStateException("Unknown msg: " + message.what);
                }
                case 9: {
                    Object object2 = object;
                    Message message2 = message;
                    object = (Data)message2.obj;
                    int n = message2.arg1;
                    int n2 = message2.arg2;
                    object2.onFrame((Data)object, n, n2);
                    break;
                }
                case 8: {
                    object.onEditingModeFaceFound((Boolean)message.obj);
                    break;
                }
                case 7: {
                    object.onEditedImageReady((Bitmap)message.obj);
                    break;
                }
                case 6: {
                    object.onImageProcessed((Bitmap)message.obj);
                    break;
                }
                case 5: {
                    object.onHQPhotoProcessed((Bitmap)message.obj);
                    break;
                }
                case 3: {
                    object.onPhotoReady((Bitmap)message.obj);
                    break;
                }
                case 2: {
                    object.onRecordingCompleted((RecordedVideoInfo)message.obj);
                    break;
                }
                case 1: {
                    object.onRecordingStatusChange((Boolean)message.obj);
                }
            }
        }
    }
}

