/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.encoding;

import android.media.MediaFormat;
import android.os.Build;

public final class RecordingParams {
    private static final String VIDEO_MIME_TYPE = "video/avc";
    private static final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    private static final int VIDEO_BIT_RATE_8K = 0x7D0000;
    private static final int VIDEO_FRAME_RATE = 30;
    private static final int VIDEO_I_FRAME_INTERVAL_OLD_DEVICES = 1;
    private static final float VIDEO_I_FRAME_INTERVAL_FROM_ANDROID_7_1 = 0.1333f;
    private static final int AUDIO_SAMPLE_RATE = 44100;
    private static final int AUDIO_BIT_RATE = 64000;
    private static final int AUDIO_MAX_INPUT_SIZE = 44100;
    private static final int AUDIO_CHANNEL_CONFIG = 16;
    private static final int AUDIO_CHANNEL_COUNT = 1;
    private static final int AUDIO_FORMAT_ENCODING = 2;
    private static final int AUDIO_FORMAT_BYTES = 2;
    private static final int AUDIO_SAMPLE_SIZE = 2;

    private RecordingParams() {
    }

    public static MediaFormat getVideoFormat(int n, int n2) {
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)VIDEO_MIME_TYPE, (int)n, (int)n2);
        mediaFormat.setInteger("color-format", 2130708361);
        mediaFormat.setInteger("bitrate", 0x7D0000);
        mediaFormat.setInteger("frame-rate", 30);
        mediaFormat.setInteger("capture-rate", 30);
        RecordingParams.addVideoIFrameInterval(mediaFormat);
        return mediaFormat;
    }

    static MediaFormat getAudioFormat() {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)AUDIO_MIME_TYPE, (int)44100, (int)1);
        mediaFormat.setString("mime", AUDIO_MIME_TYPE);
        mediaFormat.setInteger("aac-profile", 2);
        mediaFormat.setInteger("channel-mask", 16);
        mediaFormat.setInteger("bitrate", 64000);
        mediaFormat.setInteger("channel-count", 1);
        mediaFormat.setInteger("max-input-size", 44100);
        return mediaFormat;
    }

    private static void addVideoIFrameInterval(MediaFormat mediaFormat) {
        if (Build.VERSION.SDK_INT >= 25) {
            mediaFormat.setFloat("i-frame-interval", 0.1333f);
        } else {
            mediaFormat.setInteger("i-frame-interval", 1);
        }
    }

    public static String getVideoMIME() {
        return VIDEO_MIME_TYPE;
    }

    public static int getCommonBitRate() {
        return 8256000;
    }

    static String getAudioMIME() {
        return AUDIO_MIME_TYPE;
    }

    public static int getAudioSampleRate() {
        return 44100;
    }

    public static int getAudio1msBlockLength(int n) {
        return n % 10 == 0 ? 45 : 44;
    }

    static int getChannelConfig() {
        return 16;
    }

    public static int getChannelCount() {
        return 1;
    }

    public static int getAudioFormatEncoding() {
        return 2;
    }

    public static int getAudioFormatBytes() {
        return 2;
    }

    public static int getOneMilliSizeBytes() {
        return 88;
    }

    public static int getAudioSampleSize() {
        return 2;
    }
}

