/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import com.banuba.sdk.internal.utils.Logger;

public final class EglCore {
    private static final String TAG = "EglCore";
    public static final int FLAG_RECORDABLE = 1;
    public static final int FLAG_TRY_GLES3 = 2;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private int mGlVersion = -1;

    public EglCore() {
        this(null, 0);
    }

    public EglCore(EGLContext object, int n) {
        if (objectArray2.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Object object2;
            if (object == null) {
                object = EGL14.EGL_NO_CONTEXT;
            }
            objectArray2.mEGLDisplay = object2 = EGL14.eglGetDisplay((int)0);
            if (object2 != EGL14.EGL_NO_DISPLAY) {
                int[] nArray = new int[2];
                if (EGL14.eglInitialize((EGLDisplay)object2, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                    if ((n & 2) != 0 && (object2 = objectArray2.getConfig(n, 3)) != null) {
                        int[] nArray2 = new int[3];
                        Object object3 = nArray2;
                        nArray2[0] = 12440;
                        nArray2[1] = 3;
                        nArray2[2] = 12344;
                        object3 = EGL14.eglCreateContext((EGLDisplay)objectArray2.mEGLDisplay, (EGLConfig)object2, (EGLContext)object, (int[])object3, (int)0);
                        if (EGL14.eglGetError() == 12288) {
                            objectArray2.mEGLConfig = object2;
                            objectArray2.mEGLContext = (EGLContext)object3;
                            objectArray2.mGlVersion = 3;
                        }
                    }
                    if (objectArray2.mEGLContext == EGL14.EGL_NO_CONTEXT) {
                        EGLConfig eGLConfig = objectArray2.getConfig(n, 2);
                        if (eGLConfig != null) {
                            int[] nArray3 = new int[3];
                            object2 = nArray3;
                            nArray3[0] = 12440;
                            nArray3[1] = 2;
                            nArray3[2] = 12344;
                            EGLContext eGLContext = EGL14.eglCreateContext((EGLDisplay)objectArray2.mEGLDisplay, (EGLConfig)eGLConfig, (EGLContext)object, (int[])object2, (int)0);
                            super.checkEglError("eglCreateContext");
                            objectArray2.mEGLConfig = eGLConfig;
                            objectArray2.mEGLContext = eGLContext;
                            objectArray2.mGlVersion = 2;
                        } else {
                            throw new RuntimeException("Unable to find a suitable EGLConfig");
                        }
                    }
                    object = new int[1];
                    EGL14.eglQueryContext((EGLDisplay)objectArray2.mEGLDisplay, (EGLContext)objectArray2.mEGLContext, (int)12440, (int[])object, (int)0);
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = (int)object[0];
                    Logger.d("EGL_CONTEXT_CLIENT_VERSION %d", objectArray2);
                    return;
                }
                objectArray2.mEGLDisplay = null;
                throw new RuntimeException("unable to initialize EGL14");
            }
            throw new RuntimeException("unable to get EGL14 display");
        }
        throw new RuntimeException("EGL already set up");
    }

    private EGLConfig getConfig(int n, int n2) {
        int[] nArray;
        int n3 = 4;
        if (n2 >= 3) {
            n3 = 68;
        }
        int[] nArray2 = new int[15];
        int[] nArray3 = nArray2;
        nArray2[0] = 12324;
        nArray2[1] = 8;
        nArray2[2] = 12323;
        nArray2[3] = 8;
        nArray2[4] = 12322;
        nArray2[5] = 8;
        nArray2[6] = 12321;
        nArray2[7] = 8;
        nArray2[8] = 12325;
        nArray2[9] = 0;
        nArray2[10] = 12352;
        nArray2[11] = n3;
        nArray2[12] = 12344;
        nArray2[13] = 0;
        nArray2[14] = 12344;
        if ((n & 1) != 0) {
            nArray3[12] = 12610;
            nArray3[13] = 1;
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)objectArray2.mEGLDisplay, (int[])nArray3, (int)0, (EGLConfig[])(objectArray2 = new EGLConfig[1]), (int)0, (int)1, (int[])(nArray = new int[1]), (int)0)) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            Logger.w("unable to find RGB8888 / %s EGLConfig", objectArray2);
            return null;
        }
        return objectArray2[0];
    }

    public static void logCurrent(String string) {
        EGLDisplay eGLDisplay = EGL14.eglGetCurrentDisplay();
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        EGLSurface eGLSurface = EGL14.eglGetCurrentSurface((int)12377);
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = eGLDisplay;
        objectArray[2] = eGLContext;
        objectArray[3] = eGLSurface;
        Logger.i("Current EGL ( %1$s ): display= %2$s, context= %3$s, surface=%4$s", objectArray2);
    }

    private void checkEglError(String string) {
        int n = EGL14.eglGetError();
        if (n == 12288) {
            return;
        }
        throw new RuntimeException(string + ": EGL error: 0x" + Integer.toHexString(n));
    }

    public EGLContext getEGLContext() {
        return this.mEGLContext;
    }

    public void release() {
        EGLDisplay eGLDisplay = this.mEGLDisplay;
        if (eGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EglCore eglCore = this;
            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
            EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)eglCore.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)eglCore.mEGLDisplay);
        }
        EglCore eglCore = this;
        eglCore.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        eglCore.mEGLContext = EGL14.EGL_NO_CONTEXT;
        eglCore.mEGLConfig = null;
    }

    protected void finalize() {
        block3: {
            try {
                if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) break block3;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            Logger.w("finalize: mEGLDisplay != EGL_NO_DISPLAY in EglCore", new Object[0]);
            this.release();
        }
        super.finalize();
    }

    public void releaseSurface(EGLSurface eGLSurface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface);
    }

    public EGLSurface createWindowSurface(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new RuntimeException("invalid surface: " + object);
        }
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 12344;
        object = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)object, (int[])nArray2, (int)0);
        this.checkEglError("eglCreateWindowSurface");
        if (object != null) {
            return object;
        }
        throw new RuntimeException("surface was null");
    }

    public EGLSurface createOffscreenSurface(int n, int n2) {
        int[] nArray = new int[5];
        int[] nArray2 = nArray;
        nArray[0] = 12375;
        nArray[1] = n;
        nArray[2] = 12374;
        nArray[3] = n2;
        nArray[4] = 12344;
        EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])nArray2, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (eGLSurface != null) {
            return eGLSurface;
        }
        throw new RuntimeException("surface was null");
    }

    public void makeCurrent(EGLSurface eGLSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Logger.d("EGL_NO_DISPLAY", new Object[0]);
        }
        if (EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)this.mEGLContext)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed. Code " + EGL14.eglGetError());
    }

    public void makeCurrent(EGLSurface eGLSurface, EGLSurface eGLSurface2) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Logger.d("EGL_NO_DISPLAY", new Object[0]);
        }
        if (EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface2, (EGLContext)this.mEGLContext)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent(draw,read) failed. Code " + EGL14.eglGetError());
    }

    public void makeNothingCurrent() {
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        if (EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed. Code " + EGL14.eglGetError());
    }

    public boolean swapBuffers(EGLSurface eGLSurface) {
        return EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface);
    }

    public void setPresentationTime(EGLSurface eGLSurface, long l) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (long)l);
    }

    public boolean isCurrent(EGLSurface eGLSurface) {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && eGLSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    public int querySurface(EGLSurface eGLSurface, int n) {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (int)n, (int[])nArray, (int)0);
        return nArray[0];
    }

    public String queryString(int n) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)n);
    }

    public int getGlVersion() {
        return this.mGlVersion;
    }
}

