/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.utils.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EglSurfaceBase {
    EglCore mEglCore;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private int mWidth = -1;
    private int mHeight = -1;

    EglSurfaceBase(EglCore eglCore) {
        this.mEglCore = eglCore;
    }

    void createWindowSurface(Object object) {
        if (this.mEGLSurface == EGL14.EGL_NO_SURFACE) {
            this.mEGLSurface = this.mEglCore.createWindowSurface(object);
            return;
        }
        throw new IllegalStateException("surface already created");
    }

    public void createOffscreenSurface(int n, int n2) {
        if (this.mEGLSurface == EGL14.EGL_NO_SURFACE) {
            this.mEGLSurface = this.mEglCore.createOffscreenSurface(n, n2);
            this.mWidth = n;
            this.mHeight = n2;
            return;
        }
        throw new IllegalStateException("surface already created");
    }

    public int getWidth() {
        int n = this.mWidth;
        if (n < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12375);
        }
        return n;
    }

    public int getHeight() {
        int n = this.mHeight;
        if (n < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12374);
        }
        return n;
    }

    void releaseEglSurface() {
        this.mEglCore.releaseSurface(this.mEGLSurface);
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mHeight = -1;
        this.mWidth = -1;
    }

    public void makeCurrent() {
        this.mEglCore.makeCurrent(this.mEGLSurface);
    }

    public void makeCurrentReadFrom(EglSurfaceBase eglSurfaceBase) {
        EglSurfaceBase eglSurfaceBase2 = eglSurfaceBase2.mEGLSurface;
        eglSurfaceBase2.mEglCore.makeCurrent((EGLSurface)eglSurfaceBase2, eglSurfaceBase.mEGLSurface);
    }

    public boolean swapBuffers() {
        boolean bl = this.mEglCore.swapBuffers(this.mEGLSurface);
        if (!bl) {
            Logger.d("WARNING: swapBuffers() failed", new Object[0]);
        }
        return bl;
    }

    public void setPresentationTime(long l) {
        this.mEglCore.setPresentationTime(this.mEGLSurface, l);
    }

    public void saveFrame(File object) {
        if (this.mEglCore.isCurrent(this.mEGLSurface)) {
            BufferedOutputStream bufferedOutputStream;
            object = ((File)object).toString();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Object[] objectArray = ByteBuffer.allocateDirect(n * n2 * 4);
            objectArray.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)objectArray);
            GlUtils.checkGlErrorNoException("glReadPixels");
            objectArray.rewind();
            BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
            bufferedOutputStream2(new FileOutputStream((String)object));
            Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Bitmap bitmap2 = bitmap;
            bitmap.copyPixelsFromBuffer((Buffer)objectArray);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bufferedOutputStream2);
            try {
                bitmap2.recycle();
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                Logger.e(iOException.getMessage(), new Object[0]);
            }
            Object[] objectArray2 = new Object[3];
            objectArray = objectArray2;
            objectArray[0] = n;
            objectArray2[1] = n2;
            objectArray2[2] = object;
            Logger.d("Saved %1$dx%2$d frame as %3$s", objectArray);
            return;
        }
        throw new RuntimeException("Expected EGL context/surface is not current");
    }
}

