/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import com.banuba.sdk.frame.FramePixelBuffer;
import com.banuba.sdk.internal.YuvConversionMatrices;
import com.banuba.sdk.internal.gl.GLFrameSurfaceHandler;
import com.banuba.sdk.internal.gl.GLShaderProgram;
import com.banuba.sdk.internal.gl.GLTexture;
import com.banuba.sdk.internal.gl.GlUtils;
import java.nio.ByteBuffer;

public class GLFramePixelBufferRenderer
extends GLFrameSurfaceHandler {
    private static final String FRAGMENT_SHADER_PROGRAM_PLANAR = "#version 300 es\nprecision mediump float;\nuniform sampler2D uTexture;\nuniform vec2 uRatio;\nin vec2 vTexCoord;\nout vec4 outFragColor;\nvoid main() {\n  vec4 color = texture(uTexture, vTexCoord);\n  if (color.a < 1.0f) {\n    float modX = mod(vTexCoord.x * uRatio.x, 0.1);\n    float modY = mod(vTexCoord.y * uRatio.y, 0.1);\n    vec3 bgColor = modX >= 0.05 ^^ modY >= 0.05 ? vec3(1.0) : vec3(0.94);\n    outFragColor = vec4(mix(bgColor, color.rgb, color.a), color.a);\n  } else {\n    outFragColor = color;\n  }\n}\n";
    private static final String FRAGMENT_SHADER_PROGRAM_I420 = "#version 300 es\nprecision mediump float;\nuniform sampler2D uTextureY;\nuniform sampler2D uTextureU;\nuniform sampler2D uTextureV;\nuniform vec4 uCvtR;\nuniform vec4 uCvtG;\nuniform vec4 uCvtB;\nin vec2 vTexCoord;\nout vec4 outFragColor;\nvoid main() {\n  float ty = texture(uTextureY, vTexCoord).x;\n  float tu = texture(uTextureU, vTexCoord).x;\n  float tv = texture(uTextureV, vTexCoord).x;\n  vec3 yuv = vec3(ty, tu, tv);\n  outFragColor = vec4(\n    dot(yuv, uCvtR.xyz) + uCvtR.w,\n    dot(yuv, uCvtG.xyz) + uCvtG.w,\n    dot(yuv, uCvtB.xyz) + uCvtB.w,\n    1.0f);\n}\n";
    static final /* synthetic */ boolean $assertionsDisabled;
    private boolean mI420RendererIsInit = false;
    private boolean mPlanarRendererIsInit = false;
    private int mPlanarRendererColorComponents = 0;
    private GLShaderProgram mShader;
    private GLTexture[] mTextures;
    private int[] mUniformCvt;
    private int mUniformRatio;

    private void initI420Renderer() {
        GLTexture gLTexture;
        GLTexture gLTexture2;
        GLTexture gLTexture3;
        if (!$assertionsDisabled && (this.mI420RendererIsInit || this.mPlanarRendererIsInit)) {
            throw new AssertionError();
        }
        GLFramePixelBufferRenderer gLFramePixelBufferRenderer = this;
        gLFramePixelBufferRenderer.mShader = new GLShaderProgram("#version 300 es\nprecision mediump float;\nlayout (location = 0) in vec3 aPosition;\nlayout (location = 1) in vec2 aTextureCoord;\nout vec2 vTexCoord;\nvoid main() {\n  gl_Position = vec4(aPosition, 1.0);\n  vTexCoord = aTextureCoord;\n}\n", FRAGMENT_SHADER_PROGRAM_I420);
        GLTexture[] gLTextureArray = new GLTexture[3];
        Object object = gLTexture3;
        gLTexture3 = new GLTexture(1);
        gLTextureArray[0] = object;
        object = gLTexture2;
        gLTexture2 = new GLTexture(1);
        gLTextureArray[1] = object;
        object = gLTexture;
        gLTexture = new GLTexture(1);
        gLTextureArray[2] = object;
        this.mTextures = gLTextureArray;
        gLTextureArray[0].associateWithUniformAndTextureUnit(this.mShader.getUniformLocation("uTextureY"), 0);
        gLFramePixelBufferRenderer.mTextures[1].associateWithUniformAndTextureUnit(this.mShader.getUniformLocation("uTextureU"), 1);
        gLFramePixelBufferRenderer.mTextures[2].associateWithUniformAndTextureUnit(this.mShader.getUniformLocation("uTextureV"), 2);
        int[] nArray = new int[3];
        object = nArray;
        object[0] = this.mShader.getUniformLocation("uCvtR");
        object[1] = this.mShader.getUniformLocation("uCvtG");
        nArray[2] = this.mShader.getUniformLocation("uCvtB");
        gLFramePixelBufferRenderer.mUniformCvt = nArray;
        gLFramePixelBufferRenderer.mI420RendererIsInit = true;
    }

    private void initPlanarRenderer(int n) {
        GLTexture gLTexture;
        if (!$assertionsDisabled && (this.mI420RendererIsInit || this.mPlanarRendererIsInit)) {
            throw new AssertionError();
        }
        this.mShader = new GLShaderProgram("#version 300 es\nprecision mediump float;\nlayout (location = 0) in vec3 aPosition;\nlayout (location = 1) in vec2 aTextureCoord;\nout vec2 vTexCoord;\nvoid main() {\n  gl_Position = vec4(aPosition, 1.0);\n  vTexCoord = aTextureCoord;\n}\n", FRAGMENT_SHADER_PROGRAM_PLANAR);
        GLTexture[] gLTextureArray = new GLTexture[1];
        GLTexture gLTexture2 = gLTexture;
        gLTexture2(n);
        gLTextureArray[0] = gLTexture2;
        this.mTextures = gLTextureArray;
        gLTexture.associateWithUniformAndTextureUnit(this.mShader.getUniformLocation("uTexture"), 0);
        this.mUniformRatio = this.mShader.getUniformLocation("uRatio");
        this.mPlanarRendererIsInit = true;
    }

    private void clearRenderer() {
        if (this.mI420RendererIsInit || this.mPlanarRendererIsInit) {
            GLTexture[] gLTextureArray = this.mTextures;
            int n = this.mTextures.length;
            for (int i = 0; i < n; ++i) {
                gLTextureArray[i].close();
            }
            this.mTextures = null;
            this.mShader.close();
            this.mShader = null;
            this.mUniformCvt = null;
            this.mPlanarRendererIsInit = false;
            this.mI420RendererIsInit = false;
        }
    }

    static {
        $assertionsDisabled = GLFramePixelBufferRenderer.class.desiredAssertionStatus() ^ true;
    }

    public void draw(FramePixelBuffer object) {
        int n;
        Object object2 = ((FramePixelBuffer)object).getFormat();
        if (object2.isBpc8()) {
            n = object2.getPixelComponents();
            if (!this.mPlanarRendererIsInit || this.mPlanarRendererColorComponents != n) {
                this.clearRenderer();
                this.initPlanarRenderer(n);
                this.mPlanarRendererColorComponents = n;
            }
        } else if (!this.mI420RendererIsInit && object2.isI420()) {
            this.clearRenderer();
            this.initI420Renderer();
        }
        GlUtils.checkGlErrorNoException("GLFramePixelBufferRenderer.draw.init");
        this.mShader.use();
        if (object2.isBpc8()) {
            if (((FramePixelBuffer)object).getWidth() > ((FramePixelBuffer)object).getHeight()) {
                this.mShader.setUniformVec2(this.mUniformRatio, (float)((FramePixelBuffer)object).getWidth() / (float)((FramePixelBuffer)object).getHeight(), 1.0f);
            } else {
                this.mShader.setUniformVec2(this.mUniformRatio, 1.0f, (float)((FramePixelBuffer)object).getHeight() / (float)((FramePixelBuffer)object).getWidth());
            }
            int n2 = ((FramePixelBuffer)object).getBytesPerRow() / ((FramePixelBuffer)object).getBytesPerPixel();
            FramePixelBuffer framePixelBuffer = object;
            object = framePixelBuffer.getBuffer();
            n = framePixelBuffer.getWidth();
            int n3 = framePixelBuffer.getHeight();
            this.mTextures[0].setTextureData((ByteBuffer)object, n, n3, n2);
            this.mTextures[0].bind();
        } else if (object2.isI420()) {
            object2 = YuvConversionMatrices.getConvMatrixFromYuvToRgb(object2.getColorStandard(), object2.getColorRange());
            this.mShader.setUniformVec4(this.mUniformCvt[0], (float[])object2, 0);
            this.mShader.setUniformVec4(this.mUniformCvt[1], (float[])object2, 4);
            this.mShader.setUniformVec4(this.mUniformCvt[2], (float[])object2, 8);
            int n4 = 0;
            while (true) {
                Object object3 = this.mTextures;
                if (n4 >= this.mTextures.length) break;
                GLTexture gLTexture = object3[n4];
                object3 = ((FramePixelBuffer)object).getPlane(n4);
                int n5 = ((FramePixelBuffer)object).getWidthOfPlane(n4);
                int n6 = ((FramePixelBuffer)object).getHeightOfPlane(n4);
                int n7 = ((FramePixelBuffer)object).getBytesPerRowOfPlane(n4);
                gLTexture.setTextureData((ByteBuffer)object3, n5, n6, n7);
                this.mTextures[n4].bind();
                ++n4;
            }
        }
        this.drawSurface();
        GLTexture.unbind();
        GLShaderProgram.unuse();
        GlUtils.checkGlErrorNoException("GLFramePixelBufferRenderer.draw");
    }

    @Override
    public void close() {
        GLFramePixelBufferRenderer gLFramePixelBufferRenderer = this;
        gLFramePixelBufferRenderer.clearRenderer();
        super.close();
        GlUtils.checkGlErrorNoException("GLFramePixelBufferRenderer.close");
    }
}

