/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.GLES20;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.TextureVBO;
import com.banuba.sdk.internal.gl.TextureVBODrawable;

public class GLFullRectTexture
implements AutoCloseable {
    private static final float DEPTH = 0.0f;
    private static final float[] RECTANGLE_VERTEX = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] RECTANGLE_TEXTURE_UV = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private final int mVertexCount;
    private final TextureVBODrawable mTextureVBODrawable;
    private final float[] mIdentityMatrix = GlUtils.getIdentityMatrix();
    private final int[] mVBO;

    public GLFullRectTexture(boolean bl) {
        this.mTextureVBODrawable = new TextureVBO(bl);
        this.mVertexCount = RECTANGLE_VERTEX.length / 3;
        this.mVBO = GlUtils.setupVertexTextureBuffers(RECTANGLE_VERTEX, RECTANGLE_TEXTURE_UV);
    }

    @Override
    public void close() {
        GLFullRectTexture gLFullRectTexture = object;
        gLFullRectTexture.mTextureVBODrawable.close();
        Object object = gLFullRectTexture.mVBO;
        GLES20.glDeleteBuffers((int)gLFullRectTexture.mVBO.length, (int[])object, (int)0);
    }

    public void draw(int n, float[] fArray) {
        GLFullRectTexture gLFullRectTexture = this;
        int n2 = gLFullRectTexture.mVertexCount;
        float[] fArray2 = gLFullRectTexture.mIdentityMatrix;
        n2 = gLFullRectTexture.mVBO[0];
        int n3 = gLFullRectTexture.mVBO[1];
        this.mTextureVBODrawable.draw(n2, fArray2, fArray, n, n2, n3, 1.0f);
    }

    public void draw(int n) {
        GLFullRectTexture gLFullRectTexture = this;
        int n2 = gLFullRectTexture.mVertexCount;
        float[] fArray = gLFullRectTexture.mIdentityMatrix;
        n2 = gLFullRectTexture.mVBO[0];
        int n3 = gLFullRectTexture.mVBO[1];
        this.mTextureVBODrawable.draw(n2, fArray, fArray, n, n2, n3, 1.0f);
    }
}

