/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.GLES30;
import android.os.Build;
import android.util.Size;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;
import com.banuba.sdk.internal.YuvConversionMatrices;
import com.banuba.sdk.internal.gl.GLFrameSurfaceHandler;
import com.banuba.sdk.internal.gl.GLShaderProgram;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.player.Orientation;
import com.banuba.sdk.types.PixelFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GLOrientableTextureReader
extends GLFrameSurfaceHandler {
    private static final String FRAGMENT_SHADER_PROGRAM_PLANAR = "#version 300 es\nprecision mediump float;\nuniform sampler2D sTexture;\nin vec2 vTexCoord;\nout vec4 outFragColor;\nvoid main()  {\n  outFragColor = texture(sTexture, vTexCoord);\n}\n";
    private static final String FRAGMENT_SHADER_PROGRAM_I420 = "#version 300 es\nprecision mediump float;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\nuniform sampler2D sTexture;\nin vec2 vTexCoord;\nout vec4 outFragColor;\nvoid main() {\n  outFragColor.r = coeffs.a + dot(coeffs.rgb, texture(sTexture, vTexCoord - 1.5 * xUnit).rgb);\n  outFragColor.g = coeffs.a + dot(coeffs.rgb, texture(sTexture, vTexCoord - 0.5 * xUnit).rgb);\n  outFragColor.b = coeffs.a + dot(coeffs.rgb, texture(sTexture, vTexCoord + 0.5 * xUnit).rgb);\n  outFragColor.a = coeffs.a + dot(coeffs.rgb, texture(sTexture, vTexCoord + 1.5 * xUnit).rgb);\n}\n";
    private RenderBuffer mFrameBuffer;
    private GLShaderProgram mShader;
    private int mUniformSampler;
    private boolean mYuvProcessorUsing = false;
    private boolean mPlanarProcessorUsing = false;
    private boolean mProcessorWasChanged = false;
    private Size mSize;
    private Size mHalfSize;
    private int mPixelStepLocation;
    private int mCoeffsLocation;
    private boolean mUpdateSteps = true;
    private float[] mPixelStepSign;
    private float[] mPixelSteps;
    private float[] mCvtMat;
    private final boolean mUsePBO;
    private final int PBO_BUFFERS_MAX;
    private int[] mPBO;
    private int mPBOBufferSize;
    private int mPBOReadBufferIndex = 0;
    private int mPBOMapBufferIndex = 0;

    public GLOrientableTextureReader() {
        this(false);
    }

    public GLOrientableTextureReader(boolean bl) {
        this.PBO_BUFFERS_MAX = 2;
        if (!GLOrientableTextureReader.isPBOSupported() && bl) {
            throw new RuntimeException("GLOrientableTextureReader: PixelBufferObject is not supported");
        }
        this.mUsePBO = bl;
        this.setFormat(PixelFormat.RGBA);
    }

    @ChecksSdkIntAtLeast(api=24)
    public static boolean isPBOSupported() {
        return Build.VERSION.SDK_INT >= 24;
    }

    private void initYuvProcessor() {
        GLOrientableTextureReader gLOrientableTextureReader = this;
        gLOrientableTextureReader.clearProcessor();
        this.mShader = new GLShaderProgram("#version 300 es\nprecision mediump float;\nlayout (location = 0) in vec3 aPosition;\nlayout (location = 1) in vec2 aTextureCoord;\nout vec2 vTexCoord;\nvoid main() {\n  gl_Position = vec4(aPosition, 1.0);\n  vTexCoord = aTextureCoord;\n}\n", FRAGMENT_SHADER_PROGRAM_I420);
        gLOrientableTextureReader.mUniformSampler = this.mShader.getUniformLocation("sTexture");
        gLOrientableTextureReader.mPixelStepLocation = gLOrientableTextureReader.mShader.getUniformLocation("xUnit");
        gLOrientableTextureReader.mCoeffsLocation = gLOrientableTextureReader.mShader.getUniformLocation("coeffs");
        gLOrientableTextureReader.mYuvProcessorUsing = true;
        gLOrientableTextureReader.mProcessorWasChanged = true;
        GlUtils.checkGlErrorNoException("GLOrientableTextureReader.initYuvProcessor");
    }

    private void initPlanarProcessor() {
        this.clearProcessor();
        this.mShader = new GLShaderProgram("#version 300 es\nprecision mediump float;\nlayout (location = 0) in vec3 aPosition;\nlayout (location = 1) in vec2 aTextureCoord;\nout vec2 vTexCoord;\nvoid main() {\n  gl_Position = vec4(aPosition, 1.0);\n  vTexCoord = aTextureCoord;\n}\n", FRAGMENT_SHADER_PROGRAM_PLANAR);
        this.mUniformSampler = this.mShader.getUniformLocation("sTexture");
        this.mPlanarProcessorUsing = true;
        this.mProcessorWasChanged = true;
        GlUtils.checkGlErrorNoException("GLOrientableTextureReader.initPlanarProcessor");
    }

    private void initPBO() {
        if (this.mUsePBO && GLOrientableTextureReader.isPBOSupported()) {
            this.clearPBO();
            int[] nArray = new int[2];
            this.mPBO = nArray;
            GLES30.glGenBuffers((int)2, (int[])nArray, (int)0);
            for (int i = 0; i < 2; ++i) {
                GLOrientableTextureReader gLOrientableTextureReader = this;
                GLES30.glBindBuffer((int)35051, (int)gLOrientableTextureReader.mPBO[i]);
                GLES30.glBufferData((int)35051, (int)gLOrientableTextureReader.mPBOBufferSize, null, (int)35041);
            }
            GLES30.glBindBuffer((int)35051, (int)0);
        }
    }

    private void clearPBO() {
        int[] nArray = this.mPBO;
        if (this.mPBO != null) {
            GLES30.glDeleteBuffers((int)2, (int[])nArray, (int)0);
            this.mPBO = null;
        }
    }

    private void clearProcessor() {
        GLShaderProgram gLShaderProgram = this.mShader;
        if (gLShaderProgram != null) {
            gLShaderProgram.close();
            this.mShader = null;
        }
        GLOrientableTextureReader gLOrientableTextureReader = this;
        gLOrientableTextureReader.mPlanarProcessorUsing = false;
        gLOrientableTextureReader.mYuvProcessorUsing = false;
    }

    private void prepare(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        this.mPBOBufferSize = 0;
        if (this.mPlanarProcessorUsing) {
            n3 = n + 1 & 0xFFFFFFFE;
            this.mPBOBufferSize = GLOrientableTextureReader.calculateMinBufferSize(n, n2, PixelFormat.RGBA);
            n4 = n2;
        } else if (this.mYuvProcessorUsing) {
            int n5 = n2;
            n3 = GLOrientableTextureReader.calculateStrideForPlane(n, 0) / 4;
            n4 = n5 + n5 / 2;
            this.mPBOBufferSize = GLOrientableTextureReader.calculateMinYuvBufferSize(n, n5);
        }
        RenderBuffer renderBuffer = this.mFrameBuffer;
        if (renderBuffer != null && (renderBuffer.getWidth() != n3 || this.mFrameBuffer.getHeight() != n4 || this.mProcessorWasChanged)) {
            Size size;
            Size size2;
            this.mFrameBuffer.resize(n3, n4);
            renderBuffer = size2;
            size2 = new Size(n3, n2);
            this.mSize = renderBuffer;
            renderBuffer = size;
            int n6 = n3 / 2;
            size = new Size(n6, n2 / 2);
            this.mHalfSize = renderBuffer;
            this.initPBO();
            this.mUpdateSteps = true;
            this.mProcessorWasChanged = false;
        }
        if (this.mFrameBuffer == null) {
            Size size;
            Size size3;
            renderBuffer = size3;
            size3 = new Size(n3, n2);
            this.mSize = renderBuffer;
            renderBuffer = size;
            int n7 = n2;
            n2 = n3 / 2;
            size = new Size(n2, n7 / 2);
            this.mHalfSize = renderBuffer;
            this.mFrameBuffer = RenderBuffer.prepareFrameBuffer(n3, n4);
            this.initPBO();
        }
        if (this.mUpdateSteps) {
            float f = n;
            float f2 = this.mPixelStepSign[0] / f;
            f = this.mPixelStepSign[1] / f;
            float[] fArray = new float[4];
            float[] fArray2 = fArray;
            fArray2[0] = f2;
            fArray2[1] = f;
            fArray2[2] = f2 * 2.0f;
            fArray[3] = f * 2.0f;
            this.mPixelSteps = fArray2;
            this.mUpdateSteps = false;
        }
    }

    private void render(int n, int n2, int n3) {
        this.prepare(n2, n3);
        this.mShader.use();
        GlUtils.setupSampler(0, this.mUniformSampler, n, false);
        GLES30.glBindFramebuffer((int)36160, (int)this.mFrameBuffer.getFrameBufferId());
        GLES30.glDisable((int)3042);
        GLES30.glDisable((int)2929);
        GLES30.glDisable((int)2884);
        GLES30.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GLES30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES30.glClear((int)16384);
        if (this.mYuvProcessorUsing) {
            float[] fArray = this.mCvtMat;
            this.mShader.setUniformVec4(this.mCoeffsLocation, fArray, 0);
            this.mShader.setUniformVec2(this.mPixelStepLocation, this.mPixelSteps, 0);
            n2 = this.mSize.getWidth();
            n3 = this.mSize.getHeight();
            GLES30.glViewport((int)0, (int)0, (int)n2, (int)n3);
            this.drawSurface();
            this.mShader.setUniformVec4(this.mCoeffsLocation, fArray, 4);
            this.mShader.setUniformVec2(this.mPixelStepLocation, this.mPixelSteps, 2);
            n2 = this.mHalfSize.getWidth();
            n3 = this.mHalfSize.getHeight();
            GLES30.glViewport((int)0, (int)this.mSize.getHeight(), (int)n2, (int)n3);
            this.drawSurface();
            this.mShader.setUniformVec4(this.mCoeffsLocation, fArray, 8);
            this.mShader.setUniformVec2(this.mPixelStepLocation, this.mPixelSteps, 2);
            GLES30.glViewport((int)this.mHalfSize.getWidth(), (int)this.mSize.getHeight(), (int)this.mHalfSize.getWidth(), (int)this.mHalfSize.getHeight());
            this.drawSurface();
        } else if (this.mPlanarProcessorUsing) {
            n = this.mFrameBuffer.getWidth();
            n2 = this.mFrameBuffer.getHeight();
            GLES30.glViewport((int)0, (int)0, (int)n, (int)n2);
            this.drawSurface();
        }
        GLES30.glBindFramebuffer((int)36160, (int)0);
        GLShaderProgram.unuse();
        GlUtils.checkGlErrorNoException("GLOrientableTextureReader.render");
    }

    public static int calculateStrideForPlane(int n, int n2) {
        return n + 7 & 0xFFFFFFF8;
    }

    public static int calculateOffsetForPlane(int n, int n2, int n3) {
        if (n3 == 1) {
            return GLOrientableTextureReader.calculateStrideForPlane(n, n3) * n2;
        }
        if (n3 == 2) {
            n = GLOrientableTextureReader.calculateStrideForPlane(n, n3);
            return n * n2 + n / 2;
        }
        return 0;
    }

    public static int[] calculateStrides(int n) {
        n = GLOrientableTextureReader.calculateStrideForPlane(n, 0);
        return new int[]{n, n, n};
    }

    public static int[] calculateOffsets(int n, int n2) {
        n = GLOrientableTextureReader.calculateStrideForPlane(n, 0);
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray2[0] = 0;
        nArray2[1] = n2 = n * n2;
        nArray[2] = n2 + n / 2;
        return nArray;
    }

    public static int calculateMinYuvBufferSize(int n, int n2) {
        return GLOrientableTextureReader.calculateStrideForPlane(n, 0) * n2 * 3 / 2;
    }

    public static int calculateMinBufferSize(int n, int n2, PixelFormat pixelFormat) {
        if (pixelFormat == PixelFormat.RGBA) {
            return GLOrientableTextureReader.calculateStrideForPlane(n * 4, 0) * n2;
        }
        throw new RuntimeException("Unsupported pxiel format: " + pixelFormat);
    }

    public void setFormat(ColorStd colorStd, ColorRange colorRange) {
        this.mCvtMat = YuvConversionMatrices.getConvMatrixFromRgbToYuv(colorStd, colorRange);
        if (!this.mYuvProcessorUsing) {
            this.initYuvProcessor();
        }
    }

    public void setFormat(PixelFormat pixelFormat) {
        if (pixelFormat == PixelFormat.RGBA) {
            if (!this.mPlanarProcessorUsing) {
                this.initPlanarProcessor();
            }
            return;
        }
        throw new RuntimeException("Unsupported pxiel format: " + pixelFormat);
    }

    @Override
    public void setOrientation(Orientation object, boolean bl) {
        Orientation orientation = Orientation.LEFT;
        if (object == orientation) {
            object = Orientation.RIGHT;
        } else if (object == Orientation.RIGHT) {
            object = orientation;
        }
        super.setOrientation((Orientation)((Object)object), bl);
        this.mPixelStepSign = new float[]{0.0f, 0.0f};
        switch (1.$SwitchMap$com$banuba$sdk$player$Orientation[object.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                boolean bl2 = bl;
                object = this.mPixelStepSign;
                bl = true;
                float f = bl2 ? 1.0f : -1.0f;
                object[bl] = (Orientation)f;
                break;
            }
            case 3: {
                boolean bl3 = bl;
                object = this.mPixelStepSign;
                bl = false;
                float f = bl3 ? 1.0f : -1.0f;
                object[bl] = (Orientation)f;
                break;
            }
            case 2: {
                boolean bl4 = bl;
                object = this.mPixelStepSign;
                bl = true;
                float f = bl4 ? -1.0f : 1.0f;
                object[bl] = (Orientation)f;
                break;
            }
            case 1: {
                boolean bl5 = bl;
                object = this.mPixelStepSign;
                bl = false;
                float f = bl5 ? -1.0f : 1.0f;
                object[bl] = (Orientation)f;
            }
        }
        this.mUpdateSteps = true;
    }

    public ByteBuffer mapOrientedTextureData(int n, int n2, int n3) {
        this.render(n, n2, n3);
        if (GLOrientableTextureReader.isPBOSupported()) {
            int[] nArray = this.mPBO;
            if (this.mPBO != null) {
                int n4;
                GLOrientableTextureReader gLOrientableTextureReader = this;
                this.mPBOReadBufferIndex = n2 = (this.mPBOReadBufferIndex + 1) % 2;
                int n5 = nArray[n2];
                this.mPBOMapBufferIndex = n4 = (n2 + 1) % 2;
                n4 = nArray[n4];
                GLES30.glBindFramebuffer((int)36160, (int)gLOrientableTextureReader.mFrameBuffer.getFrameBufferId());
                GLES30.glBindBuffer((int)35051, (int)n5);
                n5 = gLOrientableTextureReader.mFrameBuffer.getWidth();
                n2 = gLOrientableTextureReader.mFrameBuffer.getHeight();
                GLES30.glReadPixels((int)0, (int)0, (int)n5, (int)n2, (int)6408, (int)5121, (int)0);
                GLES30.glBindFramebuffer((int)36160, (int)0);
                GLES30.glBindBuffer((int)35051, (int)n4);
                n5 = gLOrientableTextureReader.mPBOBufferSize;
                ByteBuffer byteBuffer = (ByteBuffer)GLES30.glMapBufferRange((int)35051, (int)0, (int)n5, (int)1);
                GLES30.glBindBuffer((int)35051, (int)0);
                GlUtils.checkGlErrorNoException("GLOrientableTextureReader.mapOrientedTextureData");
                return byteBuffer;
            }
        }
        throw new RuntimeException("Pixel buffer object was not created.");
    }

    public void unmapPBO() {
        int[] nArray = ((GLOrientableTextureReader)object).mPBO;
        if (((GLOrientableTextureReader)object).mPBO != null) {
            GLES30.glBindBuffer((int)35051, (int)nArray[((GLOrientableTextureReader)object).mPBOMapBufferIndex]);
            int[] nArray2 = new int[1];
            Object object = nArray2;
            nArray2[0] = 0;
            GLES30.glGetBufferParameteriv((int)35051, (int)35004, (int[])object, (int)0);
            if (nArray2[0] == 1) {
                GLES30.glUnmapBuffer((int)35051);
            }
            GLES30.glBindBuffer((int)35051, (int)0);
            GlUtils.checkGlErrorNoException("GLOrientableTextureReader.unmapPBO");
        }
    }

    public void readOrientedTextureData(int n, int n2, int n3, @NonNull ByteBuffer byteBuffer) {
        GLOrientableTextureReader gLOrientableTextureReader = this;
        gLOrientableTextureReader.render(n, n2, n3);
        GLES30.glBindFramebuffer((int)36160, (int)gLOrientableTextureReader.mFrameBuffer.getFrameBufferId());
        int n4 = gLOrientableTextureReader.mFrameBuffer.getWidth();
        n = gLOrientableTextureReader.mFrameBuffer.getHeight();
        GLES30.glReadPixels((int)0, (int)0, (int)n4, (int)n, (int)6408, (int)5121, (Buffer)byteBuffer);
        GLES30.glBindFramebuffer((int)36160, (int)0);
    }

    @Override
    public void close() {
        GLOrientableTextureReader gLOrientableTextureReader = this;
        gLOrientableTextureReader.clearProcessor();
        gLOrientableTextureReader.clearPBO();
        RenderBuffer renderBuffer = gLOrientableTextureReader.mFrameBuffer;
        if (renderBuffer != null) {
            renderBuffer.clear();
            this.mFrameBuffer = null;
        }
        super.close();
    }
}

