/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.Matrix;
import com.banuba.sdk.internal.gl.Scalable;

public abstract class GLScalableRect
implements Scalable,
AutoCloseable {
    protected float[] mDrawMatrix = new float[16];
    private float mScaleX;
    private float mScaleY;
    private float mAngle;
    private float mPosX;
    private float mPosY;
    private float mOffsetX = 0.0f;
    private float mOffsetY = 0.0f;
    private boolean mMatrixReady;
    private float[] mModelViewMatrix = new float[16];

    @Override
    public void setScale(float f, float f2) {
        GLScalableRect gLScalableRect = this;
        gLScalableRect.mScaleX = f;
        gLScalableRect.mScaleY = f2;
        gLScalableRect.mMatrixReady = false;
    }

    @Override
    public void setPosition(float f, float f2) {
        GLScalableRect gLScalableRect = this;
        gLScalableRect.mPosX = f;
        gLScalableRect.mPosY = f2;
        gLScalableRect.mMatrixReady = false;
    }

    @Override
    public void setOffset(float f, float f2) {
        GLScalableRect gLScalableRect = this;
        gLScalableRect.mOffsetX = f;
        gLScalableRect.mOffsetY = f2;
        gLScalableRect.mMatrixReady = false;
    }

    @Override
    public void setRotation(float f) {
        while (f >= 360.0f) {
            f -= 360.0f;
        }
        while (f <= -360.0f) {
            f += 360.0f;
        }
        GLScalableRect gLScalableRect = this;
        gLScalableRect.mAngle = f;
        gLScalableRect.mMatrixReady = false;
    }

    public abstract void setScreenSize(int var1, int var2);

    protected float[] getModelViewMatrix() {
        if (!this.mMatrixReady) {
            GLScalableRect gLScalableRect = this;
            Matrix.setIdentityM((float[])gLScalableRect.mModelViewMatrix, (int)0);
            GLScalableRect gLScalableRect2 = this;
            float f = gLScalableRect2.mPosX + this.mOffsetX;
            float f2 = gLScalableRect2.mPosY + this.mOffsetY;
            Matrix.translateM((float[])gLScalableRect.mModelViewMatrix, (int)0, (float)f, (float)f2, (float)0.0f);
            if (Float.compare(gLScalableRect.mAngle, 0.0f) != 0) {
                Matrix.rotateM((float[])this.mModelViewMatrix, (int)0, (float)this.mAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GLScalableRect gLScalableRect3 = this;
            f = gLScalableRect3.mScaleX;
            f2 = gLScalableRect3.mScaleY;
            Matrix.scaleM((float[])this.mModelViewMatrix, (int)0, (float)f, (float)f2, (float)1.0f);
        }
        return this.mModelViewMatrix;
    }
}

