/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Size;
import com.banuba.sdk.entity.PositionProvider;
import com.banuba.sdk.entity.SizeProvider;
import com.banuba.sdk.entity.WatermarkInfo;
import com.banuba.sdk.internal.gl.GLScalableRect;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.TextureVBO;
import com.banuba.sdk.internal.gl.TextureVBODrawable;
import com.banuba.sdk.internal.utils.Logger;

public class GLScalableRectTexture
extends GLScalableRect {
    private static final float DEPTH = 0.0f;
    private static final float[] RECTANGLE_VERTEX = new float[]{-0.5f, -0.5f, 0.0f, 0.5f, -0.5f, 0.0f, -0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 0.0f};
    private static final float[] RECTANGLE_TEXTURE_UV = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private final Drawable mOriginalDrawable;
    private final SizeProvider mSizeProvider;
    private final PositionProvider mPositionProvider;
    private final boolean mIsDrawableSupportsScaling;
    private final float[] mDrawMatrix;
    private int[] mVBO;
    private int mVertexCount;
    private int mTextureID;
    private TextureVBODrawable mTextureVBODrawable;
    private Size currentSize;

    public GLScalableRectTexture(WatermarkInfo watermarkInfo) {
        Size size;
        GLScalableRectTexture gLScalableRectTexture = gLScalableRectTexture5;
        GLScalableRectTexture gLScalableRectTexture2 = gLScalableRectTexture5;
        GLScalableRectTexture gLScalableRectTexture3 = gLScalableRectTexture5;
        GLScalableRectTexture gLScalableRectTexture4 = gLScalableRectTexture5;
        gLScalableRectTexture5.mDrawMatrix = new float[16];
        GLScalableRectTexture gLScalableRectTexture5 = watermarkInfo.getWatermarkDrawable();
        gLScalableRectTexture4.mOriginalDrawable = gLScalableRectTexture5;
        gLScalableRectTexture3.mSizeProvider = watermarkInfo.getSizeProvider();
        gLScalableRectTexture2.mPositionProvider = watermarkInfo.getPositionProvider();
        gLScalableRectTexture.mIsDrawableSupportsScaling = watermarkInfo.isDrawableSupportsScaling();
        Size size2 = size;
        WatermarkInfo watermarkInfo2 = watermarkInfo;
        int n = watermarkInfo2.getDefaultWidth();
        gLScalableRectTexture.currentSize = new Size(n, watermarkInfo2.getDefaultHeight());
        gLScalableRectTexture.initTextureDrawable((Drawable)gLScalableRectTexture5, size2);
    }

    private void initTextureDrawable(Drawable drawable, Size size) {
        GLScalableRectTexture gLScalableRectTexture = this;
        Size size2 = size;
        int n = size2.getWidth();
        gLScalableRectTexture.mTextureID = GlUtils.createTextureFromDrawable(drawable, n, size2.getHeight());
        gLScalableRectTexture.mTextureVBODrawable = new TextureVBO(false);
        this.mVertexCount = RECTANGLE_VERTEX.length / 3;
        gLScalableRectTexture.mVBO = GlUtils.setupVertexTextureBuffers(RECTANGLE_VERTEX, RECTANGLE_TEXTURE_UV);
    }

    private void releaseTextureDrawable() {
        GLScalableRectTexture gLScalableRectTexture = object;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = ((GLScalableRectTexture)object).mTextureID;
        GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
        gLScalableRectTexture.mTextureVBODrawable.close();
        Object object = gLScalableRectTexture.mVBO;
        GLES20.glDeleteBuffers((int)gLScalableRectTexture.mVBO.length, (int[])object, (int)0);
    }

    public int getWidth() {
        return this.currentSize.getWidth();
    }

    public int getHeight() {
        return this.currentSize.getHeight();
    }

    @Override
    public void close() {
        this.releaseTextureDrawable();
    }

    public void draw(float[] fArray) {
        this.draw(fArray, 1.0f);
    }

    public void draw(float[] fArray, float f) {
        GLScalableRectTexture gLScalableRectTexture = this;
        float[] fArray2 = this.getModelViewMatrix();
        Matrix.multiplyMM((float[])gLScalableRectTexture.mDrawMatrix, (int)0, (float[])fArray, (int)0, (float[])fArray2, (int)0);
        GLScalableRectTexture gLScalableRectTexture2 = this;
        int n = gLScalableRectTexture2.mVertexCount;
        fArray = gLScalableRectTexture2.mDrawMatrix;
        fArray2 = GlUtils.getIdentityMatrix();
        int n2 = gLScalableRectTexture2.mTextureID;
        n = gLScalableRectTexture2.mVBO[0];
        int n3 = gLScalableRectTexture2.mVBO[1];
        gLScalableRectTexture.mTextureVBODrawable.draw(n, fArray, fArray2, n2, n, n3, f);
    }

    @Override
    public void setScreenSize(int n, int n2) {
        Size size;
        GLScalableRectTexture gLScalableRectTexture = this;
        Size size2 = size;
        size = new Size(n, n2);
        Size size3 = gLScalableRectTexture.mSizeProvider.provide(size2);
        if (gLScalableRectTexture.mIsDrawableSupportsScaling && !size3.equals((Object)this.currentSize)) {
            try {
                this.releaseTextureDrawable();
            }
            catch (Exception exception) {
                Logger.w(exception, "Failed during release of texture drawable", new Object[0]);
            }
            GLScalableRectTexture gLScalableRectTexture2 = this;
            gLScalableRectTexture2.initTextureDrawable(gLScalableRectTexture2.mOriginalDrawable, size3);
            this.currentSize = size3;
        }
    }

    public void updatePosition(int n, int n2) {
        Size size;
        GLScalableRectTexture gLScalableRectTexture = gLScalableRectTexture2;
        GLScalableRectTexture gLScalableRectTexture2 = size;
        size = new Size(n, n2);
        PointF pointF = gLScalableRectTexture.mPositionProvider.provide((Size)gLScalableRectTexture2);
        float f = pointF.x;
        gLScalableRectTexture.setPosition(f, pointF.y);
    }
}

