/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.GLES20;
import android.util.Log;
import androidx.annotation.Keep;
import com.banuba.sdk.internal.gl.GlUtils;
import java.io.Closeable;

@Keep
public class GLShaderProgram
implements Closeable {
    private static final String TAG = "GLShaderProgram";
    private int mShaderProgram;

    public GLShaderProgram(String string, String string2) {
        this.mShaderProgram = GlUtils.loadProgram(string, string2);
        if (this.mShaderProgram == 0) {
            Log.e((String)TAG, (String)"Unable to load shader program");
        }
    }

    public static void unuse() {
        GLES20.glUseProgram((int)0);
    }

    @Override
    public void close() {
        int n = this.mShaderProgram;
        if (n != 0) {
            GLES20.glDeleteProgram((int)n);
            this.mShaderProgram = 0;
        }
    }

    public void use() {
        GLES20.glUseProgram((int)this.mShaderProgram);
    }

    public int getProgramId() {
        return this.mShaderProgram;
    }

    public int getAttributeLocation(String string) {
        int n = GLES20.glGetAttribLocation((int)this.mShaderProgram, (String)string);
        if (n == -1) {
            Log.e((String)TAG, (String)("Unknown attribute name: " + string));
        }
        return n;
    }

    public int getUniformLocation(String string) {
        int n = GLES20.glGetUniformLocation((int)this.mShaderProgram, (String)string);
        if (n == -1) {
            Log.e((String)TAG, (String)("Unknown uniform name: " + string));
        }
        return n;
    }

    public void setUniformTexture(int n, int n2) {
        GLES20.glUniform1i((int)n, (int)n2);
    }

    public void setUniformMat4(int n, float[] fArray, int n2) {
        GLES20.glUniformMatrix4fv((int)n, (int)1, (boolean)false, (float[])fArray, (int)n2);
    }

    public void setUniformVec4(int n, float[] fArray, int n2) {
        GLES20.glUniform4fv((int)n, (int)1, (float[])fArray, (int)n2);
    }

    public void setUniformVec2(int n, float f, float f2) {
        GLES20.glUniform2f((int)n, (float)f, (float)f2);
    }

    public void setUniformVec2(int n, float[] fArray, int n2) {
        GLES20.glUniform2fv((int)n, (int)1, (float[])fArray, (int)n2);
    }
}

