/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.GLES20;
import android.opengl.GLES30;
import androidx.annotation.Keep;
import com.banuba.sdk.internal.gl.GlUtils;
import java.io.Closeable;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@Keep
public class GLTexture
implements Closeable {
    private static final int[] TEXTURE_FORMATS;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final int[] mTexture;
    private final int mGlFormat;
    private int mTextureUnitNumber;
    private int mUniformLocation;

    public GLTexture(int n) {
        if (!($assertionsDisabled || n >= 1 && n <= 4)) {
            throw new AssertionError();
        }
        this.mGlFormat = TEXTURE_FORMATS[n + -1];
        int[] nArray = new int[1];
        this.mTexture = nArray;
        GLES30.glGenTextures((int)1, (int[])nArray, (int)0);
        int n2 = nArray[0];
        if (n2 != 0) {
            GLES30.glBindTexture((int)3553, (int)n2);
            GLES30.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES30.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES30.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES30.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        }
        GlUtils.checkGlErrorNoException("GLTexture");
        GLTexture.unbind();
    }

    public static void unbind() {
        GLES30.glBindTexture((int)3553, (int)0);
        GLES30.glActiveTexture((int)33984);
    }

    static {
        $assertionsDisabled = GLTexture.class.desiredAssertionStatus() ^ true;
        TEXTURE_FORMATS = new int[]{6409, 33319, 6407, 6408};
    }

    public void associateWithUniformAndTextureUnit(int n, int n2) {
        if (!($assertionsDisabled || n2 >= 0 && n2 <= 9)) {
            throw new AssertionError();
        }
        GLTexture gLTexture = this;
        gLTexture.mUniformLocation = n;
        gLTexture.mTextureUnitNumber = n2;
    }

    public void bind() {
        GLTexture gLTexture = this;
        GLES30.glActiveTexture((int)(gLTexture.mTextureUnitNumber + 33984));
        GLES30.glBindTexture((int)3553, (int)gLTexture.mTexture[0]);
        GLES20.glUniform1i((int)gLTexture.mUniformLocation, (int)this.mTextureUnitNumber);
    }

    public void setTextureData(ByteBuffer byteBuffer, int n, int n2, int n3) {
        GLTexture gLTexture = this;
        GLES30.glActiveTexture((int)(gLTexture.mTextureUnitNumber + 33984));
        GLES30.glBindTexture((int)3553, (int)gLTexture.mTexture[0]);
        GLES30.glPixelStorei((int)3314, (int)n3);
        int n4 = gLTexture.mGlFormat;
        GLES20.glTexImage2D((int)3553, (int)0, (int)n4, (int)n, (int)n2, (int)0, (int)n4, (int)5121, (Buffer)byteBuffer);
        GLES30.glPixelStorei((int)3314, (int)0);
    }

    public int getTextureId() {
        return this.mTexture[0];
    }

    @Override
    public void close() {
        Object object = ((GLTexture)object).mTexture;
        GLES30.glDeleteTextures((int)((GLTexture)object).mTexture.length, (int[])object, (int)0);
    }
}

