/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.RawRes;
import com.banuba.sdk.internal.utils.Logger;
import java.io.File;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public final class GlUtils {
    public static final PrecisionEnum PRECISION = PrecisionEnum.highp;
    public static final int MATRIX_SIZE = 16;
    public static final int FLOAT_SIZE = 4;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int OFFSET_ZERO = 0;
    public static final int COUNT_ONE = 1;
    public static final int DEPTH_NEAR = -100;
    public static final int DEPTH_FAR = 100;
    public static final int VERTEX_PER_FACE = 3;
    public static final int COORDS_PER_VERTEX = 3;
    public static final int COORDS_UV_PER_TEXTURE = 2;
    public static final int VERTEX_STRIDE = 12;
    public static final int TEXTURE_STRIDE = 8;
    public static final int GL_DEFAULT_RENDER_BUFFER = 0;
    public static final int GL_DEFAULT_TEXTURE_ID = 0;
    public static final int GL_DEFAULT_PROGRAM_ID = 0;
    public static final int GL_TEXTURE0 = 0;
    public static final int GL_TEXTURE1 = 1;
    public static final int GL_TEXTURE2 = 2;
    public static final int GL_TEXTURE3 = 3;
    public static final int GL_TEXTURE4 = 4;
    public static final float MAX_COLOR_FLOAT_VALUE = 255.0f;
    public static final float DEFAULT_ALPHA = 1.0f;
    private static final int GL_ES_20_INT = 131072;
    private static final int MAX_VARYING_VECTORS = 36348;
    private static final float[] IDENTITY_MATRIX = new float[16];
    private static final BitmapFactory.Options DEFAULT_BITMAP_OPTIONS;
    private static final boolean DETAILED_LOG = false;
    private static final int SIZEOF_FLOAT = 4;
    private static final float TEXTURE_CENTER = 0.5f;

    private GlUtils() {
    }

    public static void copyMatrix(@NonNull float[] fArray, @NonNull float[] fArray2) {
        System.arraycopy(fArray, 0, fArray2, 0, 16);
    }

    public static float[] getIdentityMatrix() {
        return IDENTITY_MATRIX;
    }

    public static float[] getNewIdentityMatrix() {
        float[] fArray = new float[16];
        System.arraycopy(IDENTITY_MATRIX, 0, fArray, 0, 16);
        return fArray;
    }

    public static FloatBuffer initFloatBuffer(float[] fArray) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray).position(0);
        return floatBuffer;
    }

    public static void initColorArray(float[] fArray, int n) {
        fArray[0] = (float)Color.red((int)n) / 255.0f;
        fArray[1] = (float)Color.green((int)n) / 255.0f;
        fArray[2] = (float)Color.blue((int)n) / 255.0f;
        fArray[3] = (float)Color.alpha((int)n) / 255.0f;
    }

    public static boolean detectOpenGLES20(Context context) {
        return ((ActivityManager)context.getSystemService((String)"activity")).getDeviceConfigurationInfo().reqGlEsVersion >= 131072;
    }

    public static int loadShader(int n, String objectArray) {
        int n2 = GLES20.glCreateShader((int)n);
        GlUtils.checkGlErrorNoException("glCreateShader type=" + n);
        GLES20.glShaderSource((int)n2, (String)objectArray);
        GLES20.glCompileShader((int)n2);
        int[] nArray = new int[1];
        objectArray = nArray;
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])objectArray, (int)0);
        if (nArray[0] == 0) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = n;
            objectArray2[1] = GLES20.glGetShaderInfoLog((int)n2);
            Logger.e("Could not compile shader %1$d: %2$s", objectArray);
            GLES20.glDeleteShader((int)n2);
            n2 = 0;
        }
        return n2;
    }

    public static int loadProgram(@NonNull String string, @NonNull String string2) {
        int[] nArray = new int[1];
        int n = GlUtils.loadShader(35633, string);
        if (n == 0) {
            return 0;
        }
        int n2 = GlUtils.loadShader(35632, string2);
        if (n2 == 0) {
            GLES20.glDeleteShader((int)n);
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3;
        GLES20.glAttachShader((int)n3, (int)n);
        GLES20.glAttachShader((int)n4, (int)n2);
        GLES20.glLinkProgram((int)n4);
        GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = GLES20.glGetProgramInfoLog((int)n3);
            Logger.e("Error linking program: %s", objectArray2);
            GLES20.glDeleteProgram((int)n3);
            return 0;
        }
        GLES20.glDeleteShader((int)n);
        GLES20.glDeleteShader((int)n2);
        return n3;
    }

    public static int loadTextureFromFile(@NonNull File file) {
        if ((file = BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)DEFAULT_BITMAP_OPTIONS)) != null) {
            return GlUtils.loadTextureInternal((Bitmap)file, false);
        }
        return 0;
    }

    public static int loadTextureFromBitmap(@NonNull Bitmap bitmap) {
        return GlUtils.loadTextureInternal(bitmap, false);
    }

    public static int loadTextureFromRawRes(@RawRes int n, Context context) {
        return GlUtils.loadTextureInternal(BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(n), null, (BitmapFactory.Options)DEFAULT_BITMAP_OPTIONS), true);
    }

    public static int createTextureFromDrawable(Drawable drawable, int n, int n2) {
        Canvas canvas;
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)GlUtils.DEFAULT_BITMAP_OPTIONS.inPreferredConfig);
        Drawable drawable2 = drawable;
        drawable = canvas;
        int n3 = new Canvas(bitmap).getWidth();
        n2 = drawable.getHeight();
        drawable2.setBounds(0, 0, n3, n2);
        drawable2.draw((Canvas)drawable);
        return GlUtils.loadTextureInternal(bitmap, true);
    }

    private static int loadTextureInternal(@NonNull Bitmap bitmap, boolean bl) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n = nArray[0];
        if (n != 0) {
            GLES20.glBindTexture((int)3553, (int)n);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            bitmap.recycle();
        }
        if (bl && nArray[0] == 0) {
            throw new RuntimeException("Error loading texture.");
        }
        return nArray[0];
    }

    public static int loadTextureLuminance(@NonNull ByteBuffer byteBuffer, int n, int n2, int n3) {
        int n4;
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n5 = nArray[0];
        if (n5 != 0) {
            GLES20.glBindTexture((int)3553, (int)n5);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)n3, (int)n, (int)n2, (int)0, (int)n3, (int)5121, (Buffer)byteBuffer);
        }
        if ((n4 = nArray[0]) != 0) {
            return n4;
        }
        throw new RuntimeException("Error loading texture.");
    }

    public static int createExternalTextureObject() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GlUtils.checkGlErrorNoException("glGenTextures");
        int n = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n);
        GlUtils.checkGlErrorNoException("glBindTexture " + n);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtils.checkGlErrorNoException("glTexParameter");
        return n;
    }

    public static void setupBlend() {
        try {
            GLES20.glBlendFuncSeparate((int)770, (int)771, (int)770, (int)771);
            GLES20.glBlendEquationSeparate((int)32774, (int)32774);
        }
        catch (Exception exception) {
            GLES20.glBlendFunc((int)770, (int)771);
        }
    }

    public static void printGlInfo() {
        int[] nArray = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])nArray, (int)0);
        Logger.i(" Open GL Max Texture Size = " + nArray[0], new Object[0]);
        GLES20.glGetIntegerv((int)34930, (int[])nArray, (int)0);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = " Open GL Max Texture Units = " + nArray[0];
        Logger.i("INFO", objectArray2);
        GLES20.glGetIntegerv((int)36348, (int[])nArray, (int)0);
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = " Open GL Max Varing Vectors(vec4) = " + nArray[0] + " or " + nArray[0] * 4 + " floats ";
        Logger.i("INFO", objectArray2);
    }

    public static int setupVertexBuffer(float[] fArray) {
        FloatBuffer floatBuffer = GlUtils.createFloatBuffer(fArray);
        int[] nArray = new int[1];
        GLES20.glGenBuffers((int)1, (int[])nArray, (int)0);
        GLES20.glBindBuffer((int)34962, (int)nArray[0]);
        GLES20.glBufferData((int)34962, (int)(fArray.length * 4), (Buffer)floatBuffer, (int)35044);
        GLES20.glBindBuffer((int)34962, (int)0);
        return nArray[0];
    }

    public static int[] setupVertexTextureBuffers(float[] fArray, float[] fArray2) {
        FloatBuffer floatBuffer = GlUtils.createFloatBuffer(fArray);
        FloatBuffer floatBuffer2 = GlUtils.createFloatBuffer(fArray2);
        int[] nArray = new int[2];
        GLES20.glGenBuffers((int)2, (int[])nArray, (int)0);
        GLES20.glBindBuffer((int)34962, (int)nArray[0]);
        GLES20.glBufferData((int)34962, (int)(fArray.length * 4), (Buffer)floatBuffer, (int)35044);
        GLES20.glBindBuffer((int)34962, (int)nArray[1]);
        GLES20.glBufferData((int)34962, (int)(fArray2.length * 4), (Buffer)floatBuffer2, (int)35044);
        GLES20.glBindBuffer((int)34962, (int)0);
        return nArray;
    }

    public static void multiplyMM(float[] fArray, float[] fArray2, float[] fArray3) {
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray3, (int)0);
    }

    public static void multiplyMM4(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        float[] fArray6 = fArray;
        fArray = new float[16];
        float[] fArray7 = new float[16];
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray3, (int)0);
        Matrix.multiplyMM((float[])fArray7, (int)0, (float[])fArray, (int)0, (float[])fArray4, (int)0);
        Matrix.multiplyMM((float[])fArray6, (int)0, (float[])fArray7, (int)0, (float[])fArray5, (int)0);
    }

    public static void checkGlError(String string) {
        int n = GLES20.glGetError();
        if (n == 0) {
            return;
        }
        string = string + ": glError 0x" + Integer.toHexString(n) + " (" + GLU.gluErrorString((int)n) + ")";
        Logger.e(string, new Object[0]);
        throw new RuntimeException(string);
    }

    public static void checkGlErrorNoException(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Logger.e(string + ": glError 0x" + Integer.toHexString(n) + " (" + GLU.gluErrorString((int)n) + ")", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setupSampler(int n, int n2, int n3, boolean bl) {
        void var3_6;
        int n4 = n;
        n = 33984;
        int n5 = 0;
        switch (n4) {
            default: {
                break;
            }
            case 4: {
                n = 33988;
                n5 = 4;
                break;
            }
            case 3: {
                n = 33987;
                n5 = 3;
                break;
            }
            case 2: {
                n = 33986;
                n5 = 2;
                break;
            }
            case 1: {
                n = 33985;
                n5 = 1;
            }
        }
        if (bl) {
            int n6 = 36197;
        } else {
            int n7 = 3553;
        }
        GLES20.glActiveTexture((int)n);
        GLES20.glBindTexture((int)var3_6, (int)n3);
        GLES20.glUniform1i((int)n2, (int)n5);
    }

    public static int createProgram(String string, String string2) {
        int n = GlUtils.loadShader(35633, string);
        if (n == 0) {
            return 0;
        }
        int n2 = GlUtils.loadShader(35632, string2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        GlUtils.checkGlErrorNoException("glCreateProgram");
        if (n3 == 0) {
            Logger.e("Could not create program", new Object[0]);
        }
        int n4 = n3;
        GLES20.glAttachShader((int)n3, (int)n);
        GlUtils.checkGlErrorNoException("glAttachShader");
        GLES20.glAttachShader((int)n4, (int)n2);
        GlUtils.checkGlErrorNoException("glAttachShader");
        GLES20.glLinkProgram((int)n4);
        Object[] objectArray = new int[1];
        GLES20.glGetProgramiv((int)n3, (int)35714, (int[])objectArray, (int)0);
        if (objectArray[0] != 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = GLES20.glGetProgramInfoLog((int)n3);
            Logger.e("Could not link program: %s", objectArray);
            GLES20.glDeleteProgram((int)n3);
            n3 = 0;
        }
        return n3;
    }

    public static void checkLocation(int n, String string) {
        if (n >= 0) {
            return;
        }
        throw new RuntimeException("Unable to locate '" + string + "' in program");
    }

    public static int createImageTexture(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n4 = nArray[0];
        GlUtils.checkGlErrorNoException("glGenTextures");
        GLES20.glBindTexture((int)3553, (int)n4);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlUtils.checkGlErrorNoException("loadImageTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)n3, (int)n, (int)n2, (int)0, (int)n3, (int)5121, (Buffer)byteBuffer);
        GlUtils.checkGlErrorNoException("loadImageTexture");
        return n4;
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static void logVersionInfo() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = GLES20.glGetString((int)7936);
        objectArray[1] = GLES20.glGetString((int)7937);
        objectArray[2] = GLES20.glGetString((int)7938);
        Logger.i("vendor: %1$s, renderer: %2$s, version: %3$s", objectArray2);
    }

    public static void calculateCameraMatrix(float[] fArray, float f, int n) {
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        float[] fArray5 = new float[16];
        float[] fArray6 = new float[16];
        float[] fArray7 = new float[16];
        Matrix.setIdentityM((float[])fArray7, (int)0);
        if (n == 2) {
            Matrix.scaleM((float[])fArray7, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
        } else if (n == 1) {
            Matrix.scaleM((float[])fArray7, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
        Matrix.setIdentityM((float[])fArray3, (int)0);
        Matrix.setIdentityM((float[])fArray4, (int)0);
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray3, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.translateM((float[])fArray4, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        Matrix.setRotateM((float[])fArray2, (int)0, (float)f, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.multiplyMM((float[])fArray5, (int)0, (float[])fArray3, (int)0, (float[])fArray2, (int)0);
        Matrix.multiplyMM((float[])fArray6, (int)0, (float[])fArray5, (int)0, (float[])fArray7, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray6, (int)0, (float[])fArray4, (int)0);
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
        DEFAULT_BITMAP_OPTIONS = new BitmapFactory.Options();
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        new BitmapFactory.Options().inScaled = false;
        new BitmapFactory.Options().inPremultiplied = false;
        new BitmapFactory.Options().inMutable = false;
    }

    private static enum PrecisionEnum {
        mediump,
        highp;

    }
}

