/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.media.Image;
import android.opengl.GLES20;
import android.opengl.GLES30;
import androidx.annotation.NonNull;
import com.banuba.sdk.internal.gl.GlUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class ImageRenderer {
    private static final String SHADER_VERTEX = "uniform mat4 uTextureMatrix;\nuniform mat4 uVertexMatrix;\nattribute vec4 a_position;\nattribute vec2 a_texCoord;\nvarying vec2 v_texCoord;\nvoid main() {\n  gl_Position = uVertexMatrix * a_position;\n  vec4 texCoord = vec4(a_texCoord, 0.0, 1.0);\n  v_texCoord = (uTextureMatrix * texCoord).xy;\n}\n";
    private static final String SHADER_FRAG = "precision highp float;\nvarying vec2 v_texCoord;\nuniform sampler2D s_baseMapY;\nuniform sampler2D s_baseMapCh1;\nuniform sampler2D s_baseMapCh2;\nuniform vec4 v_cvtR;\nuniform vec4 v_cvtG;\nuniform vec4 v_cvtB;\nvoid main() {\n  float y = texture2D(s_baseMapY, v_texCoord).r;\n  float tu = texture2D(s_baseMapCh1, v_texCoord).r;\n  float tv = texture2D(s_baseMapCh2, v_texCoord).r;\n  vec3 yuv = vec3(y, tu, tv); \n  vec3 rgb = vec3 (\n    dot(yuv, v_cvtR.xyz) + v_cvtR.w, \n    dot(yuv, v_cvtG.xyz) + v_cvtG.w, \n    dot(yuv, v_cvtB.xyz) + v_cvtB.w); \n  gl_FragColor = vec4(rgb, 1.0);\n}\n";
    private static final float[] RECTANGLE_TEXTURE_UV = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] RECTANGLE_TEXTURE_UV_SWAP = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] RECTANGLE_VERTEX = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] MAT_CVT_FROM_BT709_FULL_RANGE_TO_RGB = new float[]{1.0f, 0.0f, 1.5748f, -0.7904878f, 1.0f, -0.18732427f, -0.46812427f, 0.32900947f, 1.0f, 1.8556f, 0.0f, -0.93143845f};
    private final int[] mTextures;
    private final int mAttributePosition;
    private final int mAttributeTextureCoord;
    private final int mUniformVertexMatrix;
    private final int mUniformTextureMatrix;
    private final int[] mVBO;
    protected final int mProgramHandle;
    private final int mUniformSamplerY;
    private final int mUniformSamplerCh1;
    private final int mUniformSamplerCh2;
    private final float[] mIdentity;
    private final int mUniformCvtR;
    private final int mUniformCvtG;
    private final int mUniformCvtB;

    public ImageRenderer() {
        int n;
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        ImageRenderer imageRenderer = this;
        imageRenderer.mTextures = nArray2;
        nArray2 = new int[3];
        this.mVBO = nArray2;
        GLES20.glGenBuffers((int)nArray2.length, (int[])nArray2, (int)0);
        ImageRenderer.loadBufferData(nArray2[0], RECTANGLE_VERTEX);
        ImageRenderer.loadBufferData(nArray2[1], RECTANGLE_TEXTURE_UV);
        ImageRenderer.loadBufferData(nArray2[2], RECTANGLE_TEXTURE_UV_SWAP);
        this.mProgramHandle = n = GlUtils.loadProgram(SHADER_VERTEX, SHADER_FRAG);
        this.mAttributePosition = GLES20.glGetAttribLocation((int)n, (String)"a_position");
        this.mAttributeTextureCoord = GLES20.glGetAttribLocation((int)n, (String)"a_texCoord");
        this.mUniformVertexMatrix = GLES20.glGetUniformLocation((int)n, (String)"uVertexMatrix");
        this.mUniformTextureMatrix = GLES20.glGetUniformLocation((int)n, (String)"uTextureMatrix");
        this.mUniformSamplerY = GLES20.glGetUniformLocation((int)n, (String)"s_baseMapY");
        this.mUniformSamplerCh1 = GLES20.glGetUniformLocation((int)n, (String)"s_baseMapCh1");
        this.mUniformSamplerCh2 = GLES20.glGetUniformLocation((int)n, (String)"s_baseMapCh2");
        this.mUniformCvtR = GLES20.glGetUniformLocation((int)n, (String)"v_cvtR");
        this.mUniformCvtG = GLES20.glGetUniformLocation((int)n, (String)"v_cvtG");
        imageRenderer.mUniformCvtB = GLES20.glGetUniformLocation((int)n, (String)"v_cvtB");
        imageRenderer.mIdentity = GlUtils.getIdentityMatrix();
        ImageRenderer.makeTextures(nArray);
        GlUtils.checkGlError("LOAD");
    }

    public static void loadBufferData(int n, @NonNull float[] object) {
        object = ImageRenderer.createFloatBuffer(object);
        GLES20.glBindBuffer((int)34962, (int)n);
        GLES20.glBufferData((int)34962, (int)(((float[])object).length * 4), (Buffer)object, (int)35044);
    }

    private static FloatBuffer createFloatBuffer(@NonNull float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public static void makeTextures(int[] nArray) {
        GLES20.glGenTextures((int)nArray.length, (int[])nArray, (int)0);
        for (int n : nArray) {
            if (n != 0) {
                GLES20.glBindTexture((int)3553, (int)n);
                GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
                GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                continue;
            }
            throw new RuntimeException("Error loading texture.");
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public void draw(@NonNull Image object) {
        Image image = object;
        Object object2 = image.getPlanes()[0];
        GLES20.glBindTexture((int)3553, (int)this.mTextures[0]);
        GLES30.glPixelStorei((int)3314, (int)object2.getRowStride());
        int n = image.getWidth();
        int n2 = image.getHeight();
        object2 = object2.getBuffer().position(0);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n, (int)n2, (int)0, (int)6409, (int)5121, (Buffer)object2);
        for (int i = 1; i < 3; ++i) {
            Image.Plane plane = object.getPlanes()[i];
            n2 = plane.getPixelStride() == 1 ? 6409 : 6410;
            int n3 = plane.getPixelStride() == 1 ? plane.getRowStride() : plane.getRowStride() / plane.getPixelStride();
            Image image2 = object;
            GLES20.glBindTexture((int)3553, (int)this.mTextures[i]);
            GLES30.glPixelStorei((int)3314, (int)n3);
            n = image2.getWidth() / 2;
            n3 = image2.getHeight() / 2;
            Buffer buffer = plane.getBuffer().position(0);
            GLES20.glTexImage2D((int)3553, (int)0, (int)n2, (int)n, (int)n3, (int)0, (int)n2, (int)5121, (Buffer)buffer);
        }
        GLES20.glUseProgram((int)this.mProgramHandle);
        GLES20.glBindBuffer((int)34962, (int)this.mVBO[0]);
        GLES20.glVertexAttribPointer((int)this.mAttributePosition, (int)3, (int)5126, (boolean)false, (int)12, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mAttributePosition);
        GLES20.glBindBuffer((int)34962, (int)this.mVBO[1]);
        GLES20.glVertexAttribPointer((int)this.mAttributeTextureCoord, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mAttributeTextureCoord);
        object = this.mIdentity;
        GLES20.glUniformMatrix4fv((int)this.mUniformVertexMatrix, (int)1, (boolean)false, (float[])object, (int)0);
        object = this.mIdentity;
        GLES20.glUniformMatrix4fv((int)this.mUniformTextureMatrix, (int)1, (boolean)false, (float[])object, (int)0);
        int n4 = this.mTextures[0];
        GlUtils.setupSampler(0, this.mUniformSamplerY, n4, false);
        n4 = this.mTextures[1];
        GlUtils.setupSampler(1, this.mUniformSamplerCh1, n4, false);
        n4 = this.mTextures[2];
        GlUtils.setupSampler(2, this.mUniformSamplerCh2, n4, false);
        float[] fArray = MAT_CVT_FROM_BT709_FULL_RANGE_TO_RGB;
        GLES20.glUniform4fv((int)this.mUniformCvtR, (int)1, (float[])fArray, (int)0);
        GLES20.glUniform4fv((int)this.mUniformCvtG, (int)1, (float[])fArray, (int)4);
        GLES20.glUniform4fv((int)this.mUniformCvtB, (int)1, (float[])fArray, (int)8);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mAttributePosition);
        GLES20.glDisableVertexAttribArray((int)this.mAttributeTextureCoord);
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20.glUseProgram((int)0);
    }
}

